/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCoreMessages;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Java2WSValidateInputCommand
extends AbstractDataModelOperation {
    private Java2WSDataModel model;

    public Java2WSValidateInputCommand(Java2WSDataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IJavaProject javaProject = JDTUtils.getJavaProject((String)this.model.getProjectName());
        if (javaProject != null) {
            IType type = JDTUtils.findType((IJavaProject)javaProject, (String)this.model.getJavaStartingPoint());
            if (type == null || !type.exists()) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", CXFCreationCoreMessages.bind((String)CXFCreationCoreMessages.JAVA2WS_SERVICE_IMPL_NOT_FOUND, (Object[])new Object[]{this.model.getJavaStartingPoint(), this.model.getProjectName()}));
            } else if (type.isBinary()) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", CXFCreationCoreMessages.JAVA2WS_SERVICE_IMPL_NOT_BINARY);
            }
        }
        return status;
    }
}

