/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.RemoveComponentFromEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.dialogs.DependencyConflictResolveDialog;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;
import org.eclipse.jst.j2ee.navigator.internal.plugin.J2EENavigatorPlugin;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.EARFacetUtils;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.BundledNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.GroupEARProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class AddProjectToEARDropAssistant
extends CommonDropAdapterAssistant {
    private static final Class IPROJECT_CLASS = IProject.class;
    private IVirtualComponent earComponent = null;
    private IProject earProject = null;
    private String libDir = null;
    private boolean resolveConflicts = false;

    public boolean isSupportedType(TransferData aTransferType) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(aTransferType);
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(aDropAdapter.getCurrentTransfer())) {
            final IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            this.resolveConflicts = false;
            for (Object sourceObject : selection) {
                IProject projectToAdd;
                if (sourceObject instanceof IVirtualReference) {
                    IVirtualReference reference = (IVirtualReference)sourceObject;
                    IPath libDirPath = null;
                    if (this.libDir != null) {
                        libDirPath = new Path(this.libDir).makeRelative();
                    }
                    if (this.libDir.length() <= 0 || libDirPath == null || libDirPath.equals((Object)reference.getRuntimePath().makeRelative()) || !this.hasConflictingProjectInMetaInf(reference)) continue;
                    DependencyConflictResolveDialog dlg = new DependencyConflictResolveDialog(this.getShell(), 2);
                    if (dlg.open() == 1) {
                        return Status.CANCEL_STATUS;
                    }
                    this.resolveConflicts = true;
                    continue;
                }
                if (this.libDir.length() <= 0 || !this.hasConflictingProjectInMetaInf(projectToAdd = AddProjectToEARDropAssistant.getProject(sourceObject))) continue;
                DependencyConflictResolveDialog dlg = new DependencyConflictResolveDialog(this.getShell(), 2);
                if (dlg.open() == 1) {
                    return Status.CANCEL_STATUS;
                }
                this.resolveConflicts = true;
            }
            Job addProjectToEarJob = new Job(this.getJobTitle(this.earComponent)){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = null;
                    ArrayList<IVirtualComponent> componentsToAdd = new ArrayList<IVirtualComponent>();
                    ArrayList<IVirtualComponent> componentsToRemove = new ArrayList<IVirtualComponent>();
                    for (Object sourceObject : selection) {
                        if (sourceObject instanceof JarPackageFragmentRoot) {
                            JarPackageFragmentRoot jarPackageFragment = (JarPackageFragmentRoot)sourceObject;
                            String type = "lib/";
                            IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)AddProjectToEARDropAssistant.this.earComponent.getProject(), (String)(String.valueOf(type) + jarPackageFragment.getPath().toString()));
                            componentsToAdd.add(archive);
                            continue;
                        }
                        if (sourceObject instanceof IVirtualReference) {
                            IVirtualReference reference = (IVirtualReference)sourceObject;
                            if (AddProjectToEARDropAssistant.this.resolveConflicts && !(status = AddProjectToEARDropAssistant.this.resolveConflicts(reference.getReferencedComponent())).isOK()) {
                                return status;
                            }
                            IVirtualComponent archive = reference.getReferencedComponent();
                            componentsToRemove.add(archive);
                            status = AddProjectToEARDropAssistant.this.removeComponentsFromEar(componentsToRemove, reference.getRuntimePath().toString());
                            if (!status.isOK()) {
                                return status;
                            }
                            componentsToAdd.add(archive);
                            continue;
                        }
                        IProject projectToAdd = AddProjectToEARDropAssistant.getProject(sourceObject);
                        if (AddProjectToEARDropAssistant.this.resolveConflicts && !(status = AddProjectToEARDropAssistant.this.resolveConflicts(ComponentCore.createComponent((IProject)projectToAdd))).isOK()) {
                            return status;
                        }
                        componentsToAdd.add(ComponentCore.createComponent((IProject)projectToAdd));
                    }
                    if (!componentsToAdd.isEmpty() && !(status = AddProjectToEARDropAssistant.this.addComponentsToEar(componentsToAdd, AddProjectToEARDropAssistant.this.libDir)).isOK()) {
                        return status;
                    }
                    return status;
                }
            };
            service.showInDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), addProjectToEarJob);
            addProjectToEarJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            addProjectToEarJob.schedule();
        }
        return Status.OK_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        ISelection selection;
        this.libDir = "";
        if ((LocalSelectionTransfer.getTransfer().isSupportedType(transferType) || PluginTransfer.getInstance().isSupportedType(transferType)) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.earProject = AddProjectToEARDropAssistant.getProject(target);
            if (this.earProject == null) {
                return Status.CANCEL_STATUS;
            }
            this.earComponent = ComponentCore.createComponent((IProject)this.earProject);
            int earVersion = this.getEarVersion(this.earProject);
            if (target instanceof BundledNode && ((BundledNode)target).getBundledLibsDirectoryNode() == null) {
                this.libDir = EarUtilities.getEARLibDir((IVirtualComponent)this.earComponent);
            }
            IStatus status = null;
            for (Object next : structuredSelection) {
                int n;
                IVirtualReference[] iVirtualReferenceArray;
                IVirtualComponent referencedComponent;
                if (IVirtualReference.class.isInstance(next) && (referencedComponent = ((IVirtualReference)next).getReferencedComponent()).isBinary() && this.isPhysicallyAdded(referencedComponent)) {
                    return Status.CANCEL_STATUS;
                }
                if (next instanceof IVirtualReference) {
                    return Status.OK_STATUS;
                }
                if (next instanceof JarPackageFragmentRoot) {
                    JarPackageFragmentRoot jar = (JarPackageFragmentRoot)next;
                    iVirtualReferenceArray = this.earComponent.getReferences();
                    n = iVirtualReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVirtualReference reference = iVirtualReferenceArray[n2];
                        if (reference.getArchiveName().equals(jar.getElementName())) {
                            return Status.CANCEL_STATUS;
                        }
                        ++n2;
                    }
                    return Status.OK_STATUS;
                }
                IProject projectToAdd = AddProjectToEARDropAssistant.getProject(next);
                this.hasConflictingProjectInMetaInf(ComponentCore.createComponent((IProject)projectToAdd));
                try {
                    iVirtualReferenceArray = this.earProject.getReferencedProjects();
                    n = iVirtualReferenceArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IVirtualReference referencedProject = iVirtualReferenceArray[n3];
                        if (referencedProject == projectToAdd) {
                            return Status.CANCEL_STATUS;
                        }
                        ++n3;
                    }
                }
                catch (CoreException e) {
                    String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                    status = J2EENavigatorPlugin.createErrorStatus((int)0, (String)msg, (Throwable)e);
                }
                status = this.validateProjectMayBeAdded(this.earProject, projectToAdd, earVersion);
                if (!status.isOK()) continue;
                return status;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private boolean isPhysicallyAdded(IVirtualComponent component) {
        IFile f = (IFile)component.getAdapter(IFile.class);
        return f != null;
    }

    private IStatus validateProjectMayBeAdded(IProject earProject, IProject projectToAdd, int earVersion) {
        if (earProject == null || projectToAdd == null || earVersion < 0) {
            return J2EENavigatorPlugin.createErrorStatus((int)0, (String)Messages.AddProjectToEARDropAssistant_Could_not_add_module_to_Enterprise_, null);
        }
        if (!earProject.isAccessible()) {
            return J2EENavigatorPlugin.createErrorStatus((int)0, (String)NLS.bind((String)Messages.AddProjectToEARDropAssistant_The_project_0_cannot_be_accesse_, (Object)earProject.getName()), null);
        }
        if (!projectToAdd.isAccessible()) {
            return J2EENavigatorPlugin.createErrorStatus((int)0, (String)Messages.AddProjectToEARDropAssistant_The_dragged_project_cannot_be_added_, null);
        }
        IStatus isValid = this.validateProjectToAdd(projectToAdd, earVersion);
        if (!isValid.isOK()) {
            return isValid;
        }
        return Status.OK_STATUS;
    }

    protected final int getEarVersion(IProject earProject) {
        int earVersion = -1;
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)earProject);
            if (facetedProject != null) {
                double double1 = Double.parseDouble(facetedProject.getProjectFacetVersion(EARFacetUtils.EAR_FACET).getVersionString());
                earVersion = (int)(double1 * 10.0);
            } else {
                JEEUIPlugin.logError("Could not acquire model elements for project \"" + earProject.getName() + "\".", null);
            }
        }
        catch (CoreException e1) {
            String msg = e1.getMessage() != null ? e1.getMessage() : e1.toString();
            JEEUIPlugin.logError(msg, (Exception)((Object)e1));
        }
        return earVersion;
    }

    protected final boolean hasEarFacet(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e1) {
            String msg = e1.getMessage() != null ? e1.getMessage() : e1.toString();
            JEEUIPlugin.logError(msg, (Exception)((Object)e1));
        }
        return facetedProject != null && facetedProject.hasProjectFacet(EARFacetUtils.EAR_FACET);
    }

    protected final String calculateValidProjectName(String originalName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String validName = originalName;
        int count = 1;
        while (root.getProject(validName).exists()) {
            validName = String.valueOf(originalName) + count++;
        }
        return validName;
    }

    protected String getJobTitle(IVirtualComponent earComponent) {
        return NLS.bind((String)Messages.AddModuleToEarDropAssistant_Adding_module_to_ea_, (Object)earComponent.getName());
    }

    protected IStatus validateProjectToAdd(IProject projectToAdd, int earVersion) {
        try {
            int version;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)projectToAdd);
            if (facetedProject == null) {
                facetedProject = ProjectFacetsManager.create((IProject)projectToAdd, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                IProjectFacetVersion javafacetversion = ProjectFacetsManager.getProjectFacet((String)"jst.java").getDefaultVersion();
                facetedProject.installProjectFacet(javafacetversion, null, null);
                IProjectFacetVersion utilityfacetversion = ProjectFacetsManager.getProjectFacet((String)"jst.utility").getDefaultVersion();
                facetedProject.installProjectFacet(utilityfacetversion, null, null);
            }
            if (facetedProject.hasProjectFacet(EARFacetUtils.EAR_FACET)) {
                return Status.CANCEL_STATUS;
            }
            String verStr = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)projectToAdd);
            if (verStr != null && (version = JavaEEProjectUtilities.isApplicationClientProject((IProject)projectToAdd) ? J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID((String)verStr) : (JavaEEProjectUtilities.isEJBProject((IProject)projectToAdd) ? J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)verStr) : (JavaEEProjectUtilities.isDynamicWebProject((IProject)projectToAdd) ? J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)verStr) : (JavaEEProjectUtilities.isJCAProject((IProject)projectToAdd) ? J2EEVersionUtil.convertConnectorVersionStringToJ2EEVersionID((String)verStr) : J2EEVersionUtil.convertVersionStringToInt((String)verStr))))) > earVersion) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (CoreException e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            return J2EENavigatorPlugin.createErrorStatus((int)0, (String)msg, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected static IProject getProject(Object element) {
        if (element == null) {
            return null;
        }
        IProject project = null;
        project = element instanceof IAdaptable ? (IProject)((IAdaptable)element).getAdapter(IPROJECT_CLASS) : (IProject)Platform.getAdapterManager().getAdapter(element, IPROJECT_CLASS);
        if (element instanceof AbstractEarNode) {
            project = ((AbstractEarNode)element).getEarProject();
        }
        if (element instanceof GroupEARProvider) {
            project = ((GroupEARProvider)element).getProject();
        }
        if (element instanceof IVirtualReference) {
            project = ((IVirtualReference)element).getReferencedComponent().getProject();
        }
        if (project == null) {
            IFile associatedFile;
            if (element instanceof EObject) {
                project = ProjectUtilities.getProject((EObject)((EObject)element));
            } else if (element instanceof J2EEItemProvider && (associatedFile = ((J2EEItemProvider)element).getAssociatedFile()) != null) {
                project = associatedFile.getProject();
            }
        }
        return project;
    }

    protected static String getDefaultURI(IVirtualComponent component) {
        IProject project = component.getProject();
        String name = component.getName();
        name = JavaEEProjectUtilities.isDynamicWebProject((IProject)project) ? String.valueOf(name) + ".war" : (JavaEEProjectUtilities.isEARProject((IProject)project) ? String.valueOf(name) + ".ear" : (JavaEEProjectUtilities.isJCAProject((IProject)project) ? String.valueOf(name) + ".rar" : String.valueOf(name) + ".jar"));
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasConflictingProjectInMetaInf(Object lib) {
        IProject libProj = null;
        if (lib instanceof IProject) {
            libProj = (IProject)lib;
        } else if (lib instanceof IVirtualComponent) {
            libProj = ((IVirtualComponent)lib).getProject();
        } else if (lib instanceof IVirtualReference) {
            libProj = ((IVirtualReference)lib).getReferencedComponent().getProject();
        }
        if (libProj == null) {
            return false;
        }
        IProject earProject = this.earComponent.getProject();
        try {
            IProject[] earRefProjects = earProject.getReferencedProjects();
            int i = 0;
            while (true) {
                IVirtualComponent cmp1;
                if (i >= earRefProjects.length) {
                    return false;
                }
                if (!JavaEEProjectUtilities.isEARProject((IProject)earRefProjects[i]) && !earRefProjects[i].equals((Object)libProj) && (cmp1 = ComponentCore.createComponent((IProject)earRefProjects[i])) != null) {
                    IVirtualReference[] refs = cmp1.getReferences();
                    int j = 0;
                    while (j < refs.length) {
                        if (refs[j].getReferencedComponent().getProject().equals((Object)libProj)) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected IStatus addComponentsToEar(List<IVirtualComponent> components, String libDir) {
        IStatus status = null;
        IDataModel datamodel = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        HashMap<IVirtualComponent, String> componentToURIMap = new HashMap<IVirtualComponent, String>();
        IVirtualComponent moduleComponent2 = null;
        for (IVirtualComponent moduleComponent2 : components) {
            componentToURIMap.put(moduleComponent2, AddProjectToEARDropAssistant.getDefaultURI(moduleComponent2));
        }
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.earComponent);
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", components);
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", componentToURIMap);
        String libDirPath = libDir;
        if (libDir != null && libDir.length() > 0) {
            libDirPath = new Path(libDir).makeAbsolute().toString();
        }
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)libDirPath);
        try {
            return datamodel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            JEEUIPlugin.logError(msg, (Exception)((Object)e));
            return status;
        }
    }

    protected IStatus removeComponentsFromEar(List<IVirtualComponent> components, String libDir) {
        IStatus status = null;
        IDataModel datamodel = DataModelFactory.createDataModel((IDataModelProvider)new RemoveComponentFromEnterpriseApplicationDataModelProvider());
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.earComponent);
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", components);
        try {
            status = datamodel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (!status.isOK()) {
                return status;
            }
        }
        catch (ExecutionException e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            JEEUIPlugin.logError(msg, (Exception)((Object)e));
        }
        return this.removeReferences(components, libDir, this.earComponent);
    }

    protected IStatus removeReferences(List<IVirtualComponent> components, String libDir, IVirtualComponent sourceComponent) {
        IVirtualReference[] refs;
        IVirtualReference[] iVirtualReferenceArray = refs = sourceComponent.getReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            ref.getRuntimePath();
            ++n2;
        }
        HashMap<IVirtualComponent, String> componentToURIMap = new HashMap<IVirtualComponent, String>();
        for (IVirtualComponent moduleComponent : components) {
            componentToURIMap.put(moduleComponent, AddProjectToEARDropAssistant.getDefaultURI(moduleComponent));
        }
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", componentToURIMap);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", components);
        if (libDir.length() > 0) {
            model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)new Path(libDir).makeAbsolute().toString());
        }
        try {
            return model.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            JEEUIPlugin.logError(msg, (Exception)((Object)e));
            return Status.CANCEL_STATUS;
        }
    }

    protected IStatus resolveConflicts(IVirtualComponent component) {
        IProject earProject = this.earComponent.getProject();
        try {
            IProject[] earRefProjects = earProject.getReferencedProjects();
            int i = 0;
            while (i < earRefProjects.length) {
                IVirtualComponent cmp1;
                if (!JavaEEProjectUtilities.isEARProject((IProject)earRefProjects[i]) && (cmp1 = ComponentCore.createComponent((IProject)earRefProjects[i])) != null) {
                    IVirtualReference[] refs = cmp1.getReferences();
                    int j = 0;
                    while (j < refs.length) {
                        if (refs[j].getReferencedComponent().equals(component)) {
                            ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
                            components.add(refs[j].getReferencedComponent());
                            IStatus status = this.removeReferences(components, refs[j].getRuntimePath().toString(), refs[j].getEnclosingComponent());
                            if (!status.isOK()) {
                                return status;
                            }
                            try {
                                this.removeManifestDependency(refs[j].getEnclosingComponent(), refs[j].getReferencedComponent());
                            }
                            catch (ExecutionException e) {
                                String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                                JEEUIPlugin.logError(msg, (Exception)((Object)e));
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return Status.OK_STATUS;
    }

    private void removeManifestDependency(IVirtualComponent source, IVirtualComponent target) throws ExecutionException {
        String targetProjName;
        String sourceProjName = source.getProject().getName();
        if (target instanceof J2EEModuleVirtualArchiveComponent) {
            targetProjName = ((J2EEModuleVirtualArchiveComponent)target).getName();
            String[] pathSegments = targetProjName.split("/");
            targetProjName = pathSegments[pathSegments.length - 1];
        } else {
            targetProjName = target.getProject().getName();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFile manifestmf = J2EEProjectUtilities.getManifestFile((IProject)source.getProject());
        ArchiveManifest mf = J2EEProjectUtilities.readManifest((IProject)source.getProject());
        if (mf == null) {
            return;
        }
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)sourceProjName);
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        String[] cp = mf.getClassPathTokenized();
        ArrayList<String> cpList = new ArrayList<String>();
        String cpToRemove = targetProjName.endsWith(".jar") ? targetProjName : String.valueOf(targetProjName) + ".jar";
        int i = 0;
        while (i < cp.length) {
            if (!cp[i].equals(cpToRemove)) {
                cpList.add(cp[i]);
            }
            ++i;
        }
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
        updateManifestDataModel.getDefaultOperation().execute((IProgressMonitor)monitor, null);
    }
}

