/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.ddlgen.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOutputMode;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class EclipseLinkGenerationOutputModeWizardPage
extends WizardPage {
    GenerationOutputModeGroup outputModeGroup;

    public EclipseLinkGenerationOutputModeWizardPage() {
        super("Database Schema");
        this.setTitle(JptJpaEclipseLinkUiMessages.GENERATION_OUTPUT_MODE_WIZARD_PAGE_TITLE);
        this.setMessage(JptJpaEclipseLinkUiMessages.GENERATION_OUTPUT_MODE_WIZARD_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.outputModeGroup = new GenerationOutputModeGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    public EclipseLinkOutputMode getOutputMode() {
        return this.outputModeGroup.getOutputMode();
    }

    class GenerationOutputModeGroup {
        private EclipseLinkOutputMode outputMode;
        private final Button databaseButton;
        private final Button sqlScriptButton;
        private final Button bothButton;

        private GenerationOutputModeGroup(Composite parent) {
            Group outputModeGroup = new Group(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            outputModeGroup.setLayout((Layout)layout);
            outputModeGroup.setLayoutData((Object)new GridData(768));
            outputModeGroup.setText(JptJpaEclipseLinkUiMessages.GENERATION_OUTPUT_MODE_WIZARD_PAGE_GENERATION_OUTPUT_MODE);
            SelectionListener outputModeButtonListener = this.buildOutputModeRadioButtonListener();
            this.databaseButton = this.buildRadioButton((Composite)outputModeGroup, JptJpaEclipseLinkUiMessages.OUTPUT_MODE_COMPOSITE_DATABASE, outputModeButtonListener, 3);
            this.sqlScriptButton = this.buildRadioButton((Composite)outputModeGroup, JptJpaEclipseLinkUiMessages.OUTPUT_MODE_COMPOSITE_SQL_SCRIPT, outputModeButtonListener, 3);
            this.bothButton = this.buildRadioButton((Composite)outputModeGroup, JptJpaEclipseLinkUiMessages.OUTPUT_MODE_COMPOSITE_BOTH, outputModeButtonListener, 3);
            this.databaseButton.setSelection(true);
            this.outputModeButtonChanged();
        }

        private SelectionListener buildOutputModeRadioButtonListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    GenerationOutputModeGroup.this.outputModeButtonChanged();
                }
            };
        }

        private void outputModeButtonChanged() {
            if (this.databaseButton.getSelection()) {
                this.outputMode = EclipseLinkOutputMode.database;
            } else if (this.sqlScriptButton.getSelection()) {
                this.outputMode = EclipseLinkOutputMode.sql_script;
            } else if (this.bothButton.getSelection()) {
                this.outputMode = EclipseLinkOutputMode.both;
            }
        }

        private Button buildRadioButton(Composite parent, String text, SelectionListener listener, int horizontalSpan) {
            Button radioButton = new Button(parent, 16);
            GridData gridData = new GridData();
            gridData.horizontalSpan = horizontalSpan;
            radioButton.setLayoutData((Object)gridData);
            radioButton.setText(text);
            radioButton.addSelectionListener(listener);
            return radioButton;
        }

        private EclipseLinkOutputMode getOutputMode() {
            return this.outputMode;
        }
    }
}

