/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.predicate.CompoundPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public abstract class AbstractCompoundPredicate<V>
implements CompoundPredicate<V> {
    protected final Predicate<? super V>[] predicates;

    @SafeVarargs
    protected AbstractCompoundPredicate(Predicate<? super V> ... predicates) {
        if (ArrayTools.isOrContainsNull(predicates)) {
            throw new NullPointerException();
        }
        this.predicates = predicates;
    }

    @Override
    public Predicate<? super V>[] getPredicates() {
        return this.predicates;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractCompoundPredicate other = (AbstractCompoundPredicate)o;
        return Arrays.equals(this.predicates, other.predicates);
    }

    public int hashCode() {
        return Arrays.hashCode(this.predicates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, this);
        sb.append('(');
        if (this.predicates.length > 0) {
            String operatorString = this.operatorString();
            Predicate<? super V>[] predicateArray = this.predicates;
            int n = this.predicates.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate<? super V> predicate = predicateArray[n2];
                sb.append(predicate);
                sb.append(' ');
                sb.append(operatorString);
                sb.append(' ');
                ++n2;
            }
            sb.setLength(sb.length() - operatorString.length() - 2);
        }
        sb.append(')');
        return sb.toString();
    }

    protected abstract String operatorString();
}

