/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.security;

import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.internal.security.RealmOperationAuthorizer;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.AnnotationHandler;
import org.eclipse.emf.cdo.server.spi.security.HomeFolderHandler;
import org.eclipse.emf.cdo.server.spi.security.SecurityManagerFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.IFactory;

public final class SecurityManagerUtil {
    private SecurityManagerUtil() {
    }

    public static ISecurityManager getSecurityManager(IRepository repository) {
        return SecurityManager.get(repository);
    }

    public static ISecurityManager createSecurityManager(String realmPath) {
        return SecurityManagerUtil.createSecurityManager(realmPath, (IManagedContainer)IPluginContainer.INSTANCE);
    }

    public static ISecurityManager createSecurityManager(String realmPath, IManagedContainer container) {
        return new SecurityManager(realmPath, container);
    }

    public static Role addResourceRole(Realm realm, String roleName, String resourcePath, boolean writable) {
        Role role = realm.addRole(roleName);
        SecurityManagerUtil.addResourcePermissions(role, resourcePath, writable);
        return role;
    }

    public static void addResourcePermissions(Role role, String resourcePath, boolean writable) {
        role.getPermissions().add((Object)SecurityFactory.eINSTANCE.createFilterPermission(Access.READ, new PermissionFilter[]{SecurityFactory.eINSTANCE.createResourceFilter(resourcePath, PatternStyle.EXACT, true)}));
        if (writable) {
            role.getPermissions().add((Object)SecurityFactory.eINSTANCE.createFilterPermission(Access.WRITE, new PermissionFilter[]{SecurityFactory.eINSTANCE.createResourceFilter(resourcePath, PatternStyle.EXACT, false)}));
        }
    }

    public static void prepareContainer(IManagedContainer container) {
        container.registerFactory((IFactory)new SecurityManagerFactory.Default());
        container.registerFactory((IFactory)new SecurityManagerFactory.Annotation());
        container.registerFactory((IFactory)new AnnotationHandler.Factory());
        container.registerFactory((IFactory)new HomeFolderHandler.Factory());
        container.registerFactory((IFactory)new RealmOperationAuthorizer.RequireUser.Factory());
        container.registerFactory((IFactory)new RealmOperationAuthorizer.RequireGroup.Factory());
        container.registerFactory((IFactory)new RealmOperationAuthorizer.RequireRole.Factory());
    }
}

