/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser;

import org.eclipse.dltk.compiler.problem.ProblemSeverity;

public class TclError {
    private int code;
    private String message;
    private int start;
    private int end;
    private ProblemSeverity errorKind;
    private String[] extraArguments;

    public TclError(int code, String message, String[] extraArguments, int start, int end, ProblemSeverity kind) {
        this.code = code;
        this.message = message;
        this.extraArguments = extraArguments;
        this.start = start;
        this.end = end;
        this.errorKind = kind;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + this.end;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TclError other = (TclError)obj;
        if (this.code != other.code) {
            return false;
        }
        if (this.end != other.end) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.start == other.start;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public ProblemSeverity getErrorKind() {
        return this.errorKind;
    }

    public void setErrorKind(ProblemSeverity errorKind) {
        this.errorKind = errorKind;
    }

    public String[] getExtraArguments() {
        return this.extraArguments;
    }

    public void setExtraArguments(String[] extraArguments) {
        this.extraArguments = extraArguments;
    }

    public String toString() {
        return "[" + this.start + ".." + this.end + "]" + this.code + ":" + this.message;
    }
}

