/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ddl;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlBuilder;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlConstants;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlUtils;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public abstract class SybaseDdlBuilder
extends GenericDdlBuilder
implements ISybaseDdlConstants {
    public String[] createTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (table instanceof TemporaryTable) {
            return this.createTempoeryTable((TemporaryTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        if (table instanceof PersistentTable) {
            return this.createPersistentTable((PersistentTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        throw new UnsupportedOperationException();
    }

    protected abstract String[] createTempoeryTable(TemporaryTable var1, boolean var2, boolean var3, boolean var4);

    protected abstract String[] createPersistentTable(PersistentTable var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createView(ViewTable var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createEvent(Event var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createProcedure(Procedure var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createUserDefinedFunction(UserDefinedFunction var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createTrigger(Trigger var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createDatabase(Database var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createCatalogs(Catalog var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createUserDefinedType(UserDefinedType var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createAuthorizationId(AuthorizationIdentifier var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] createColumn(Column var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] addUniqueConstraint(UniqueConstraint var1, boolean var2, boolean var3, boolean var4);

    public abstract String[] addForeignKey(ForeignKey var1, boolean var2, boolean var3, boolean var4);

    public abstract String dropForeignKey(ForeignKey var1, boolean var2, boolean var3);

    public abstract String dropCheckConstraint(CheckConstraint var1, boolean var2, boolean var3);

    public abstract String dropUniqueConstraint(UniqueConstraint var1, boolean var2, boolean var3);

    public abstract String dropUserDefinedType(UserDefinedType var1, boolean var2, boolean var3);

    public abstract String dropAuthorizationId(AuthorizationIdentifier var1, boolean var2, boolean var3);

    public String dropView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer dropView = new StringBuffer("");
        dropView.append("DROP").append(" ").append("VIEW").append(" ").append(this.getName((Table)view, quoteIdentifiers, qualifyNames));
        return dropView.toString();
    }

    public String dropEvent(Event event, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("EVENT").append(" ").append(this.getName(event, quoteIdentifiers, qualifyNames));
        return sb.toString();
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("PROCEDURE").append(" ").append(this.getName(procedure, quoteIdentifiers, qualifyNames));
        return sb.toString();
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("FUNCTION").append(" ").append(this.getName(function, quoteIdentifiers, qualifyNames));
        return sb.toString();
    }

    public String dropColumn(Column col, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName(col.getTable(), quoteIdentifiers, qualifyNames)).append(" ").append("DROP").append(" ").append(this.getName(col, quoteIdentifiers, false));
        return sb.toString();
    }

    public String dropCatalog(Catalog db, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("DATABASE").append(" ").append(this.getName((ENamedElement)db, quoteIdentifiers, qualifyNames));
        return sb.toString();
    }

    public String dropDatabase(Database db, boolean quoteIdentifiers, boolean qualifyNames) {
        return "";
    }

    public String getName(ENamedElement element, boolean quoteIdentifiers, boolean qualifyNames) {
        if (element instanceof Event) {
            return this.getName((Event)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof Index) {
            return this.getName((Index)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof Procedure) {
            return this.getName((Procedure)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof UserDefinedFunction) {
            return this.getName((UserDefinedFunction)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof Column) {
            return this.getName((Column)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof Table) {
            return this.getName((Table)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof TableConstraint) {
            return this.getName((TableConstraint)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof Trigger) {
            return this.getName((Trigger)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof UserDefinedType) {
            return this.getName((UserDefinedType)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof Catalog) {
            return SQLDevToolsUtil.quoteWhenNecessary((String)element.getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)element));
        }
        if (quoteIdentifiers) {
            return this.getDoubleQuotedString(element.getName());
        }
        return element.getName();
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = constraint.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers) {
        String name = constraint.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(Event event, boolean quoteIdentifiers, boolean qualifyNames) {
        String typeName = event.getName();
        if (quoteIdentifiers) {
            typeName = this.getDoubleQuotedString(typeName);
        }
        return typeName;
    }

    protected String getName(Procedure proc, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = proc.getName();
        String schemaName = proc.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    protected String getName(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        String schemaName = trigger.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    protected String getName(UserDefinedFunction proc, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = proc.getName();
        String schemaName = proc.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    protected String getName(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = index.getName();
        name = SQLDevToolsUtil.quoteWhenNecessary((String)index.getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)index));
        return name;
    }

    protected String getName(Column col, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = col.getName();
        String tableName = col.getTable().getName();
        String schemaName = col.getTable().getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + tableName + "." + name;
        }
        return name;
    }

    protected String getAddCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer(128);
        String name = constraint.getName();
        if (name != null && name.trim().length() != 0) {
            if (quoteIdentifiers) {
                name = super.getDoubleQuotedString(name);
            }
            statement.append("CONSTRAINT").append(" ").append(name).append(" ");
        }
        SearchCondition condition = constraint.getSearchCondition();
        String conditionSql = "";
        if (condition != null) {
            conditionSql = condition.getSQL();
        }
        statement.append("CHECK").append(" ").append("(").append(conditionSql).append(")");
        return statement.toString();
    }

    public String[] addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        statement.append(NEWLINE).append("\t").append("ADD").append(" ");
        statement.append(this.getAddCheckConstraintClause(constraint, quoteIdentifiers));
        return new String[]{statement.toString()};
    }

    public String[] grantPrivilege(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(privilege instanceof SybasePrivilege)) {
            throw new IllegalArgumentException("Only SybasePrivilege supported");
        }
        SybasePrivilege sybPrivilege = (SybasePrivilege)privilege;
        if (sybPrivilege.getGrantee() == null) {
            throw new IllegalArgumentException("Privilege without grantee!");
        }
        StringBuffer sb = new StringBuffer("");
        String permissionString = this.assemblePermissionList((Privilege)sybPrivilege, quoteIdentifiers, qualifyNames);
        StringBuffer objectName = new StringBuffer("");
        if (sybPrivilege.getObject() == null) {
            objectName.append("");
        } else if (sybPrivilege.getObject() instanceof Column) {
            Column col = (Column)sybPrivilege.getObject();
            objectName.append(this.getName((ENamedElement)col.getTable(), quoteIdentifiers, qualifyNames));
        } else {
            objectName.append(this.getName((ENamedElement)sybPrivilege.getObject(), quoteIdentifiers, qualifyNames));
        }
        AuthorizationIdentifier grantee = this.getAuthorizationIdentifier((Privilege)sybPrivilege);
        sb.append("GRANT").append(" ").append(permissionString).append(" ").append("ON").append(" ").append(objectName).append(" ").append("TO").append(" ").append(grantee.getName());
        return new String[]{sb.toString()};
    }

    public String revokePrivilege(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        Column col;
        if (!(privilege instanceof SybasePrivilege)) {
            throw new IllegalArgumentException("Only SybasePrivilege supported");
        }
        SybasePrivilege sybPrivilege = (SybasePrivilege)privilege;
        if (sybPrivilege.getGrantee() == null) {
            throw new IllegalArgumentException("Privilege without grantee!");
        }
        if (privilege.getObject() instanceof Column && (col = (Column)privilege.getObject()).getTable() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        String permissionString = this.assemblePermissionList(privilege, quoteIdentifiers, qualifyNames);
        StringBuffer objectName = new StringBuffer("");
        if (privilege.getObject() == null) {
            objectName.append("");
        } else if (privilege.getObject() instanceof Column) {
            Column col2 = (Column)privilege.getObject();
            objectName.append(this.getName((ENamedElement)col2.getTable(), quoteIdentifiers, qualifyNames));
        } else {
            objectName.append(this.getName((ENamedElement)privilege.getObject(), quoteIdentifiers, qualifyNames));
        }
        AuthorizationIdentifier grantee = this.getAuthorizationIdentifier(privilege);
        sb.append("REVOKE").append(" ").append(permissionString).append(" ").append("ON").append(" ").append(objectName).append(" ").append("FROM").append(" ").append(this.getName((ENamedElement)grantee, false, qualifyNames));
        return sb.toString();
    }

    private AuthorizationIdentifier getAuthorizationIdentifier(Privilege privilege) {
        if (privilege instanceof SybasePrivilege) {
            return ((SybasePrivilege)privilege).getGrantee();
        }
        return (AuthorizationIdentifier)privilege.eContainer();
    }

    private String assemblePermissionList(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer permissionList = new StringBuffer("");
        if (privilege.getObject() == null) {
            return "";
        }
        if (privilege.getObject() instanceof Column) {
            Column col = (Column)privilege.getObject();
            permissionList.append(privilege.getAction() == null ? "" : privilege.getAction()).append("(").append(this.getName(col, quoteIdentifiers, false)).append(")");
        } else {
            permissionList.append(privilege.getAction() == null ? "" : privilege.getAction());
        }
        return permissionList.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String getViewColumnList(ViewTable view, boolean quoteIdentifiers) {
        columnsStr = new StringBuffer("");
        it = view.getColumns().iterator();
        if (view.getColumns().size() != 0) ** GOTO lbl15
        return null;
lbl-1000:
        // 1 sources

        {
            if (columnsStr.length() != 0) {
                columnsStr.append(",").append(" ");
            }
            c = (Column)it.next();
            if (quoteIdentifiers) {
                columnsStr.append(this.getDoubleQuotedString(c.getName()));
                continue;
            }
            columnsStr.append(c.getName());
lbl15:
            // 3 sources

            ** while (it.hasNext())
        }
lbl16:
        // 1 sources

        return columnsStr.toString();
    }

    protected String getTSQLParameters(Routine routine) {
        StringBuffer sb = new StringBuffer();
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            sb.append(this.getTSQLParameter(routine, p));
            if (!it.hasNext()) continue;
            sb.append(",").append(" ");
        }
        return sb.toString();
    }

    public String getTSQLParameter(Routine routine, Parameter p) {
        String name = p.getName();
        String type = this.getDataTypeString((TypedElement)p, routine.getSchema());
        String dft = null;
        if (p instanceof SybaseParameter) {
            dft = ((SybaseParameter)p).getDefaultValue();
        }
        ParameterMode mode = p.getMode();
        String modeLiteral = mode.getLiteral();
        return this.getTSQLParameter(name, type, dft, modeLiteral);
    }

    public String getTSQLParameter(String name, String type, String defValue, String mode) {
        StringBuffer sb = new StringBuffer();
        sb.append(name).append(" ");
        sb.append(type);
        if (defValue != null) {
            sb.append("=").append(defValue);
        }
        if (mode != null && (mode.equalsIgnoreCase(ParameterMode.INOUT_LITERAL.getLiteral()) || mode.equalsIgnoreCase(ParameterMode.OUT_LITERAL.getLiteral()))) {
            sb.append(" ").append("OUTPUT");
        }
        return sb.toString();
    }

    protected String getDeterministic(Routine routine) {
        StringBuffer sb = new StringBuffer();
        if (routine.isDeterministic()) {
            sb.append("DETERMINISTIC").append(NEWLINE);
        } else {
            sb.append("NOT").append(" ").append("DETERMINISTIC").append(NEWLINE);
        }
        return sb.toString();
    }

    public String[] createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return new String[]{this.createIndex(index, quoteIdentifiers, qualifyNames)};
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getKeyColumns(ReferenceConstraint constraint, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer(128);
        Iterator it = constraint.getMembers().iterator();
        if (!it.hasNext()) {
            return " ";
        }
        Column c = (Column)it.next();
        if (quoteIdentifiers) {
            statement.append(this.getDoubleQuotedString(c.getName()));
        } else {
            statement.append(c.getName());
        }
        while (it.hasNext()) {
            c = (Column)it.next();
            if (quoteIdentifiers) {
                statement.append(",").append(" ").append(this.getDoubleQuotedString(c.getName()));
                continue;
            }
            statement.append(",").append(" ").append(c.getName());
        }
        return statement.toString();
    }

    public String getTriggerEvents(Trigger trigger) {
        StringBuffer sb = new StringBuffer();
        if (trigger.isUpdateType()) {
            sb.append("UPDATE");
            if (trigger.isInsertType() || trigger.isDeleteType()) {
                sb.append(",");
            }
            sb.append(" ");
        }
        if (trigger.isInsertType()) {
            sb.append("INSERT");
            if (trigger.isDeleteType()) {
                sb.append(",");
            }
            sb.append(" ");
        }
        if (trigger.isDeleteType()) {
            sb.append("DELETE").append(" ");
        }
        return sb.toString();
    }

    public String getTriggerBody(Trigger trigger) {
        EList actions = trigger.getActionStatement();
        StringBuffer body = new StringBuffer();
        if (actions != null && actions.size() > 0) {
            for (SQLStatement stmt : actions) {
                body.append(stmt.getSQL()).append(NEWLINE);
            }
        }
        String bodyString = body.toString();
        return bodyString;
    }

    public String createTSQLTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String bodyString = this.getTriggerBody(trigger);
        if (QuickSQLParser.getInstance().match(bodyString, 3)) {
            return bodyString;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("TRIGGER").append(" ").append(this.getName(trigger, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        Table subjectTable = trigger.getSubjectTable();
        if (subjectTable != null) {
            sb.append("ON").append(" ");
            Schema triggerOwner = trigger.getSchema();
            Schema tableOwner = subjectTable.getSchema();
            if (tableOwner != null && (qualifyNames || tableOwner.equals(triggerOwner))) {
                sb.append(tableOwner.getName()).append(".");
            }
            sb.append(trigger.getName()).append(NEWLINE);
            sb.append("FOR").append(" ");
            sb.append(this.getTriggerEvents(trigger));
            sb.append(NEWLINE);
        }
        sb.append("AS").append(NEWLINE);
        sb.append(bodyString);
        return sb.toString();
    }

    public String getIndexKeyColumns(Index index, boolean quoteIdentifiers) {
        return SybaseDdlUtils.getIndexMemberKeys(index.getMembers(), quoteIdentifiers);
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema) {
        boolean needQuote = false;
        if (typedElement.getDataType().getName().indexOf("\"") >= 0 || typedElement.getDataType().getName().indexOf(" ") >= 0) {
            needQuote = true;
        }
        return this.getDataTypeString(typedElement, schema, needQuote);
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema, boolean quotedIdentifier) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                if (referencedType.getSchema() != schema) {
                    return this.getName(referencedType, quotedIdentifier, false);
                }
                if (quotedIdentifier) {
                    return this.getDoubleQuotedString(referencedType.getName());
                }
                return referencedType.getName();
            }
        }
        return null;
    }

    protected String getDoubleQuotedString(String original) {
        return SQLUtil.quote(original, "\"");
    }

    protected String getSingleQuotedString(String original) {
        return SQLUtil.quote(original, "'");
    }

    protected String getDropPreconditionPattern() {
        StringBuffer sb = new StringBuffer();
        sb.append("IF").append(" ").append("EXISTS").append(" ").append("(").append(NEWLINE);
        sb.append("\t").append("{0}").append(")").append(NEWLINE).append("THEN").append(NEWLINE).append("BEGIN").append(NEWLINE);
        sb.append("\t").append("{1}").append(NEWLINE).append("END").append(NEWLINE).append("END IF");
        return sb.toString();
    }

    public DatabaseIdentifier getDatabaseIdentifier(EObject ojb) {
        DatabaseDefinition def;
        DDLGenerator ddlgen;
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement(ojb);
        if (root instanceof Database && (ddlgen = (def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root)).getDDLGenerator()) instanceof SybaseDdlGenerator && ((SybaseDdlGenerator)ddlgen).getParameter() instanceof DatabaseIdentifier) {
            return (DatabaseIdentifier)((SybaseDdlGenerator)ddlgen).getParameter();
        }
        return null;
    }
}

