/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher.ui.launchbar;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildCommandLauncher;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChain2;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.linuxtools.docker.ui.Activator;

public class ContainerGCCToolChain
extends PlatformObject
implements IToolChain,
IToolChain2 {
    public static final String TYPE_ID = "org.eclipse.cdt.docker.launcher.gcc";
    private final IToolChainProvider provider;
    private final String id;
    private final java.nio.file.Path path;
    private final IEnvironmentVariable[] envVars;
    private final Map<String, String> properties = new HashMap<String, String>();
    private String cCommand;
    private String cppCommand;
    private String[] commands;

    public ContainerGCCToolChain(String id, IToolChainProvider provider, Map<String, String> properties, IEnvironmentVariable[] envVars) {
        this.provider = provider;
        this.path = new File("gcc").toPath();
        StringBuilder idBuilder = new StringBuilder("container-gcc-");
        idBuilder.append(properties.get(Platform.getOSArch()));
        idBuilder.append('-');
        idBuilder.append(this.path.toString());
        this.id = id;
        this.properties.putAll(properties);
        this.setProperty("seccomp_undefined", "true");
        this.envVars = envVars;
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public java.nio.file.Path getPath() {
        return this.path;
    }

    public IToolChainProvider getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return "";
    }

    public String getName() {
        String arch;
        StringBuilder name = new StringBuilder();
        String os = this.getProperty("os");
        if (os != null) {
            name.append(os);
            name.append(' ');
        }
        if ((arch = this.getProperty("arch")) != null) {
            name.append(arch);
            name.append(' ');
        }
        if (this.path != null) {
            name.append(this.path.toString());
        }
        return name.toString();
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        switch (key) {
            case "os": {
                return "linux-container";
            }
            case "arch": {
                return Platform.getOSArch();
            }
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public List<String> getBinaryParserIds() {
        return List.of("org.eclipse.cdt.core.ELF");
    }

    protected void addDiscoveryOptions(List<String> command) {
        command.add("-E");
        command.add("-P");
        command.add("-v");
        command.add("-dD");
    }

    public synchronized IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, List<String> commandStrings, IExtendedScannerInfo baseScannerInfo, IResource resource, URI buildDirectoryURI) {
        try {
            java.nio.file.Path buildDirectory = Paths.get(buildDirectoryURI);
            int offset = 0;
            java.nio.file.Path command = Paths.get(commandStrings.get(offset), new String[0]);
            if (command.toString().contains("ccache")) {
                command = Paths.get(commandStrings.get(++offset), new String[0]);
            }
            ArrayList<String> commandLine = new ArrayList<String>();
            if (command.isAbsolute()) {
                commandLine.add(command.toString());
            } else {
                commandLine.add(this.getCommandPath(command).toString());
            }
            if (baseScannerInfo != null) {
                if (baseScannerInfo.getIncludePaths() != null) {
                    String[] stringArray = baseScannerInfo.getIncludePaths();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String includePath = stringArray[n2];
                        commandLine.add("-I" + includePath);
                        ++n2;
                    }
                }
                if (baseScannerInfo.getDefinedSymbols() != null) {
                    for (Map.Entry macro : baseScannerInfo.getDefinedSymbols().entrySet()) {
                        if (macro.getValue() != null && !((String)macro.getValue()).isEmpty()) {
                            commandLine.add("-D" + (String)macro.getKey() + "=" + (String)macro.getValue());
                            continue;
                        }
                        commandLine.add("-D" + (String)macro.getKey());
                    }
                }
            }
            this.addDiscoveryOptions(commandLine);
            commandLine.addAll(commandStrings.subList(offset + 1, commandStrings.size()));
            if ("win32".equals(Platform.getOS())) {
                int i = 0;
                while (i < commandLine.size()) {
                    String arg = (String)commandLine.get(i);
                    if (arg.startsWith("\"") && arg.endsWith("\"")) {
                        commandLine.set(i, arg.substring(1, arg.length() - 1));
                    }
                    ++i;
                }
            }
            boolean haveOut = false;
            int i = 0;
            while (i < commandLine.size() - 1) {
                if (((String)commandLine.get(i)).equals("-o")) {
                    commandLine.set(i + 1, "-");
                    haveOut = true;
                    break;
                }
                ++i;
            }
            if (!haveOut) {
                commandLine.add("-o");
                commandLine.add("-");
            }
            java.nio.file.Path tmpFile = null;
            int i2 = 1;
            while (i2 < commandLine.size()) {
                block26: {
                    String arg = (String)commandLine.get(i2);
                    if (!arg.startsWith("-")) {
                        java.nio.file.Path filePath;
                        try {
                            filePath = buildDirectory.resolve((String)commandLine.get(i2)).normalize();
                        }
                        catch (InvalidPathException e) {
                            break block26;
                        }
                        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(filePath.toUri());
                        if (files.length > 0 && files[0].exists()) {
                            java.nio.file.Path parentPath = filePath.getParent();
                            String extension = files[0].getFileExtension();
                            extension = extension == null ? ".cpp" : String.valueOf('.') + extension;
                            tmpFile = Files.createTempFile(parentPath, ".sc", extension, new FileAttribute[0]);
                            commandLine.set(i2, tmpFile.toString());
                        }
                    } else if (arg.equals("-o")) {
                        ++i2;
                    }
                }
                ++i2;
            }
            if (tmpFile == null) {
                IPath parentPath;
                IPath iPath = parentPath = resource instanceof IFile ? resource.getParent().getLocation() : resource.getLocation();
                if (parentPath.toFile().exists()) {
                    tmpFile = Files.createTempFile(parentPath.toFile().toPath(), ".sc", ".cpp", new FileAttribute[0]);
                    commandLine.add(tmpFile.toString());
                }
            }
            return this.getScannerInfo(buildConfig, commandLine, buildDirectory, tmpFile);
        }
        catch (IOException e) {
            Activator.log((Throwable)e);
            return null;
        }
    }

    public synchronized IExtendedScannerInfo getDefaultScannerInfo(IBuildConfiguration buildConfig, IExtendedScannerInfo baseScannerInfo, ILanguage language, URI buildDirectoryURI) {
        String extension;
        ArrayList<String> commandLine;
        java.nio.file.Path buildDirectory;
        block16: {
            String[] commands;
            block15: {
                commands = this.getCompileCommands(language);
                if (commands != null && commands.length != 0) break block15;
                return null;
            }
            try {
                buildDirectory = Paths.get(buildDirectoryURI);
                java.nio.file.Path command = Paths.get(commands[0], new String[0]);
                commandLine = new ArrayList<String>();
                if (command.isAbsolute()) {
                    commandLine.add(command.toString());
                } else {
                    commandLine.add(this.getCommandPath(command).toString());
                }
                if (baseScannerInfo != null) {
                    if (baseScannerInfo.getIncludePaths() != null) {
                        String[] stringArray = baseScannerInfo.getIncludePaths();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String includePath = stringArray[n2];
                            commandLine.add("-I" + includePath);
                            ++n2;
                        }
                    }
                    if (baseScannerInfo.getDefinedSymbols() != null) {
                        for (Map.Entry macro : baseScannerInfo.getDefinedSymbols().entrySet()) {
                            if (macro.getValue() != null && !((String)macro.getValue()).isEmpty()) {
                                commandLine.add("-D" + (String)macro.getKey() + "=" + (String)macro.getValue());
                                continue;
                            }
                            commandLine.add("-D" + (String)macro.getKey());
                        }
                    }
                }
                this.addDiscoveryOptions(commandLine);
                commandLine.add("-o");
                commandLine.add("-");
                if ("org.eclipse.cdt.core.g++".equals(language.getId())) {
                    extension = ".cpp";
                    break block16;
                }
                if ("org.eclipse.cdt.core.gcc".equals(language.getId())) {
                    extension = ".c";
                    break block16;
                }
                return null;
            }
            catch (IOException e) {
                Activator.log((Throwable)e);
                return null;
            }
        }
        if (!Files.exists(buildDirectory, new LinkOption[0])) {
            Files.createDirectories(buildDirectory, new FileAttribute[0]);
        }
        java.nio.file.Path tmpFile = Files.createTempFile(buildDirectory, ".sc", extension, new FileAttribute[0]);
        commandLine.add(tmpFile.toString());
        return this.getScannerInfo(buildConfig, commandLine, buildDirectory, tmpFile);
    }

    /*
     * Exception decompiling
     */
    private IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, List<String> commandLine, java.nio.file.Path buildDirectory, java.nio.file.Path tmpFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] getErrorParserIds() {
        return new String[]{"org.eclipse.cdt.core.GCCErrorParser", "org.eclipse.cdt.core.GASErrorParser", "org.eclipse.cdt.core.GLDErrorParser", "org.eclipse.cdt.core.GmakeErrorParser", "org.eclipse.cdt.core.CWDLocator"};
    }

    public IEnvironmentVariable getVariable(String name) {
        if (this.envVars != null) {
            IEnvironmentVariable[] iEnvironmentVariableArray = this.envVars;
            int n = this.envVars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                if (var.getName().equals(name)) {
                    return var;
                }
                ++n2;
            }
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables() {
        return this.envVars;
    }

    public java.nio.file.Path getCommandPath(java.nio.file.Path command) {
        return command;
    }

    private void initCompileCommands() {
        if (this.commands == null) {
            this.cCommand = this.path.getFileName().toString();
            this.cppCommand = null;
            if (this.cCommand.contains("gcc")) {
                this.cppCommand = this.cCommand.replace("gcc", "g++");
                this.commands = new String[]{this.cCommand, this.cppCommand, this.cCommand.replace("gcc", "cc"), this.cCommand.replace("gcc", "c++")};
            } else if (this.cCommand.contains("clang")) {
                this.cppCommand = this.cCommand.replace("clang", "clang++");
                this.commands = new String[]{this.cCommand, this.cppCommand};
            } else if (this.cCommand.contains("emcc")) {
                this.cppCommand = this.cCommand.replace("emcc", "em++");
                this.commands = new String[]{this.cCommand, this.cppCommand};
            } else {
                this.commands = new String[]{this.cCommand};
            }
        }
    }

    public String[] getCompileCommands() {
        this.initCompileCommands();
        return this.commands;
    }

    public String[] getCompileCommands(ILanguage language) {
        this.initCompileCommands();
        if ("org.eclipse.cdt.core.g++".equals(language.getId())) {
            return new String[]{this.cppCommand != null ? this.cppCommand : this.cCommand};
        }
        if ("org.eclipse.cdt.core.gcc".equals(language.getId())) {
            return new String[]{this.cCommand};
        }
        return new String[0];
    }

    public IResource[] getResourcesFromCommand(List<String> cmd, URI buildDirectoryURI) {
        ArrayList<IFile> resources = new ArrayList<IFile>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = cmd.size() - 1;
        while (i >= 0) {
            String arg = cmd.get(i);
            if (arg.startsWith("-")) break;
            if (i > 1 && cmd.get(i - 1).equals("-o")) {
                --i;
            } else {
                try {
                    URI uri;
                    java.nio.file.Path srcPath = Paths.get(arg, new String[0]);
                    if (srcPath.isAbsolute()) {
                        uri = srcPath.toUri();
                    } else {
                        String drive;
                        if (arg.startsWith("/") && Platform.getOS().equals("win32") && (drive = srcPath.getName(0).toString()).length() == 1) {
                            srcPath = Paths.get(String.valueOf(drive) + ":\\", new String[0]).resolve(srcPath.subpath(1, srcPath.getNameCount()));
                        }
                        uri = Paths.get(buildDirectoryURI).resolve(srcPath).toUri().normalize();
                    }
                    IFile[] iFileArray = root.findFilesForLocationURI(uri);
                    int n = iFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile resource = iFileArray[n2];
                        resources.add(resource);
                        ++n2;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            --i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public List<String> stripCommand(List<String> command, IResource[] resources) {
        ArrayList<String> newCommand = new ArrayList<String>();
        int i = 0;
        while (i < command.size() - resources.length) {
            String arg = command.get(i);
            if (arg.startsWith("-o")) {
                if (arg.equals("-o")) {
                    ++i;
                }
            } else {
                newCommand.add(arg);
            }
            ++i;
        }
        return newCommand;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ContainerGCCToolChain tc = (ContainerGCCToolChain)((Object)obj);
        return tc.id == this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public Process startBuildProcess(ICBuildConfiguration config, List<String> command, String buildDirectory, IEnvironmentVariable[] envVars, IConsole console, IProgressMonitor monitor) throws CoreException, IOException {
        Path cmdPath = new Path("/usr/bin/env");
        ArrayList<String> argList = new ArrayList<String>();
        IEnvironmentVariable[] iEnvironmentVariableArray = envVars;
        int n = envVars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            argList.add(String.valueOf(var.getName()) + "=" + var.getValue());
            ++n2;
        }
        argList.add("sh");
        argList.add("-c");
        StringBuffer buf = new StringBuffer();
        for (String s : command) {
            buf.append(s);
            buf.append(" ");
        }
        buf.deleteCharAt(buf.length() - 1);
        argList.add(buf.toString());
        CommandLauncherManager.getInstance().processIncludePaths(config, Collections.emptyList());
        ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher(config);
        launcher.setProject(config.getBuildConfiguration().getProject());
        ((CBuildConfiguration)config).setLauncher(launcher);
        if (launcher instanceof ICBuildCommandLauncher) {
            ((ICBuildCommandLauncher)launcher).setBuildConfiguration(config);
        }
        Path workingDir = new Path(buildDirectory);
        Files.createDirectories(java.nio.file.Path.of(buildDirectory, new String[0]), new FileAttribute[0]);
        Process p = launcher.execute((IPath)cmdPath, argList.toArray(new String[0]), new String[0], (IPath)workingDir, monitor);
        return p;
    }
}

