/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntJRETab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;

public class AntLaunchShortcut
implements ILaunchShortcut2 {
    private boolean fShowDialog = false;
    private static final int MAX_TARGET_APPEND_LENGTH = 30;
    private static final String DEFAULT_TARGET = "default";

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            if (object instanceof AntElementNode) {
                this.launch((AntElementNode)object, mode);
                return;
            }
            IResource resource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            if (resource != null) {
                if (!AntUtil.isKnownAntFile(resource) && !AntUtil.isKnownBuildfileName(resource.getName())) {
                    if (resource.getType() == 1) {
                        resource = resource.getParent();
                    }
                    resource = this.findBuildFile((IContainer)resource);
                }
                if (resource != null) {
                    IFile file = (IFile)resource;
                    this.launch(file.getFullPath(), file.getProject(), mode, null);
                    return;
                }
            }
        }
        this.antFileNotFound();
    }

    public void launch(AntElementNode node, String mode) {
        IEditorInput editorInput;
        ILocationProvider locationProvider;
        Object selectedTargetName = null;
        if (node instanceof AntTargetNode) {
            AntTargetNode targetNode = (AntTargetNode)node;
            selectedTargetName = targetNode.isDefaultTarget() ? DEFAULT_TARGET : targetNode.getTarget().getName() + ",";
        } else if (node instanceof AntProjectNode) {
            selectedTargetName = DEFAULT_TARGET;
        } else if (node instanceof AntTaskNode) {
            AntTaskNode taskNode = (AntTaskNode)node;
            selectedTargetName = taskNode.getTask().getOwningTarget().getName();
        }
        IFile file = node.getBuildFileResource();
        if (file != null) {
            this.launch(file.getFullPath(), file.getProject(), mode, (String)selectedTargetName);
            return;
        }
        IWorkbenchPage page = AntUIPlugin.getActiveWorkbenchWindow().getActivePage();
        IPath filePath = null;
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && (locationProvider = (ILocationProvider)(editorInput = editor.getEditorInput()).getAdapter(ILocationProvider.class)) != null && (filePath = locationProvider.getPath((Object)editorInput)) != null) {
            this.launch(filePath, null, mode, (String)selectedTargetName);
            return;
        }
        this.antFileNotFound();
    }

    private void antFileNotFound() {
        AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.AntLaunchShortcut_Unable, null);
    }

    private IFile findBuildFile(IContainer parent) {
        String[] names = AntUtil.getKnownBuildfileNames();
        if (names == null) {
            return null;
        }
        IContainer lparent = parent;
        IResource file = null;
        while (file == null || file.getType() != 1) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                file = lparent.findMember(name);
                if (file != null && file.getType() == 1) break;
                ++n2;
            }
            lparent = lparent.getParent();
            if (lparent != null) continue;
            return null;
        }
        return (IFile)file;
    }

    protected List<ILaunchConfiguration> collectConfigurations(IPath filepath) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        if (type != null) {
            try {
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
                ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
                IPath location = null;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                    if (config.exists()) {
                        try {
                            location = ExternalToolsUtil.getLocation((ILaunchConfiguration)config);
                            if (location != null && location.equals((Object)filepath)) {
                                list.add(config);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
                return list;
            }
            catch (CoreException coreException) {}
        }
        return Collections.EMPTY_LIST;
    }

    public static String getNewLaunchConfigurationName(IPath filePath, String projectName, String targetAttribute) {
        StringBuilder buffer = new StringBuilder();
        if (projectName != null) {
            buffer.append(projectName);
            buffer.append(' ');
            buffer.append(filePath.lastSegment());
        } else {
            buffer.append(filePath.lastSegment());
        }
        if (targetAttribute != null) {
            buffer.append(" [");
            if (targetAttribute.length() > 33) {
                buffer.append(targetAttribute.substring(0, 30));
                buffer.append("...");
            } else {
                buffer.append(targetAttribute);
            }
            buffer.append(']');
        }
        String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(buffer.toString());
        return name;
    }

    public void launch(IPath filePath, IProject project, String mode, String targetAttribute) {
        List<ILaunchConfiguration> configs;
        ILaunchConfiguration configuration = null;
        IFile backingfile = null;
        if (project != null) {
            backingfile = project.getFile(filePath.removeFirstSegments(1));
        }
        if ((configs = this.collectConfigurations(backingfile != null && backingfile.exists() ? backingfile.getLocation() : filePath)).isEmpty()) {
            configuration = AntLaunchShortcut.createDefaultLaunchConfiguration(filePath, project != null && project.exists() ? project : null);
        } else if (configs.size() == 1) {
            configuration = configs.get(0);
        } else {
            configuration = AntLaunchShortcut.chooseConfig(configs);
            if (configuration == null) {
                return;
            }
        }
        if (configuration != null) {
            try {
                if (targetAttribute != null && !targetAttribute.equals(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", DEFAULT_TARGET))) {
                    ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
                    String attrValue = null;
                    if (!DEFAULT_TARGET.equals(targetAttribute)) {
                        attrValue = targetAttribute;
                    }
                    copy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", attrValue);
                    configuration = copy.doSave();
                }
            }
            catch (CoreException exception) {
                AntLaunchShortcut.reportError(MessageFormat.format(AntLaunchConfigurationMessages.AntLaunchShortcut_Exception_launching, filePath.toFile().getName()), exception);
                return;
            }
            this.launch(mode, configuration);
        } else {
            this.antFileNotFound();
        }
    }

    private void launch(String mode, ILaunchConfiguration configuration) {
        if (this.fShowDialog) {
            Status status = new Status(1, "org.eclipse.ant.ui", 1000, "", null);
            String groupId = mode.equals("debug") ? "org.eclipse.debug.ui.launchGroup.debug" : "org.eclipse.ui.externaltools.launchGroup";
            DebugUITools.openLaunchConfigurationDialog((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)groupId, (IStatus)status);
        } else {
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IFile file) {
        return AntLaunchShortcut.createDefaultLaunchConfiguration(file.getFullPath(), file.getProject());
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IPath filePath, IProject project) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        String projectName = project != null ? project.getName() : null;
        String name = AntLaunchShortcut.getNewLaunchConfigurationName(filePath, projectName, null);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            if (project != null) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", filePath.toString()));
            } else {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", filePath.toString());
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
            CommonTab tab = new CommonTab();
            tab.setDefaults(workingCopy);
            tab.dispose();
            if (project != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            }
            AntJRETab jreTab = new AntJRETab();
            jreTab.setDefaults(workingCopy);
            jreTab.dispose();
            IFile file = AntUtil.getFileForLocation(filePath.toString(), null);
            workingCopy.setMappedResources(new IResource[]{file});
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            AntLaunchShortcut.reportError(MessageFormat.format(AntLaunchConfigurationMessages.AntLaunchShortcut_2, filePath.toString()), e);
            return null;
        }
    }

    public static List<ILaunchConfiguration> findExistingLaunchConfigurations(IFile file) {
        ILaunchManager manager;
        ILaunchConfigurationType type;
        IPath filePath;
        ArrayList<ILaunchConfiguration> validConfigs = new ArrayList<ILaunchConfiguration>();
        if (file != null && (filePath = file.getLocation()) != null && (type = (manager = DebugPlugin.getDefault().getLaunchManager()).getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType")) != null) {
            try {
                ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
                int n = iLaunchConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                    try {
                        if (filePath.equals((Object)ExternalToolsUtil.getLocation((ILaunchConfiguration)config))) {
                            validConfigs.add(config);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++n2;
                }
            }
            catch (CoreException e) {
                AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.AntLaunchShortcut_3, e);
            }
        }
        return validConfigs;
    }

    public static ILaunchConfiguration chooseConfig(List<ILaunchConfiguration> configs) {
        if (configs.isEmpty()) {
            return null;
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs.toArray(new ILaunchConfiguration[configs.size()]));
        dialog.setTitle(AntLaunchConfigurationMessages.AntLaunchShortcut_4);
        dialog.setMessage(AntLaunchConfigurationMessages.AntLaunchShortcut_5);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public void launch(IEditorPart editor, String mode) {
        ILocationProvider locationProvider;
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        IPath filepath = null;
        if (file != null) {
            filepath = file.getFullPath();
        }
        if (filepath == null && (locationProvider = (ILocationProvider)input.getAdapter(ILocationProvider.class)) != null) {
            filepath = locationProvider.getPath((Object)input);
        }
        if (filepath != null && (AntUtil.isKnownAntFile((IResource)file) || AntUtil.isKnownAntFile(filepath.toFile()))) {
            this.launch(filepath, file == null ? null : file.getProject(), mode, null);
            return;
        }
        if (file != null) {
            if (!AntUtil.isKnownBuildfileName(file.getName())) {
                file = this.findBuildFile(file.getParent());
            }
            if (file != null) {
                this.launch(file.getFullPath(), file.getProject(), mode, null);
                return;
            }
        }
        this.antFileNotFound();
    }

    protected static void reportError(String message, Throwable throwable) {
        Object status = null;
        status = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.ant.ui", 0, message, throwable);
        ErrorDialog.openError((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (String)AntLaunchConfigurationMessages.AntLaunchShortcut_Error_7, (String)AntLaunchConfigurationMessages.AntLaunchShortcut_Build_Failed_2, (IStatus)status);
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            if (object instanceof AntElementNode) {
                return new ILaunchConfiguration[0];
            }
            IResource resource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            if (resource != null) {
                IPath location;
                if (!AntUtil.isKnownAntFile(resource) && !AntUtil.isKnownBuildfileName(resource.getName())) {
                    if (resource.getType() == 1) {
                        resource = resource.getParent();
                    }
                    resource = this.findBuildFile((IContainer)resource);
                }
                if (resource != null && (location = ((IFile)resource).getLocation()) != null) {
                    List<ILaunchConfiguration> list = this.collectConfigurations(location);
                    return list.toArray(new ILaunchConfiguration[list.size()]);
                }
            }
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editor) {
        ILocationProvider locationProvider;
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        IPath filepath = null;
        if (file != null) {
            filepath = file.getLocation();
        }
        if (filepath == null && (locationProvider = (ILocationProvider)input.getAdapter(ILocationProvider.class)) != null) {
            filepath = locationProvider.getPath((Object)input);
        }
        if (filepath != null && AntUtil.isKnownAntFileName(filepath.toString())) {
            List<ILaunchConfiguration> list = this.collectConfigurations(filepath);
            return list.toArray(new ILaunchConfiguration[list.size()]);
        }
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        IResource resource;
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
            if (!AntUtil.isKnownAntFile(resource)) {
                if (AntUtil.isKnownBuildfileName(resource.getName())) {
                    return resource;
                }
                if (resource.getType() == 1) {
                    resource = resource.getParent();
                }
                resource = this.findBuildFile((IContainer)resource);
            }
            return resource;
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        return (IResource)input.getAdapter(IFile.class);
    }
}

