/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.MockUpResourceWriter;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceIdMap;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.core.util.UniqueKeyGenerator;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class ResourceManager {
    private final IProject debugProject;
    private final VmResourceIdMap<VmResourceInfo> resourceIdToInfo = new VmResourceIdMap();
    private final Map<IFile, VmResourceInfo> file2Info = new HashMap<IFile, VmResourceInfo>();
    private static final String UNNAMED_SCRIPTS_FOLDER_NAME = "unnamed scripts";

    public ResourceManager(IProject debugProject) {
        this.debugProject = debugProject;
    }

    public synchronized VmResource getVmResource(VmResourceId id) {
        VmResourceInfo info = this.resourceIdToInfo.get(id);
        if (info == null) {
            return null;
        }
        return info.vmResourceImpl;
    }

    public synchronized Collection<? extends VmResource> findVmResources(Pattern pattern) {
        ArrayList<VmResource> result = new ArrayList<VmResource>(1);
        for (VmResourceInfo info : this.file2Info.values()) {
            String name = info.id.getName();
            if (name == null || !pattern.matcher(name).find()) continue;
            result.add(info.vmResourceImpl);
        }
        return result;
    }

    public synchronized VmResourceId getResourceId(IFile resource) {
        VmResourceInfo info = (VmResourceInfo)BasicUtil.getSafe(this.file2Info, (Object)resource);
        if (info == null) {
            return null;
        }
        return info.id;
    }

    public synchronized void addScript(Script newScript) {
        VmResourceId id = VmResourceId.forScript(newScript);
        try {
            ScriptSet scriptSet;
            VmResourceInfo info = this.resourceIdToInfo.get(id);
            if (info == null) {
                scriptSet = new ScriptSet();
                info = this.createAndRegisterResourceFile(id, scriptSet);
            } else {
                scriptSet = (ScriptSet)info.metadata;
            }
            scriptSet.add(newScript);
            ResourceManager.writeScriptSource(scriptSet.asCollection(), info.file);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to add script " + id, e);
        }
    }

    public synchronized VmResource createTemporaryFile(final VmResource.Metadata metadata, String proposedFileName) {
        UniqueKeyGenerator.Factory<VmResourceInfo> factory = new UniqueKeyGenerator.Factory<VmResourceInfo>(){

            @Override
            public VmResourceInfo tryCreate(String uniqueName) {
                VmResourceInfo info = (VmResourceInfo)ResourceManager.this.resourceIdToInfo.getByName(uniqueName);
                if (info != null) {
                    return null;
                }
                VmResourceId id = new VmResourceId(uniqueName, null);
                return ResourceManager.this.createAndRegisterResourceFile(id, metadata);
            }
        };
        VmResourceInfo info = UniqueKeyGenerator.createUniqueKey(proposedFileName, 1000, factory);
        return info.vmResourceImpl;
    }

    private VmResourceInfo createAndRegisterResourceFile(VmResourceId id, VmResource.Metadata metadata) {
        IFile scriptFile;
        if (id.getName() == null) {
            IFolder specialDir = this.getOrCreateUnnamedScriptFolder(this.debugProject);
            scriptFile = ChromiumDebugPluginUtil.createFile(specialDir, ResourceManager.getFileNameForScriptId(id.getId()));
        } else {
            scriptFile = ChromiumDebugPluginUtil.createFile(this.debugProject, ResourceManager.getFileNameForScriptName(id.getName()));
        }
        VmResourceInfo info = new VmResourceInfo(scriptFile, id, metadata);
        this.resourceIdToInfo.put(id, info);
        VmResourceInfo conflict = this.file2Info.put(scriptFile, info);
        if (conflict != null) {
            throw new RuntimeException();
        }
        return info;
    }

    private static String getFileNameForScriptName(String scriptName) {
        int slashPos = scriptName.lastIndexOf(47);
        return scriptName.substring(slashPos + 1);
    }

    private static String getFileNameForScriptId(Object scriptId) {
        return scriptId.toString();
    }

    private IFolder getOrCreateUnnamedScriptFolder(IProject project) {
        IFolder unnamedDir = project.getFolder(UNNAMED_SCRIPTS_FOLDER_NAME);
        if (!unnamedDir.exists()) {
            try {
                unnamedDir.create(true, true, null);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return unnamedDir;
    }

    public void scriptCollected(Script script) {
    }

    public synchronized void reloadScript(Script script) {
        VmResourceId id = VmResourceId.forScript(script);
        VmResourceInfo info = this.resourceIdToInfo.get(id);
        if (info == null) {
            throw new RuntimeException("Script file not found");
        }
        ScriptSet scriptSet = (ScriptSet)info.metadata;
        scriptSet.add(script);
        ResourceManager.writeScriptSource(scriptSet.asCollection(), info.file);
    }

    public synchronized void clear() {
        this.deleteAllScriptFiles();
        this.resourceIdToInfo.clear();
        this.file2Info.clear();
    }

    private void deleteAllScriptFiles() {
        try {
            ResourcesPlugin.getWorkspace().delete((IResource[])this.file2Info.keySet().toArray(new IFile[this.file2Info.size()]), true, null);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log(e);
        }
    }

    private static void writeScriptSource(Collection<Script> scripts, IFile file) {
        String fileSource = MockUpResourceWriter.writeScriptSource(scripts);
        try {
            ChromiumDebugPluginUtil.writeFile(file, fileSource);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log(e);
        }
    }

    private static class ScriptSet
    implements VmResource.ScriptHolder {
        private final Map<Object, Script> idToScript = new HashMap<Object, Script>(2);

        private ScriptSet() {
        }

        @Override
        public Script getSingleScript() {
            if (this.idToScript.size() != 1) {
                throw new UnsupportedOperationException("Not supported for compound resources");
            }
            return this.idToScript.values().iterator().next();
        }

        public void add(Script newScript) {
            this.idToScript.put(newScript.getId(), newScript);
        }

        public Collection<Script> asCollection() {
            return this.idToScript.values();
        }
    }

    private class VmResourceInfo {
        final IFile file;
        final VmResourceId id;
        final VmResource.Metadata metadata;
        final VmResource vmResourceImpl = new VmResource(){

            @Override
            public VmResourceId getId() {
                return VmResourceInfo.this.id;
            }

            @Override
            public VmResource.Metadata getMetadata() {
                return VmResourceInfo.this.metadata;
            }

            @Override
            public IFile getVProjectFile() {
                return VmResourceInfo.this.file;
            }

            @Override
            public void deleteResourceAndFile() {
                ResourceManager.this.resourceIdToInfo.remove(VmResourceInfo.this.id);
                BasicUtil.removeSafe((Map)ResourceManager.this.file2Info, (Object)VmResourceInfo.this.file);
                try {
                    VmResourceInfo.this.file.delete(false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ChromiumDebugPlugin.log(e);
                }
            }

            @Override
            public String getLocalVisibleFileName() {
                String name = VmResourceInfo.this.file.getName();
                if (name.endsWith(".chromium")) {
                    return name.substring(0, name.length() - ".chromium".length());
                }
                return name;
            }
        };

        VmResourceInfo(IFile file, VmResourceId id, VmResource.Metadata metadata) {
            this.file = file;
            this.id = id;
            this.metadata = metadata;
        }
    }
}

