/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.ILocatorModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.listener.LocatorListener;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelUpdateService;

public class LocatorModel
extends PlatformObject
implements ILocatorModel {
    private final UUID uniqueId = UUID.randomUUID();
    private boolean disposed = false;
    final Map<String, ILocatorNode> locatorNodes = new HashMap<String, ILocatorNode>();
    private final List<ILocatorModelListener> modelListener = new ArrayList<ILocatorModelListener>();
    private ILocator.LocatorListener locatorListener = null;
    private final ILocatorModelRefreshService refreshService = new LocatorModelRefreshService(this);
    private final ILocatorModelLookupService lookupService = new LocatorModelLookupService(this);
    private final ILocatorModelUpdateService updateService = new LocatorModelUpdateService(this);

    @Override
    public void addListener(ILocatorModelListener listener) {
        Assert.isNotNull((Object)listener);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.addListener( " + listener + " )", "trace/locatorModel", (Object)this);
        }
        if (!this.modelListener.contains(listener)) {
            this.modelListener.add(listener);
        }
    }

    @Override
    public void removeListener(ILocatorModelListener listener) {
        Assert.isNotNull((Object)listener);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.removeListener( " + listener + " )", "trace/locatorModel", (Object)this);
        }
        this.modelListener.remove(listener);
    }

    @Override
    public ILocatorModelListener[] getListener() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return this.modelListener.toArray(new ILocatorModelListener[this.modelListener.size()]);
    }

    @Override
    public void dispose() {
        ILocatorModelListener[] listeners;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.dispose()", "trace/locatorModel", (Object)this);
        }
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.locatorListener != null) {
            Protocol.getLocator().removeListener(this.locatorListener);
            this.locatorListener = null;
        }
        if ((listeners = this.getListener()).length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILocatorModelListener[] iLocatorModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocatorModelListener listener = iLocatorModelListenerArray[n2];
                        listener.modelDisposed(LocatorModel.this);
                        ++n2;
                    }
                }
            });
        }
        this.modelListener.clear();
        this.locatorNodes.clear();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public ILocatorNode[] getLocatorNodes() {
        return this.locatorNodes.values().toArray(new ILocatorNode[this.locatorNodes.size()]);
    }

    @Override
    public IPeer[] getPeers() {
        ArrayList<IPeer> peers = new ArrayList<IPeer>();
        for (ILocatorNode locatorNode : this.locatorNodes.values()) {
            peers.add(locatorNode.getPeer());
        }
        return peers.toArray(new IPeer[peers.size()]);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ILocator.LocatorListener.class)) {
            return this.locatorListener;
        }
        if (adapter.isAssignableFrom(ILocatorModelRefreshService.class)) {
            return this.refreshService;
        }
        if (adapter.isAssignableFrom(ILocatorModelLookupService.class)) {
            return this.lookupService;
        }
        if (adapter.isAssignableFrom(ILocatorModelUpdateService.class)) {
            return this.updateService;
        }
        if (adapter.isAssignableFrom(Map.class)) {
            return this.locatorNodes;
        }
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    @Override
    public <V extends ILocatorModelService> V getService(Class<V> serviceInterface) {
        Assert.isNotNull(serviceInterface);
        return (V)((ILocatorModelService)this.getAdapter(serviceInterface));
    }

    @Override
    public IPeer validatePeer(IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String transport = peer.getTransportName();
        if (transport == null || !"TCP".equals(transport) && !"SSL".equals(transport)) {
            return peer;
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeer( " + peer.getID() + " )", "trace/locatorModel", (Object)this);
        }
        IPeer result = peer;
        String loopback = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
        String canonical = IPAddressUtil.getInstance().getIPv4CanonicalAddress();
        String peerIP = (String)peer.getAttributes().get("Host");
        String peerPort = (String)peer.getAttributes().get("Port");
        if (!IPAddressUtil.getInstance().isLocalHost(peerIP)) {
            return result;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, ILocatorNode> entry : this.locatorNodes.entrySet()) {
            IPeer candidate = entry.getValue().getPeer();
            if (!"TCP".equals(candidate.getTransportName()) && !"SSL".equals(candidate.getTransportName())) continue;
            String ip = (String)candidate.getAttributes().get("Host");
            Assert.isNotNull((Object)ip);
            String port = (String)candidate.getAttributes().get("Port");
            Assert.isNotNull((Object)port);
            if (!IPAddressUtil.getInstance().isLocalHost(ip) || !port.equals(peerPort)) continue;
            if (ip.equals(loopback)) {
                result = null;
                break;
            }
            if (peerIP.equals(loopback)) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (ip.equals(canonical)) {
                result = null;
                break;
            }
            if (peerIP.equals(canonical)) {
                toRemove.add(entry.getKey());
                continue;
            }
            result = null;
            break;
        }
        for (String candidate : toRemove) {
            ILocatorNode node;
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeer( " + peer.getID() + " ): Remove old peer with id " + candidate, "trace/locatorModel", (Object)this);
            }
            if ((node = this.locatorNodes.get(candidate)) == null) continue;
            this.getService(ILocatorModelUpdateService.class).remove(node.getPeer());
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeer( " + peer.getID() + " ): result = " + (result != null ? result.getID() : "null"), "trace/locatorModel", (Object)this);
        }
        return result;
    }

    public void checkLocatorListener() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)Protocol.getLocator());
        if (this.locatorListener == null) {
            this.locatorListener = this.doCreateLocatorListener(this);
            Protocol.getLocator().addListener(this.locatorListener);
        }
    }

    protected ILocator.LocatorListener doCreateLocatorListener(ILocatorModel model) {
        Assert.isNotNull((Object)model);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return new LocatorListener(model);
    }
}

