/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.history;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.persistence.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;

public class HistoryManager {
    private static final int HISTORY_LENGTH = 5;
    private Map<String, List<String>> history = new HashMap<String, List<String>>();

    public static HistoryManager getInstance() {
        return LazyInstance.instance;
    }

    HistoryManager() {
        this.initialize();
    }

    private void initialize() {
        this.history.clear();
        try {
            IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            if (uRIPersistenceService == null) {
                throw new IOException("Persistence service instance unavailable.");
            }
            this.history = (Map)uRIPersistenceService.read(this.history, this.getURI());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private URI getURI() {
        IPath pluginPath = CoreBundleActivator.getDefault().getStateLocation();
        pluginPath = pluginPath.append(".history");
        return pluginPath.toFile().toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<String, List<String>> map = this.history;
        synchronized (map) {
            try {
                IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                if (uRIPersistenceService == null) {
                    throw new IOException("Persistence service instance unavailable.");
                }
                uRIPersistenceService.write(this.history, this.getURI());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String[] getHistory(String historyId) {
        Assert.isNotNull((Object)historyId);
        List<String> entries = this.history.get(historyId);
        if (entries == null) {
            entries = new ArrayList<String>();
        }
        return entries.toArray(new String[entries.size()]);
    }

    public String[] getMatchingHistoryIds(String historyIdPattern) {
        Assert.isNotNull((Object)historyIdPattern);
        ArrayList<String> historyIds = new ArrayList<String>();
        for (String historyId : this.history.keySet()) {
            if (!historyId.matches(historyIdPattern)) continue;
            historyIds.add(historyId);
        }
        return historyIds.toArray(new String[historyIds.size()]);
    }

    public String getFirst(String historyId) {
        String[] history = this.getHistory(historyId);
        return history.length > 0 ? history[0] : null;
    }

    public boolean add(String historyId, String entry) {
        return this.add(historyId, entry, 5);
    }

    public boolean add(String historyId, String entry, int historyLength) {
        Assert.isNotNull((Object)historyId);
        Assert.isNotNull((Object)entry);
        Assert.isTrue((historyLength > 0 ? 1 : 0) != 0);
        List<String> ids = this.history.get(historyId);
        if (ids == null) {
            ids = new ArrayList<String>();
            this.history.put(historyId, ids);
        }
        if (ids.contains(entry)) {
            ids.remove(entry);
        }
        ids.add(0, entry);
        while (ids.size() > historyLength) {
            ids.remove(historyLength);
        }
        this.flush();
        EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"added", (Object)historyId, (Object)historyId));
        return true;
    }

    public void set(String historyId, String[] entries) {
        this.set(historyId, entries, 5);
    }

    public void set(String historyId, String[] entries, int historyLength) {
        Assert.isNotNull((Object)historyId);
        Assert.isNotNull((Object)entries);
        this.history.put(historyId, Arrays.asList(entries));
        List<String> newIds = this.history.get(historyId);
        while (newIds.size() > historyLength) {
            newIds.remove(historyLength);
        }
        this.flush();
        EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"changed", (Object)historyId, (Object)historyId));
    }

    public boolean remove(String historyId, String entry) {
        Assert.isNotNull((Object)historyId);
        Assert.isNotNull((Object)entry);
        boolean removed = false;
        List<String> ids = this.history.get(historyId);
        if (ids != null) {
            removed |= ids.remove(entry);
            if (ids.isEmpty()) {
                this.history.remove(historyId);
            }
        }
        if (removed) {
            this.flush();
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"removed", (Object)historyId, (Object)historyId));
        }
        return removed;
    }

    public void clear(String historyId) {
        List<String> entries = null;
        if (historyId == null) {
            this.history.clear();
        } else {
            entries = this.history.remove(historyId);
        }
        if (entries != null || historyId == null) {
            this.flush();
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"removed", (Object)historyId, (Object)historyId));
        }
    }

    private static class LazyInstance {
        public static HistoryManager instance = new HistoryManager();

        private LazyInstance() {
        }
    }
}

