/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.impl.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class Marker {
    private Annotation annotation;
    private IEditorPart editor;

    public Marker(Annotation annotation, IEditorPart editorPart) {
        this.annotation = annotation;
        this.editor = editorPart;
    }

    protected Annotation getAnnotation() {
        return this.annotation;
    }

    public String getText() {
        return this.annotation.getText();
    }

    public String getType() {
        return this.annotation.getType();
    }

    public int getLineNumber() {
        ITextEditor textEditor = (ITextEditor)this.editor.getAdapter(ITextEditor.class);
        if (textEditor == null) {
            return -1;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return -1;
        }
        IAnnotationModel model = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
        IDocument doc = documentProvider.getDocument((Object)this.editor.getEditorInput());
        int offset = model.getPosition(this.annotation).getOffset();
        int line = -1;
        try {
            line = doc.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException e) {
            throw new WorkbenchLayerException("Unable to find line number for AYT marker", e);
        }
        return line;
    }

    public int hashCode() {
        return this.annotation.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Marker other = (Marker)obj;
        return other.annotation.equals(this.annotation);
    }

    public String toString() {
        return "Marker [text=" + this.getText() + ", type=" + this.getType() + ", lineNumber=" + this.getLineNumber() + "]";
    }
}

