/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolItemHandler
extends ItemHandler {
    private static ToolItemHandler instance;

    public static ToolItemHandler getInstance() {
        if (instance == null) {
            instance = new ToolItemHandler();
        }
        return instance;
    }

    public void click(final ToolItem toolItem) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((toolItem.getStyle() & 2) != 0 || (toolItem.getStyle() & 0x20) != 0 || (toolItem.getStyle() & 0x10) != 0) {
                    toolItem.setSelection(!toolItem.getSelection());
                }
            }
        });
        this.sendClickNotifications((Widget)toolItem);
    }

    public boolean isSelected(final ToolItem toolItem) {
        boolean selectionState = (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return toolItem.getSelection();
            }
        });
        return selectionState;
    }

    public ToolBar getParent(final ToolItem item) {
        return (ToolBar)Display.syncExec((ResultRunnable)new ResultRunnable<ToolBar>(){

            public ToolBar run() {
                return item.getParent();
            }
        });
    }

    public boolean isDropDown(final ToolItem item) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                if ((4 & item.getStyle()) == 4) {
                    return true;
                }
                return false;
            }
        });
    }

    public void clickDropDown(ToolItem item) {
        this.notifyItem(13, 4, (Widget)item, (Widget)item);
    }

    public String getToolTipText(final ToolItem item) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return item.getToolTipText();
            }
        });
    }

    public boolean isEnabled(final ToolItem item) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return item.isEnabled();
            }
        });
    }

    public void setFocus(ToolItem swtItem) {
        ControlHandler.getInstance().setFocus((Control)this.getParent(swtItem));
    }
}

