/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.platform.commands.GetStatusTrace;
import org.eclipse.rcptt.ecl.platform.internal.commands.GetStatusMessageService;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class GetStatusTraceService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        GetStatusTrace getStatusTrace = (GetStatusTrace)command;
        ProcessStatus status = getStatusTrace.getStatus();
        String trace = GetStatusTraceService.getTraceFromStatus(status);
        context.getOutput().write((Object)trace);
        return Status.OK_STATUS;
    }

    private static String getTraceFromStatus(ProcessStatus status) {
        StringBuilder sb = new StringBuilder();
        GetStatusTraceService.processTrace(sb, status);
        return sb.toString();
    }

    private static void processTrace(StringBuilder sb, ProcessStatus status) {
        if (status.getChildren().isEmpty()) {
            String message = GetStatusMessageService.getMessageFromStatus(status);
            sb.insert(0, String.format("%s\n", message));
        } else {
            sb.insert(0, String.format("\tat %s\n", status.getMessage()));
            int i = status.getChildren().size() - 1;
            while (i >= 0) {
                GetStatusTraceService.processTrace(sb, (ProcessStatus)status.getChildren().get(i));
                --i;
            }
        }
    }
}

