/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.ErrorReporter;
import org.eclipse.pde.internal.core.builders.IncrementalErrorReporter;
import org.eclipse.pde.internal.core.builders.PDEBuilderHelper;
import org.eclipse.pde.internal.core.builders.PDEErrorHandler;
import org.eclipse.pde.internal.core.builders.SourceEntryErrorReporter;
import org.eclipse.pde.internal.core.ibundle.IBundleFragmentModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BuildErrorReporter
extends ErrorReporter
implements IBuildPropertiesConstants {
    private static final String DEF_SOURCE_ENTRY = "source..";
    private static final Set<String> RESERVED_NAMES = Set.of("meta-inf", "osgi-inf", "build.properties", "plugin.xml", "plugin.properties");
    private static final String ASSERT_IDENTIFIER = "assertIdentifier";
    private static final String ENUM_IDENTIFIER = "enumIdentifier";
    private static final String JRE_1_1 = "JRE-1.1";
    private static final String J2SE_1_2 = "J2SE-1.2";
    private static final String J2SE_1_3 = "J2SE-1.3";
    private static final String J2SE_1_4 = "J2SE-1.4";
    private static final String J2SE_1_5 = "J2SE-1.5";
    private static final String JavaSE_1_6 = "JavaSE-1.6";
    private static final String JavaSE_1_7 = "JavaSE-1.7";
    private static final String JavaSE_1_8 = "JavaSE-1.8";
    protected ArrayList<BuildProblem> fProblemList = new ArrayList();
    protected int fBuildSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build");
    protected int fClasspathSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.unresolved-import");
    protected int fJavaComplianceSeverity;
    protected int fJavaCompilerSeverity;
    protected int fSrcInclSeverity;
    protected int fBinInclSeverity;
    protected int fMissingOutputLibSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.missing.output");
    protected int fSrcLibSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.source.library");
    protected int fOututLibSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.output.library");
    protected int fEncodingSeverity;

    public BuildErrorReporter(IFile buildFile) {
        super(buildFile);
        this.fJavaComplianceSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.java.compliance");
        this.fJavaCompilerSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.java.compiler");
        this.fSrcInclSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.src.includes");
        this.fBinInclSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.bin.includes");
        this.fEncodingSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build.encodings");
    }

    @Override
    public void validate(IProgressMonitor monitor) {
        WorkspaceBuildModel wbm = new WorkspaceBuildModel(this.fFile);
        wbm.load();
        if (!wbm.isLoaded()) {
            return;
        }
        this.validateBuild(wbm.getBuild(true));
        if (!this.fProblemList.isEmpty()) {
            this.reportErrors(this.prepareTextBuildModel(monitor));
        }
    }

    private void validateBuild(IBuild build) {
        IBuildEntry[] entries;
        IBuildEntry binIncludes = null;
        IBuildEntry binExcludes = null;
        IBuildEntry srcIncludes = null;
        IBuildEntry srcExcludes = null;
        IBuildEntry jarsExtra = null;
        IBuildEntry bundleList = null;
        IBuildEntry javacSource = null;
        IBuildEntry javacTarget = null;
        IBuildEntry jreCompilationProfile = null;
        IBuildEntry javaProjectWarnings = null;
        ArrayList<IBuildEntry> javacWarnings = new ArrayList<IBuildEntry>();
        ArrayList<IBuildEntry> javacErrors = new ArrayList<IBuildEntry>();
        ArrayList<IBuildEntry> sourceEntries = new ArrayList<IBuildEntry>(1);
        ArrayList<String> sourceEntryKeys = new ArrayList<String>(1);
        ArrayList<IBuildEntry> outputEntries = new ArrayList<IBuildEntry>(1);
        HashMap<String, String> encodingEntries = new HashMap<String, String>();
        IBuildEntry[] iBuildEntryArray = entries = build.getBuildEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String[] tokens;
            IBuildEntry entry = iBuildEntryArray[n2];
            String name = entry.getName();
            if (entry.getTokens().length == 0) {
                this.prepareError(name, null, PDECoreMessages.BuildErrorReporter_emptyEntry, 8197, "fatal");
            } else if (name.equals("bin.includes")) {
                binIncludes = entry;
            } else if (name.equals("bin.excludes")) {
                binExcludes = entry;
            } else if (name.equals("src.includes")) {
                srcIncludes = entry;
            } else if (name.equals("src.excludes")) {
                srcExcludes = entry;
            } else if (name.equals("javacSource")) {
                javacSource = entry;
            } else if (name.equals("javacTarget")) {
                javacTarget = entry;
            } else if (name.equals("javacProjectSettings")) {
                javaProjectWarnings = entry;
            } else if (name.equals("jre.compilation.profile")) {
                jreCompilationProfile = entry;
            } else if (name.startsWith("javacWarnings.")) {
                javacWarnings.add(entry);
            } else if (name.startsWith("javacErrors.")) {
                javacErrors.add(entry);
            } else if (name.startsWith("source.")) {
                sourceEntries.add(entry);
            } else if (name.startsWith("output.")) {
                outputEntries.add(entry);
            } else if (name.startsWith("javacDefaultEncoding.")) {
                encodingEntries.put(entry.getName(), entry.getTokens()[0]);
            } else if (name.equals("jars.extra.classpath")) {
                jarsExtra = entry;
            } else if (name.equals("additional.bundles")) {
                bundleList = entry;
            } else if (name.equals("custom") && (tokens = entry.getTokens()).length == 1 && tokens[0].equalsIgnoreCase("true")) {
                return;
            }
            if (name.startsWith("source.")) {
                sourceEntryKeys.add(entry.getName());
            }
            ++n2;
        }
        if (this.fClasspathSeverity != 2 && bundleList != null) {
            this.validateDependencyManagement(bundleList);
        }
        if (jarsExtra != null) {
            this.validateJarsExtraClasspath(jarsExtra);
        }
        this.validateIncludes(binIncludes, sourceEntryKeys, this.fBinInclSeverity, "compilers.p.build.bin.includes");
        this.validateIncludes(binExcludes, sourceEntryKeys, this.fBinInclSeverity, "compilers.p.build.bin.includes");
        this.validateIncludes(srcIncludes, sourceEntryKeys, this.fSrcInclSeverity, "compilers.p.build.src.includes");
        this.validateIncludes(srcExcludes, sourceEntryKeys, this.fSrcInclSeverity, "compilers.p.build.src.includes");
        this.validateSourceFoldersInSrcIncludes(srcIncludes);
        try {
            IJavaProject jp = JavaCore.create((IProject)this.fProject);
            if (jp.exists()) {
                IClasspathEntry[] cpes = jp.getRawClasspath();
                this.validateMissingLibraries(sourceEntryKeys, cpes);
                this.validateSourceEntries(sourceEntries, srcExcludes, cpes);
                SourceEntryErrorReporter srcEntryErrReporter = new SourceEntryErrorReporter(this.fFile, build);
                srcEntryErrReporter.initialize(sourceEntries, outputEntries, cpes, this.fProject);
                srcEntryErrReporter.validate();
                ArrayList<BuildProblem> problems = srcEntryErrReporter.getProblemList();
                int i = 0;
                while (i < problems.size()) {
                    if (!this.fProblemList.contains(problems.get(i))) {
                        this.fProblemList.add(problems.get(i));
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        this.validateMissingSourceInBinIncludes(binIncludes, sourceEntryKeys, build);
        this.validateBinIncludes(binIncludes, outputEntries);
        this.validateExecutionEnvironment(javacSource, javacTarget, jreCompilationProfile, javacWarnings, javacErrors, this.getSourceLibraries(sourceEntries));
        this.validateJavaCompilerSettings(javaProjectWarnings);
    }

    private List<String> getSourceLibraries(List<IBuildEntry> sourceEntries) {
        ArrayList<String> libraries = new ArrayList<String>();
        for (IBuildEntry entry : sourceEntries) {
            String libName = entry.getName().substring("source.".length());
            libraries.add(libName);
        }
        return libraries;
    }

    private void validateExecutionEnvironment(IBuildEntry javacSourceEntry, IBuildEntry javacTargetEntry, IBuildEntry jreCompilationProfileEntry, ArrayList<IBuildEntry> javacWarningsEntries, ArrayList<IBuildEntry> javacErrorsEntries, List<String> libraryNames) {
        IJavaProject project = JavaCore.create((IProject)this.fProject);
        if (project.exists()) {
            IClasspathEntry[] classpath = null;
            try {
                classpath = project.getRawClasspath();
            }
            catch (JavaModelException e) {
                PDECore.log(e);
                return;
            }
            boolean source = false;
            IClasspathEntry[] iClasspathEntryArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    source = true;
                }
                ++n2;
            }
            if (!source) {
                return;
            }
            String projectComplianceLevel = project.getOption("org.eclipse.jdt.core.compiler.compliance", false);
            if (projectComplianceLevel != null) {
                boolean warnForJavacWarnings;
                String projectClassCompatibility;
                BundleDescription bundleDesc;
                IPluginModelBase model = PluginRegistry.findModel(this.fProject);
                String[] execEnvs = null;
                if (model != null && (bundleDesc = model.getBundleDescription()) != null) {
                    execEnvs = bundleDesc.getExecutionEnvironments();
                }
                if (execEnvs == null || execEnvs.length == 0) {
                    return;
                }
                String execEnv = execEnvs[0];
                String projectSourceCompatibility = project.getOption("org.eclipse.jdt.core.compiler.source", true);
                if (projectComplianceLevel.equals(this.findMatchingEE(projectSourceCompatibility, projectClassCompatibility = project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true), false)) && execEnv.equals(this.findMatchingEE(projectSourceCompatibility, projectClassCompatibility, true))) {
                    return;
                }
                HashMap defaultComplianceOptions = new HashMap();
                JavaCore.setComplianceOptions((String)projectComplianceLevel, defaultComplianceOptions);
                String projectJavaCompatibility = this.findMatchingEE(projectSourceCompatibility, projectClassCompatibility, true);
                String message = null;
                if (projectJavaCompatibility != null) {
                    if (jreCompilationProfileEntry == null) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceMissingEntry, (Object)"jre.compilation.profile", (Object)PDECoreMessages.BuildErrorReporter_CompilercomplianceLevel);
                        this.prepareError("jre.compilation.profile", projectJavaCompatibility, message, 8199, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                    } else if (!projectJavaCompatibility.equalsIgnoreCase(jreCompilationProfileEntry.getTokens()[0])) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceDifferentToken, (Object)"jre.compilation.profile", (Object)PDECoreMessages.BuildErrorReporter_CompilercomplianceLevel);
                        this.prepareError("jre.compilation.profile", projectJavaCompatibility, message, 8198, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                    }
                } else {
                    if (projectSourceCompatibility.equals(defaultComplianceOptions.get("org.eclipse.jdt.core.compiler.source"))) {
                        if (javacSourceEntry != null) {
                            message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_BuildEntryNotRequiredMatchesDefault, (Object)"javacSource", (Object)PDECoreMessages.BuildErrorReporter_SourceCompatibility);
                            this.prepareError("javacSource", null, message, 8197, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                        }
                    } else if (javacSourceEntry == null) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceMissingEntry, (Object)"javacSource", (Object)PDECoreMessages.BuildErrorReporter_SourceCompatibility);
                        this.prepareError("javacSource", projectSourceCompatibility, message, 8199, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                    } else if (!projectSourceCompatibility.equalsIgnoreCase(javacSourceEntry.getTokens()[0])) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceDifferentToken, (Object)"javacSource", (Object)PDECoreMessages.BuildErrorReporter_SourceCompatibility);
                        this.prepareError("javacSource", projectSourceCompatibility, message, 8198, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                    }
                    if (projectClassCompatibility.equals(defaultComplianceOptions.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"))) {
                        if (javacTargetEntry != null) {
                            message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_BuildEntryNotRequiredMatchesDefault, (Object)"javacTarget", (Object)PDECoreMessages.BuildErrorReporter_GeneratedClassFilesCompatibility);
                            this.prepareError("javacTarget", null, message, 8197, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                        }
                    } else if (javacTargetEntry == null) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceMissingEntry, (Object)"javacTarget", (Object)PDECoreMessages.BuildErrorReporter_GeneratedClassFilesCompatibility);
                        this.prepareError("javacTarget", projectClassCompatibility, message, 8199, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                    } else if (!projectClassCompatibility.equalsIgnoreCase(javacTargetEntry.getTokens()[0])) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceDifferentToken, (Object)"javacTarget", (Object)PDECoreMessages.BuildErrorReporter_GeneratedClassFilesCompatibility);
                        this.prepareError("javacTarget", projectClassCompatibility, message, 8198, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                    }
                }
                boolean bl = warnForJavacWarnings = message != null || javacSourceEntry != null || javacTargetEntry != null || jreCompilationProfileEntry != null;
                if (!warnForJavacWarnings) {
                    return;
                }
                this.checkJavaComplianceSettings(projectComplianceLevel, javacWarningsEntries, javacErrorsEntries, libraryNames);
            }
        }
    }

    private void checkJavaComplianceSettings(String complianceLevel, ArrayList<IBuildEntry> javacWarningsEntries, ArrayList<IBuildEntry> javacErrorsEntries, List<String> libraryNames) {
        ArrayList<String> complianceWarnSettings = new ArrayList<String>(3);
        ArrayList<String> complianceErrorSettings = new ArrayList<String>(3);
        IJavaProject project = JavaCore.create((IProject)this.fProject);
        if (project.exists()) {
            Object message;
            String missingTokens;
            IBuildEntry matchingEntry;
            HashMap defaultComplianceOptions = new HashMap();
            JavaCore.setComplianceOptions((String)complianceLevel, defaultComplianceOptions);
            String assertIdentifier = project.getOption("org.eclipse.jdt.core.compiler.problem.assertIdentifier", false);
            String defaultAssert = (String)defaultComplianceOptions.get("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
            if (assertIdentifier != null && !assertIdentifier.equalsIgnoreCase(defaultAssert)) {
                if ("error".equalsIgnoreCase(assertIdentifier)) {
                    complianceErrorSettings.add(ASSERT_IDENTIFIER);
                } else if ("warning".equalsIgnoreCase(assertIdentifier)) {
                    complianceWarnSettings.add(ASSERT_IDENTIFIER);
                }
            }
            String enumIdentifier = project.getOption("org.eclipse.jdt.core.compiler.problem.enumIdentifier", false);
            String defaultEnum = (String)defaultComplianceOptions.get("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
            if (enumIdentifier != null && !enumIdentifier.equalsIgnoreCase(defaultEnum)) {
                if ("error".equalsIgnoreCase(enumIdentifier)) {
                    complianceErrorSettings.add(ENUM_IDENTIFIER);
                } else if ("warning".equalsIgnoreCase(enumIdentifier)) {
                    complianceWarnSettings.add(ENUM_IDENTIFIER);
                }
            }
            if (!complianceWarnSettings.isEmpty()) {
                for (String libName : libraryNames) {
                    matchingEntry = null;
                    for (IBuildEntry candidate : javacWarningsEntries) {
                        if (!candidate.getName().equals("javacWarnings." + libName)) continue;
                        matchingEntry = candidate;
                        break;
                    }
                    if (matchingEntry == null) {
                        missingTokens = "";
                        for (String currentIdentifier : complianceWarnSettings) {
                            missingTokens = this.join(missingTokens, String.valueOf('-') + currentIdentifier);
                        }
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceMissingEntry, (Object)("javacWarnings." + libName));
                        this.prepareError("javacWarnings." + libName, missingTokens, (String)message, 8199, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                        continue;
                    }
                    missingTokens = "";
                    for (String currentIdentifier : complianceWarnSettings) {
                        if (matchingEntry.contains(currentIdentifier) || matchingEntry.contains(String.valueOf('+') + currentIdentifier) || matchingEntry.contains(String.valueOf('-') + currentIdentifier)) continue;
                        this.join(missingTokens, String.valueOf('-') + currentIdentifier);
                    }
                    if (missingTokens.length() <= 0) continue;
                    message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceDifferentToken, (Object)("javacWarnings." + libName));
                    this.prepareError("javacWarnings." + libName, missingTokens, (String)message, 8199, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                }
            }
            if (!complianceErrorSettings.isEmpty()) {
                for (String libName : libraryNames) {
                    matchingEntry = null;
                    for (IBuildEntry candidate : javacErrorsEntries) {
                        if (!candidate.getName().equals("javacErrors." + libName)) continue;
                        matchingEntry = candidate;
                        break;
                    }
                    if (matchingEntry == null) {
                        missingTokens = "";
                        for (String currentIdentifier : complianceErrorSettings) {
                            missingTokens = this.join(missingTokens, String.valueOf('-') + currentIdentifier);
                        }
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceMissingEntry, (Object)("javacErrors." + libName));
                        this.prepareError("javacErrors." + libName, missingTokens, (String)message, 8199, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                        continue;
                    }
                    missingTokens = "";
                    for (String currentIdentifier : complianceErrorSettings) {
                        if (matchingEntry.contains(currentIdentifier) || matchingEntry.contains(String.valueOf('+') + currentIdentifier) || matchingEntry.contains(String.valueOf('-') + currentIdentifier)) continue;
                        missingTokens = this.join(missingTokens, String.valueOf('-') + currentIdentifier);
                    }
                    if (missingTokens.length() <= 0) continue;
                    message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_ProjectSpecificJavaComplianceDifferentToken, (Object)("javacErrors." + libName));
                    this.prepareError("javacErrors." + libName, missingTokens, (String)message, 8199, this.fJavaComplianceSeverity, "compilers.p.build.java.compliance", "ee");
                }
            }
        }
    }

    private String findMatchingEE(String srcCompatibility, String clsCompatibility, boolean ee) {
        String executionEnv = null;
        String compliance = null;
        if ("1.1".equals(srcCompatibility) && "1.1".equals(clsCompatibility)) {
            executionEnv = JRE_1_1;
            compliance = "1.1";
        } else if ("1.2".equals(srcCompatibility) && "1.1".equals(clsCompatibility)) {
            executionEnv = J2SE_1_2;
            compliance = "1.2";
        } else if ("1.3".equals(srcCompatibility) && "1.1".equals(clsCompatibility)) {
            executionEnv = J2SE_1_3;
            compliance = "1.3";
        } else if ("1.3".equals(srcCompatibility) && "1.2".equals(clsCompatibility)) {
            executionEnv = J2SE_1_4;
            compliance = "1.4";
        } else if ("1.5".equals(srcCompatibility) && "1.5".equals(clsCompatibility)) {
            executionEnv = J2SE_1_5;
            compliance = "1.5";
        } else if ("1.6".equals(srcCompatibility) && "1.6".equals(clsCompatibility)) {
            executionEnv = JavaSE_1_6;
            compliance = "1.6";
        } else if ("1.7".equals(srcCompatibility) && "1.7".equals(clsCompatibility)) {
            executionEnv = JavaSE_1_7;
            compliance = "1.7";
        } else if ("1.8".equals(srcCompatibility) && "1.8".equals(clsCompatibility)) {
            executionEnv = JavaSE_1_8;
            compliance = "1.8";
        }
        if (executionEnv == null) {
            String latestSupportedJavaVersion = JavaCore.latestSupportedJavaVersion();
            int latest = Integer.parseInt(latestSupportedJavaVersion);
            int i = 9;
            while (i <= latest) {
                if (String.valueOf(i).equals(srcCompatibility) && String.valueOf(i).equals(clsCompatibility)) {
                    executionEnv = "JavaSE-" + String.valueOf(i);
                    compliance = String.valueOf(i);
                    break;
                }
                ++i;
            }
        }
        if (ee) {
            return executionEnv;
        }
        return compliance;
    }

    private void validateBinIncludes(IBuildEntry binIncludes, List<IBuildEntry> outputEntries) {
        IPluginModelBase model;
        IFolder OSGinf;
        if (PDEProject.getManifest(this.fProject).exists()) {
            this.validateBinIncludes(binIncludes, "META-INF/");
        }
        if ((OSGinf = PDEProject.getOSGiInf(this.fProject)).exists()) {
            try {
                if (OSGinf.members().length > 0) {
                    this.validateBinIncludes(binIncludes, "OSGI-INF/");
                }
            }
            catch (CoreException coreException) {}
        }
        if (PDEProject.getFragmentXml(this.fProject).exists()) {
            this.validateBinIncludes(binIncludes, "fragment.xml");
        }
        if (PDEProject.getPluginXml(this.fProject).exists()) {
            this.validateBinIncludes(binIncludes, "plugin.xml");
            this.validateFragmentContributions(binIncludes);
            this.validateApplicationContributions(binIncludes);
        }
        String defaultLibraryName = "output..";
        if (outputEntries.stream().anyMatch(e -> e.getName().equals(defaultLibraryName))) {
            this.validateBinIncludes(binIncludes, ".");
        }
        if ((model = PluginRegistry.findModel(this.fProject)) == null) {
            return;
        }
        if (model instanceof IBundlePluginModelBase && !(model instanceof IBundleFragmentModel)) {
            IBundleModel bm = ((IBundlePluginModelBase)model).getBundleModel();
            IManifestHeader mh = bm.getBundle().getManifestHeader("Bundle-Localization");
            Path resourcePath = null;
            String entry = null;
            if (mh == null || mh.getValue() == null) {
                resourcePath = new Path("OSGI-INF/l10n/bundle");
                entry = "OSGI-INF/l10n/bundle";
            } else {
                String localization = mh.getValue();
                int index = localization.lastIndexOf(47);
                if (index != -1) {
                    entry = localization.substring(0, index + 1);
                    resourcePath = new Path(entry);
                } else {
                    entry = mh.getValue().concat(".properties");
                    resourcePath = new Path(entry);
                }
            }
            if (entry != null && PDEProject.getBundleRoot(this.fProject).exists((IPath)resourcePath)) {
                this.validateBinIncludes(binIncludes, entry);
            }
        }
    }

    private void validateFragmentContributions(IBuildEntry binIncludes) {
        try {
            DocumentBuilder newDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            newDocumentBuilder.setErrorHandler(new PDEErrorHandler());
            Document doc = newDocumentBuilder.parse(PDEProject.getPluginXml(this.fProject).getContents());
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList list = (NodeList)xpath.evaluate("/plugin/extension[@point='org.eclipse.e4.workbench.model']/fragment/@uri", doc, XPathConstants.NODESET);
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                this.validateBinIncludes(binIncludes, node.getNodeValue());
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private void validateApplicationContributions(IBuildEntry binIncludes) {
        try {
            DocumentBuilder newDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            newDocumentBuilder.setErrorHandler(new PDEErrorHandler());
            Document doc = newDocumentBuilder.parse(PDEProject.getPluginXml(this.fProject).getContents());
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node nodeProduct = (Node)xpath.evaluate("/plugin/extension[@point='org.eclipse.core.runtime.products']/product", doc, XPathConstants.NODE);
            if (nodeProduct != null) {
                Node attValue = (Node)xpath.evaluate("property[@name='applicationXMI']/@value", nodeProduct, XPathConstants.NODE);
                if (attValue != null) {
                    String nodeValue = attValue.getNodeValue();
                    if (!nodeValue.isEmpty()) {
                        String platform = "platform:/plugin/";
                        if (nodeValue.startsWith(platform)) {
                            String prefix;
                            IPluginModelBase model = PluginRegistry.findModel(this.fProject);
                            if (model != null && nodeValue.startsWith(prefix = String.valueOf(platform) + model.getPluginBase().getId() + '/')) {
                                this.validateBinIncludes(binIncludes, nodeValue.substring(prefix.length()));
                            }
                        } else {
                            this.validateBinIncludes(binIncludes, nodeValue);
                        }
                    }
                } else if (this.fProject.exists((IPath)new Path("Application.e4xmi"))) {
                    this.validateBinIncludes(binIncludes, "Application.e4xmi");
                }
            }
        }
        catch (Exception exception) {}
    }

    private void validateBinIncludes(IBuildEntry binIncludes, String key) {
        if (binIncludes == null) {
            return;
        }
        String[] tokens = binIncludes.getTokens();
        boolean exists = false;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (key.startsWith(token)) {
                exists = true;
                break;
            }
            IPath project = this.fFile.getProject().getLocation();
            if (project != null && token != null) {
                File[] files;
                File projectFile = project.toFile();
                File[] fileArray = files = projectFile.listFiles(new WildcardFilenameFilter(token));
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    if (file.toString().endsWith(key)) {
                        exists = true;
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (!exists) {
            this.prepareError("bin.includes", key, NLS.bind((String)PDECoreMessages.BuildErrorReporter_binIncludesMissing, (Object)key), 8195, this.fBinInclSeverity, "compilers.p.build.bin.includes", "fatal");
        }
    }

    private void validateJarsExtraClasspath(IBuildEntry javaExtra) {
        String platform = "platform:/plugin/";
        String[] tokens = javaExtra.getTokens();
        IPath projectPath = javaExtra.getModel().getUnderlyingResource().getProject().getLocation();
        int i = 0;
        while (i < tokens.length) {
            boolean exists = true;
            if (tokens[i].startsWith(platform)) {
                String path = tokens[i].substring(platform.length());
                int sep = path.indexOf(47);
                if (sep > -1) {
                    IPluginModelBase model = PluginRegistry.findModel(path.substring(0, sep));
                    if (model == null) {
                        exists = false;
                    } else {
                        IResource resource = model.getUnderlyingResource();
                        path = path.substring(sep + 1);
                        if (resource == null) {
                            IPath result = PDECore.getDefault().getModelManager().getExternalModelManager().getNestedLibrary(model, path);
                            if (result == null) {
                                exists = false;
                            }
                        } else {
                            exists = resource.getProject().findMember(path) != null;
                        }
                    }
                }
            } else {
                exists = projectPath.append(tokens[i]).toFile().exists();
            }
            if (!exists && !this.startsWithAntVariable(tokens[i])) {
                this.prepareError("jars.extra.classpath", tokens[i], NLS.bind((String)PDECoreMessages.BuildErrorReporter_cannotFindJar, (Object)tokens[i]), 4135, this.fBuildSeverity, "compilers.p.build", "");
            }
            ++i;
        }
    }

    private void validateMissingSourceInBinIncludes(IBuildEntry binIncludes, ArrayList<String> sourceEntryKeys, IBuild build) {
        if (binIncludes == null) {
            return;
        }
        ArrayList<String> pluginLibraryNames = new ArrayList<String>(1);
        IPluginModelBase pluginModel = PluginRegistry.findModel(this.fProject);
        if (pluginModel != null) {
            IPluginLibrary[] pluginLibraries;
            IPluginLibrary[] iPluginLibraryArray = pluginLibraries = pluginModel.getPluginBase().getLibraries();
            int n = pluginLibraries.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginLibrary library = iPluginLibraryArray[n2];
                pluginLibraryNames.add(library.getName());
                ++n2;
            }
        }
        if (!pluginLibraryNames.contains(".")) {
            pluginLibraryNames.add(".");
        }
        int i = 0;
        while (i < sourceEntryKeys.size()) {
            IBuildEntry entry;
            String[] tokens;
            String key = sourceEntryKeys.get(i);
            if (!pluginLibraryNames.contains(key)) {
                return;
            }
            if (!DEF_SOURCE_ENTRY.equals(key) || (tokens = (entry = build.getEntry(DEF_SOURCE_ENTRY)).getTokens()).length != 1 || !tokens[0].equals(".")) {
                Path path;
                String[] binIncludesTokens;
                key = key.substring("source.".length());
                boolean found = false;
                String[] stringArray = binIncludesTokens = binIncludes.getTokens();
                int n = binIncludesTokens.length;
                int n3 = 0;
                while (n3 < n) {
                    String token = stringArray[n3];
                    Pattern pattern = PatternConstructor.createPattern(token, false);
                    if (pattern.matcher(key).matches()) {
                        found = true;
                    }
                    ++n3;
                }
                if (!found && (path = new Path(key)).getFileExtension() == null && !key.endsWith("/")) {
                    key = String.valueOf(key) + "/";
                    String[] stringArray2 = binIncludesTokens;
                    int n4 = binIncludesTokens.length;
                    n = 0;
                    while (n < n4) {
                        String token = stringArray2[n];
                        Pattern pattern = PatternConstructor.createPattern(token, false);
                        if (pattern.matcher(key).matches()) {
                            found = true;
                        }
                        ++n;
                    }
                }
                if (!found) {
                    this.prepareError("bin.includes", key, NLS.bind((String)PDECoreMessages.BuildErrorReporter_binIncludesMissing, (Object)key), 8195, this.fBinInclSeverity, "compilers.p.build.bin.includes", "fatal");
                }
            }
            ++i;
        }
    }

    private void validateMissingLibraries(ArrayList<String> sourceEntryKeys, IClasspathEntry[] cpes) {
        IPluginLibrary[] libraries;
        IBundleModel bm;
        IManifestHeader mh;
        boolean srcFolderExists = false;
        IClasspathEntry[] iClasspathEntryArray = cpes;
        int n = cpes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                srcFolderExists = true;
                break;
            }
            ++n2;
        }
        if (!srcFolderExists) {
            return;
        }
        IPluginModelBase model = PluginRegistry.findModel(this.fProject);
        if (model == null) {
            return;
        }
        if (!(!(model instanceof IBundlePluginModelBase) || model instanceof IBundleFragmentModel || (mh = (bm = ((IBundlePluginModelBase)model).getBundleModel()).getBundle().getManifestHeader("Bundle-ClassPath")) != null && mh.getValue() != null || sourceEntryKeys.contains(DEF_SOURCE_ENTRY))) {
            this.prepareError(DEF_SOURCE_ENTRY, null, PDECoreMessages.BuildErrorReporter_sourceMissing, 4135, this.fSrcLibSeverity, "compilers.p.build.source.library", "");
        }
        IPluginLibrary[] iPluginLibraryArray = libraries = model.getPluginBase().getLibraries();
        int n3 = libraries.length;
        int n4 = 0;
        while (n4 < n3) {
            block12: {
                String sourceEntryKey;
                String libname;
                block11: {
                    block10: {
                        IPluginLibrary library = iPluginLibraryArray[n4];
                        libname = library.getName();
                        if (!libname.equals(".")) break block10;
                        if (sourceEntryKeys.contains(DEF_SOURCE_ENTRY)) break block11;
                        this.prepareError(DEF_SOURCE_ENTRY, null, PDECoreMessages.BuildErrorReporter_sourceMissing, 4135, this.fSrcLibSeverity, "compilers.p.build.source.library", "");
                        break block12;
                    }
                    if (this.fProject.findMember(libname) != null) break block12;
                }
                if (!sourceEntryKeys.contains(sourceEntryKey = "source." + libname) && !this.containedInFragment(model.getBundleDescription(), libname)) {
                    this.prepareError(sourceEntryKey, null, NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingEntry, (Object)sourceEntryKey), 8195, "");
                }
            }
            ++n4;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containedInFragment(BundleDescription description, String libname) {
        if (description == null) {
            return false;
        }
        fragments = description.getFragments();
        if (fragments == null) {
            return false;
        }
        var7_4 = fragments;
        var6_5 = fragments.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            fragment = var7_4[var5_6];
            fragmentModel = PluginRegistry.findModel(fragment);
            if (fragmentModel != null && fragmentModel.getUnderlyingResource() != null) {
                project = fragmentModel.getUnderlyingResource().getProject();
                if (project.findMember(libname) != null) {
                    return true;
                }
                try {
                    build = ClasspathUtilCore.getBuild(fragmentModel);
                    if (build == null) ** GOTO lbl39
                    var15_13 = entries = build.getBuildEntries();
                    var14_14 = entries.length;
                    var13_15 = 0;
                    while (true) {
                        if (var13_15 >= var14_14) {
                            return false;
                        }
                        entrie = var15_13[var13_15];
                        if (entrie.getName().equals("source." + libname)) {
                            return true;
                        }
                        ++var13_15;
                    }
                }
                catch (CoreException v0) {}
            } else {
                location = fragment.getLocation();
                external = new File(location);
                if (external.exists()) {
                    if (external.isDirectory()) {
                        p = new Path(location).addTrailingSeparator().append(libname);
                        return new File(p.toOSString()).exists();
                    }
                    return CoreUtility.jarContainsResource(external, libname, false);
                }
            }
lbl39:
            // 4 sources

            ++var5_6;
        }
        return false;
    }

    private void validateSourceEntries(ArrayList<IBuildEntry> sourceEntries, IBuildEntry srcExcludes, IClasspathEntry[] cpes) {
        if (sourceEntries == null || sourceEntries.isEmpty()) {
            return;
        }
        String[] unlisted = PDEBuilderHelper.getUnlistedClasspaths(sourceEntries, this.fProject, cpes);
        List<Object> excludeList = new ArrayList(0);
        if (srcExcludes != null && srcExcludes.getTokens().length > 0) {
            excludeList = Arrays.asList(srcExcludes.getTokens());
        }
        String name = sourceEntries.get(0).getName();
        String message = PDECoreMessages.BuildErrorReporter_classpathEntryMissing1;
        if (sourceEntries.size() > 1) {
            name = DEF_SOURCE_ENTRY;
            message = PDECoreMessages.BuildErrorReporter_classpathEntryMissing;
        }
        String[] stringArray = unlisted;
        int n = unlisted.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element != null && !excludeList.contains(element)) {
                BuildProblem error = this.prepareError(name, element, NLS.bind((String)message, (Object)element, (Object)name), 8195, this.fSrcLibSeverity, "compilers.p.build.source.library", "");
                error.addExtraBuildEntryTokenAttribute("src.excludes", element);
            }
            ++n2;
        }
    }

    private void validateSourceFoldersInSrcIncludes(IBuildEntry includes) {
        String[] tokens;
        int n;
        if (includes == null) {
            return;
        }
        ArrayList<IPath> sourceFolderList = new ArrayList<IPath>(0);
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
            if (javaProject.exists()) {
                IClasspathEntry[] classPathEntries;
                IClasspathEntry[] iClasspathEntryArray = classPathEntries = javaProject.getResolvedClasspath(true);
                int n2 = classPathEntries.length;
                n = 0;
                while (n < n2) {
                    IClasspathEntry entry = iClasspathEntryArray[n];
                    if (entry.getEntryKind() == 3) {
                        sourceFolderList.add(entry.getPath());
                    }
                    ++n;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        String[] stringArray = tokens = includes.getTokens();
        n = tokens.length;
        int n3 = 0;
        while (n3 < n) {
            String token = stringArray[n3];
            IResource res = this.fProject.findMember(token);
            if (res != null) {
                String errorMessage = null;
                if (sourceFolderList.contains(res.getFullPath())) {
                    errorMessage = PDECoreMessages.BuildErrorReporter_srcIncludesSourceFolder;
                } else if ((token.startsWith(".") || RESERVED_NAMES.contains(res.getName().toLowerCase())) && !res.getName().equalsIgnoreCase(".settings")) {
                    errorMessage = NLS.bind((String)PDECoreMessages.BuildErrorReporter_srcIncludesSourceFolder1, (Object)res.getName());
                }
                if (errorMessage != null) {
                    this.prepareError(includes.getName(), token, errorMessage, 8197, this.fSrcInclSeverity, "compilers.p.build.src.includes", "");
                }
            }
            ++n3;
        }
    }

    private void validateIncludes(IBuildEntry includes, ArrayList<String> sourceIncludes, int severity, String compilerKey) {
        String[] tokens;
        if (includes == null) {
            return;
        }
        String[] stringArray = tokens = includes.getTokens();
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                int fixId;
                String message;
                String token;
                block8: {
                    IResource member;
                    block7: {
                        String tokenBasic = stringArray[n2];
                        token = tokenBasic.trim();
                        if (token.contains("*") || token.equals(".") || this.startsWithAntVariable(token)) break block6;
                        member = PDEProject.getBundleRoot(this.fProject).findMember(token);
                        message = null;
                        fixId = 4135;
                        if (member != null) break block7;
                        if (sourceIncludes.contains("source." + token)) break block6;
                        message = token.endsWith("/") ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)token) : NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFile, (Object)token);
                        fixId = 8197;
                        break block8;
                    }
                    if (token.endsWith("/") && !(member instanceof IFolder)) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_entiresMustRefDirs, (Object)token);
                        fixId = 8194;
                    } else if (!token.endsWith("/") && !(member instanceof IFile)) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_dirsMustEndSlash, (Object)token);
                        fixId = 8193;
                    }
                }
                if (message != null) {
                    this.prepareError(includes.getName(), token, message, fixId, severity, compilerKey, "");
                }
            }
            ++n2;
        }
    }

    private boolean startsWithAntVariable(String token) {
        int varStart = token.indexOf("${");
        return varStart != -1 && varStart < token.indexOf(125);
    }

    private void validateDependencyManagement(IBuildEntry bundleList) {
        String[] bundles;
        String[] stringArray = bundles = bundleList.getTokens();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            if (PluginRegistry.findModel(bundle) == null) {
                this.prepareError("additional.bundles", bundle, NLS.bind((String)PDECoreMessages.BuildErrorReporter_cannotFindBundle, (Object)bundle), 4135, this.fClasspathSeverity, "compilers.p.unresolved-import", "");
            }
            ++n2;
        }
    }

    private void validateJavaCompilerSettings(IBuildEntry useJavaProjectSettings) {
        IJavaProject project = JavaCore.create((IProject)this.fProject);
        if (project.exists()) {
            Map options = project.getOptions(false);
            if (options.containsKey("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess")) {
                if (useJavaProjectSettings != null) {
                    boolean entryCorrect = false;
                    String[] tokens = useJavaProjectSettings.getTokens();
                    if (tokens != null && tokens.length == 1) {
                        if (Boolean.TRUE.toString().equalsIgnoreCase(tokens[0])) {
                            entryCorrect = this.fProject.equals((Object)PDEProject.getBundleRoot(this.fProject));
                        } else {
                            Path prefFile = new Path(tokens[0]);
                            if (prefFile.isAbsolute()) {
                                entryCorrect = prefFile.toFile().exists();
                            } else {
                                IContainer root = PDEProject.getBundleRoot(this.fProject);
                                entryCorrect = root.getFile((IPath)prefFile).exists();
                            }
                        }
                    }
                    if (!entryCorrect) {
                        String token = null;
                        String message = null;
                        IContainer root = PDEProject.getBundleRoot(this.fProject);
                        if (this.fProject.equals((Object)root)) {
                            token = Boolean.TRUE.toString();
                            message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_buildEntryMissingValidPath, (Object)"javacProjectSettings");
                        } else {
                            IPath prefFile = this.fProject.getFullPath().append(".settings").append("org.eclipse.jdt.core.prefs");
                            prefFile = prefFile.makeRelativeTo(root.getFullPath());
                            token = prefFile.toString();
                            message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_buildEntryMissingValidRelativePath, (Object)"javacProjectSettings");
                        }
                        this.prepareError("javacProjectSettings", token, message, 8198, this.fJavaCompilerSeverity, "compilers.p.build.java.compiler", "ee");
                    }
                } else {
                    String token = null;
                    IContainer root = PDEProject.getBundleRoot(this.fProject);
                    if (this.fProject.equals((Object)root)) {
                        token = Boolean.TRUE.toString();
                    } else {
                        IPath prefFile = this.fProject.getFullPath().append(".settings").append("org.eclipse.jdt.core.prefs");
                        prefFile = prefFile.makeRelativeTo(root.getFullPath());
                        token = prefFile.toString();
                    }
                    String message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_buildEntryMissingProjectSpecificSettings, (Object)"javacProjectSettings");
                    this.prepareError("javacProjectSettings", token, message, 8199, this.fJavaCompilerSeverity, "compilers.p.build.java.compiler", "ee");
                }
            } else if (useJavaProjectSettings != null) {
                String message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_buildEntryInvalidWhenNoProjectSettings, (Object)"javacProjectSettings");
                this.prepareError("javacProjectSettings", null, message, 8197, this.fJavaCompilerSeverity, "compilers.p.build.java.compiler", "ee");
            }
        }
    }

    private String join(String token1, String token2) {
        StringBuilder result = new StringBuilder();
        if (token1 != null && token1.length() > 0) {
            result.append(token1);
        }
        if (token2 != null && token2.length() > 0) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(token2);
        }
        return result.toString();
    }

    private BuildModel prepareTextBuildModel(IProgressMonitor monitor) {
        BuildModel bm;
        block5: {
            IDocument doc;
            block4: {
                try {
                    doc = this.createDocument(this.fFile);
                    if (doc != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    PDECore.log(e);
                    return null;
                }
            }
            bm = new BuildModel(doc, true);
            bm.load();
            if (bm.isLoaded()) break block5;
            return null;
        }
        return bm;
    }

    private void reportErrors(BuildModel bm) {
        if (bm == null) {
            return;
        }
        int i = 0;
        while (i < this.fProblemList.size()) {
            BuildProblem bp = this.fProblemList.get(i);
            IBuildEntry buildEntry = bm.getBuild().getEntry(bp.fEntryName);
            int lineNum = buildEntry == null || bp.fEntryName == null ? 1 : this.getLineNumber(buildEntry, bp.fEntryToken);
            if (lineNum > 0) {
                IncrementalErrorReporter.VirtualMarker marker = this.report(bp.fMessage, lineNum, bp.fFixId, bp.fEntryName, bp.fEntryToken, bp.fSeverity, bp.fCategory);
                this.addMarkerAttribute(marker, "compilerKey", bp.fCompilerKey);
                if (marker != null && bp.attributes != null) {
                    for (Map.Entry<String, String> entry : bp.attributes.entrySet()) {
                        String attribute = entry.getKey();
                        marker.setAttribute(attribute, entry.getValue());
                    }
                }
            }
            ++i;
        }
    }

    private int getLineNumber(IBuildEntry ibe, String tokenString) {
        if (!(ibe instanceof BuildEntry)) {
            return 0;
        }
        BuildEntry be = (BuildEntry)ibe;
        IDocument doc = ((BuildModel)be.getModel()).getDocument();
        try {
            int buildEntryLineNumber = doc.getLineOfOffset(be.getOffset()) + 1;
            if (tokenString == null) {
                return buildEntryLineNumber;
            }
            String entry = doc.get(be.getOffset(), be.getLength());
            int valueIndex = entry.indexOf(61) + 1;
            if (valueIndex == 0 || valueIndex == entry.length()) {
                return buildEntryLineNumber;
            }
            int entryTokenOffset = (entry = entry.substring(valueIndex)).indexOf(tokenString);
            if (entryTokenOffset == -1) {
                return buildEntryLineNumber;
            }
            entry = entry.substring(entryTokenOffset);
            int currOffset = be.getOffset() + valueIndex + entryTokenOffset;
            while (true) {
                int cci;
                if (entry.charAt(0) == '\\') {
                    ++currOffset;
                    entry = entry.substring(1);
                }
                if ((cci = entry.indexOf(44)) == -1) {
                    if (entry.trim().equals(tokenString)) {
                        return doc.getLineOfOffset(currOffset + entry.indexOf(tokenString)) + 1;
                    }
                    return buildEntryLineNumber;
                }
                String ct = entry.substring(0, cci).trim();
                if (ct.equals(tokenString)) {
                    return doc.getLineOfOffset(currOffset + entry.indexOf(tokenString)) + 1;
                }
                entry = entry.substring(++cci);
                currOffset += cci;
            }
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    protected BuildProblem prepareError(String name, String token, String message, int fixId, String category) {
        return this.prepareError(name, token, message, fixId, this.fBuildSeverity, "compilers.p.build", category);
    }

    protected BuildProblem prepareError(String name, String token, String message, int fixId, int severity, String compilerKey, String category) {
        BuildProblem bp = new BuildProblem(name, token, message, fixId, severity, compilerKey, category);
        int i = 0;
        while (i < this.fProblemList.size()) {
            BuildProblem listed = this.fProblemList.get(i);
            if (listed.equals(bp)) {
                if (bp.attributes != null) {
                    listed.addAttributes(bp.attributes);
                }
                return listed;
            }
            ++i;
        }
        this.fProblemList.add(bp);
        return bp;
    }

    private IncrementalErrorReporter.VirtualMarker report(String message, int line, int problemID, String buildEntry, String buildToken, int severity, String category) {
        IncrementalErrorReporter.VirtualMarker marker = this.report(message, line, severity, problemID, category);
        if (marker != null) {
            marker.setAttribute("buildEntry.key", buildEntry);
            marker.setAttribute("buildEntry.tokenValue", buildToken);
        }
        return marker;
    }

    public boolean isCustomBuild() {
        String[] tokens;
        WorkspaceBuildModel wbm = new WorkspaceBuildModel(this.fFile);
        IBuild build = wbm.getBuild();
        IBuildEntry entry = build.getEntry("custom");
        return entry != null && (tokens = entry.getTokens()).length == 1 && tokens[0].equalsIgnoreCase("true");
    }

    protected void addMarkerAttribute(IncrementalErrorReporter.VirtualMarker marker, String attr, String value) {
        if (marker != null) {
            marker.setAttribute(attr, value);
        }
    }

    static class BuildProblem {
        String fEntryToken;
        String fEntryName;
        String fMessage;
        String fCategory;
        int fFixId;
        int fSeverity;
        String fCompilerKey;
        HashMap<String, String> attributes;
        int fExtraBuntryEntryIndex;

        BuildProblem(String name, String token, String message, int fixId, int severity, String compilerKey, String category) {
            this.fEntryName = name;
            this.fEntryToken = token;
            this.fMessage = message;
            this.fFixId = fixId;
            this.fSeverity = severity;
            this.fCompilerKey = compilerKey;
            this.fCategory = category;
            this.fExtraBuntryEntryIndex = 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BuildProblem)) {
                return false;
            }
            BuildProblem bp = (BuildProblem)obj;
            if (!this.fEntryName.equals(bp.fEntryName)) {
                return false;
            }
            if (this.fEntryToken != null && !this.fEntryToken.equals(bp.fEntryToken)) {
                return false;
            }
            return this.fFixId == bp.fFixId;
        }

        public void addExtraBuildEntryTokenAttribute(String entry, String value) {
            this.addAttribute("buildEntry.key." + this.fExtraBuntryEntryIndex, entry);
            this.addAttribute("buildEntry.tokenValue." + this.fExtraBuntryEntryIndex, value);
            ++this.fExtraBuntryEntryIndex;
        }

        public void addAttribute(String attributeName, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap(1);
            }
            this.attributes.put(attributeName, value);
        }

        public void addAttributes(HashMap<String, String> attributes) {
            if (attributes == null) {
                attributes = new HashMap(1);
            }
            attributes.putAll(attributes);
        }
    }

    static class WildcardFilenameFilter
    implements FilenameFilter {
        private final Pattern pattern;

        public WildcardFilenameFilter(String file) {
            this.pattern = PatternConstructor.createPattern(file, false);
        }

        @Override
        public boolean accept(File dir, String name) {
            Matcher matcher = this.pattern.matcher(name);
            return matcher.matches();
        }
    }
}

