/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.architecture.migration;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescription;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler_1_3_0;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;

public class UMLDiagramReconciler_1_3_0
extends DiagramReconciler_1_3_0 {
    private static final String ACTIVITY_DIAGRAM = "PapyrusUMLActivityDiagram";
    private static final String CLASS_DIAGRAM = "PapyrusUMLClassDiagram";
    private static final String COMMUNICATION_DIAGRAM = "PapyrusUMLCommunicationDiagram";
    private static final String COMPONENT_DIAGRAM = "PapyrusUMLComponentDiagram";
    private static final String COMPOSITE_STRUCTURE_DIAGRAM = "CompositeStructure";
    private static final String DEPLOYMENT_DIAGRAM = "PapyrusUMLDeploymentDiagram";
    private static final String INTERACTION_OVERVIEW_DIAGRAM = "PapyrusUMLInteractionOverviewDiagram";
    private static final String PROFILE_DIAGRAM = "PapyrusUMLProfileDiagram";
    private static final String SEQUENCE_DIAGRAM = "PapyrusUMLSequenceDiagram";
    private static final String STATE_MACHINE_DIAGRAM = "PapyrusUMLStateMachineDiagram";
    private static final String TIMING_DIAGRAM = "PapyrusUMLTimingDiagram";
    private static final String USE_CASE_DIAGRAM = "UseCase";

    protected PapyrusDiagram getDiagramKind(Diagram diagram, PapyrusViewStyle oldStyle) {
        org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram oldDiagramKind;
        if (oldStyle != null && (oldDiagramKind = (org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram)oldStyle.getConfiguration()) != null) {
            return this.getDiagramKind(oldDiagramKind.getName(), diagram);
        }
        if (ACTIVITY_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Activity Diagram", diagram);
        }
        if (CLASS_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Class Diagram", diagram);
        }
        if (COMMUNICATION_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Communication Diagram", diagram);
        }
        if (COMPONENT_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Component Diagram", diagram);
        }
        if (COMPOSITE_STRUCTURE_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Composite Structure Diagram", diagram);
        }
        if (DEPLOYMENT_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Deployment Diagram", diagram);
        }
        if (INTERACTION_OVERVIEW_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Interaction Overview Diagram", diagram);
        }
        if (PROFILE_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Profile Diagram", diagram);
        }
        if (SEQUENCE_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Sequence Diagram", diagram);
        }
        if (STATE_MACHINE_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("State Machine Diagram", diagram);
        }
        if (TIMING_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Timing Diagram", diagram);
        }
        if (USE_CASE_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Use Case Diagram", diagram);
        }
        return null;
    }

    public ICommand getReconcileCommand(Diagram diagram) {
        ResourceSet resourceSet;
        Resource eResource;
        ICommand reconcileCommand = super.getReconcileCommand(diagram);
        if (reconcileCommand != null && diagram != null && PROFILE_DIAGRAM.equals(diagram.getType()) && (eResource = diagram.eResource()) != null && (resourceSet = eResource.getResourceSet()) instanceof ModelSet) {
            CompositeCommand compositeCommand = new CompositeCommand("Update viewpoints from configuration to architecture and set profile as default architecture");
            compositeCommand.add((IUndoableOperation)reconcileCommand);
            Command setContextCommand = this.getSetContextCommand((ModelSet)resourceSet, "org.eclipse.papyrus.uml.architecture.Profile");
            compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)setContextCommand));
            return compositeCommand;
        }
        return reconcileCommand;
    }

    protected Command getSetContextCommand(final ModelSet modelSet, final String contextId) {
        return new RecordingCommand(modelSet.getTransactionalEditingDomain()){

            protected void doExecute() {
                ArchitectureDescription description = DiModelUtils.getOrAddArchitectureDescription((ModelSet)modelSet);
                description.setContextId(contextId);
            }
        };
    }

    protected PapyrusDiagram getDiagramKind(String name, Diagram diagram) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        MergedArchitectureDescriptionLanguage context = (MergedArchitectureDescriptionLanguage)manager.getArchitectureContextById("org.eclipse.papyrus.infra.services.edit.TypeContext");
        for (RepresentationKind pKind : context.getRepresentationKinds()) {
            PapyrusDiagram dKind;
            if (!pKind.getName().equals(name) || !((ModelRule)(dKind = (PapyrusDiagram)pKind).getModelRules().get(0)).getElement().isInstance((Object)diagram.getElement())) continue;
            return dKind;
        }
        return null;
    }
}

