/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class DelegatingLabelProvider
extends LabelProvider {
    private final ILabelProvider delegate;
    private ILabelProviderListener forwardingListener;

    public DelegatingLabelProvider(ILabelProvider delegate) {
        this.delegate = delegate;
        delegate.addListener(this.getForwardingListener());
    }

    public Image getImage(Object element) {
        Image result = this.customGetImage(element);
        if (result == null) {
            result = this.delegatedGetImage(element);
        }
        return result;
    }

    protected Image customGetImage(Object element) {
        return null;
    }

    protected Image delegatedGetImage(Object element) {
        return this.delegate.getImage(element);
    }

    public String getText(Object element) {
        String result = this.customGetText(element);
        if (result == null) {
            result = this.delegatedGetText(element);
        }
        return result;
    }

    protected String customGetText(Object element) {
        return null;
    }

    protected String delegatedGetText(Object element) {
        return this.delegate.getText(element);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.delegate.isLabelProperty(element, property);
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegate.removeListener(listener);
    }

    public void dispose() {
        this.delegate.removeListener(this.getForwardingListener());
        this.delegate.dispose();
    }

    private ILabelProviderListener getForwardingListener() {
        if (this.forwardingListener == null) {
            this.forwardingListener = new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent event) {
                    DelegatingLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DelegatingLabelProvider.this, event.getElements()));
                }
            };
        }
        return this.forwardingListener;
    }
}

