/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.internal;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.guava.internal.CheckedFuture;
import org.eclipse.papyrus.infra.sync.Activator;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.EMFDispatchManager;
import org.eclipse.papyrus.infra.sync.EMFListener;
import org.eclipse.papyrus.infra.sync.SyncRegistry;
import org.eclipse.papyrus.infra.sync.internal.NullSyncPolicy;
import org.eclipse.papyrus.infra.sync.internal.SyncPolicyDelegateRegistryImpl;
import org.eclipse.papyrus.infra.sync.internal.SyncServiceOperation;
import org.eclipse.papyrus.infra.sync.internal.SyncTriggerRegistry;
import org.eclipse.papyrus.infra.sync.policy.DefaultSyncPolicy;
import org.eclipse.papyrus.infra.sync.policy.ISyncPolicy;
import org.eclipse.papyrus.infra.sync.policy.SyncPolicyDelegate;
import org.eclipse.papyrus.infra.sync.service.ISyncAction;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.sync.service.ISyncTrigger;
import org.eclipse.papyrus.infra.sync.service.SyncServiceRunnable;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class SyncService
implements ISyncService {
    private static final ThreadLocal<SyncService> currentService = new ThreadLocal();
    private ServicesRegistry services;
    private TransactionalEditingDomain editingDomain;
    private RootTrigger rootTrigger = new RootTrigger();
    private EMFListener emfListener;
    private SyncPolicyDelegateRegistryImpl policyDelegates;
    private ISyncPolicy policy;
    private Executor executor;
    private final Map<Class<? extends SyncRegistry<?, ?, ?>>, SyncRegistry<?, ?, ?>> syncRegistries = Maps.newHashMap();

    public static SyncService getCurrent() {
        return currentService.get();
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.services = servicesRegistry;
    }

    public void startService() throws ServiceException {
        this.editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.services);
        this.setAsyncExecutor(TransactionHelper.createTransactionExecutor((TransactionalEditingDomain)this.editingDomain, (Executor)MoreExecutors.directExecutor()));
        this.policy = (ISyncPolicy)new SyncServiceOperation<ISyncPolicy>(this){

            @Override
            protected ISyncPolicy doCall() throws Exception {
                SyncService.this.policyDelegates = new SyncPolicyDelegateRegistryImpl(SyncService.this.editingDomain);
                return new DefaultSyncPolicy(SyncService.this.policyDelegates);
            }
        }.safeCall(ServiceException.class);
        this.rootTrigger.install(this.editingDomain);
    }

    public void disposeService() throws ServiceException {
        this.syncRegistries.clear();
        this.policy = null;
        if (this.policyDelegates != null) {
            this.policyDelegates.dispose();
            this.policyDelegates = null;
        }
        if (this.emfListener != null) {
            this.emfListener.dispose();
            this.emfListener = null;
        }
        if (this.editingDomain != null) {
            this.rootTrigger.uninstall(this.editingDomain);
        }
        this.editingDomain = null;
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdownNow();
        }
        this.executor = null;
    }

    @Override
    public boolean isActive() {
        return this.editingDomain != null;
    }

    EMFListener getEMFListener() {
        if (this.emfListener == null) {
            this.emfListener = new EMFListener(this.editingDomain);
        }
        return this.emfListener;
    }

    @Override
    public <D extends EMFDispatch> EMFDispatchManager<D> createSingleDispatchManager() {
        return (EMFDispatchManager)new SyncServiceOperation<EMFDispatchManager<D>>(this){

            @Override
            protected EMFDispatchManager<D> doCall() throws Exception {
                return EMFDispatchManager.createSingle(SyncService.this.getEMFListener());
            }
        }.safeCall();
    }

    @Override
    public <D extends EMFDispatch> EMFDispatchManager<D> createMultipleDispatchManager() {
        return (EMFDispatchManager)new SyncServiceOperation<EMFDispatchManager<D>>(this){

            @Override
            protected EMFDispatchManager<D> doCall() throws Exception {
                return EMFDispatchManager.createMultiple(SyncService.this.getEMFListener());
            }
        }.safeCall();
    }

    @Override
    public <M, T, X, R extends SyncRegistry<M, T, X>> R getSyncRegistry(final Class<R> registryType) {
        try {
            return (R)((SyncRegistry)new SyncServiceOperation<R>(this){

                @Override
                protected R doCall() throws Exception {
                    SyncRegistry result = (SyncRegistry)TypeUtils.as(SyncService.this.syncRegistries.get(registryType), (Class)registryType);
                    if (result == null) {
                        try {
                            result = (SyncRegistry)registryType.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new ServiceException("Failed to instantiate sync registry.", (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            throw new ServiceException("Insufficient permission to instantiate sync registry.", (Throwable)e);
                        }
                        SyncService.this.syncRegistries.put(registryType, result);
                    }
                    return result;
                }
            }.safeCall(ServiceException.class));
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to access sync registry of type " + registryType.getName(), (Throwable)e);
            return null;
        }
    }

    @Override
    public IStatus evaluateTriggers(final Object object) {
        return (IStatus)new SyncServiceOperation<IStatus>(this){

            @Override
            protected IStatus doCall() {
                IStatus result = Status.OK_STATUS;
                for (ISyncTrigger trigger : SyncTriggerRegistry.getInstance().getSyncTriggers(object)) {
                    IStatus nextResult;
                    ISyncAction action = trigger.trigger(SyncService.this, object);
                    if (action == null || (nextResult = action.perform(SyncService.this, object)) == null || nextResult.isOK()) continue;
                    if (result.isOK()) {
                        result = nextResult;
                        continue;
                    }
                    if (result.isMultiStatus()) {
                        ((MultiStatus)result).merge(nextResult);
                        continue;
                    }
                    result = new MultiStatus("org.eclipse.papyrus.infra.sync", 0, new IStatus[]{result, nextResult}, "Multiple sync trigger evaluation problems occurred.", null);
                }
                return result;
            }
        }.safeCall();
    }

    @Override
    public <V, X extends Exception> V run(final SyncServiceRunnable<V, X> operation) throws X {
        return new SyncServiceOperation<V>(this){

            @Override
            protected V doCall() throws Exception {
                try {
                    return operation.run(SyncService.getCurrent());
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t);
                }
            }
        }.safeCall(operation.getExceptionType());
    }

    @Override
    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    <V> V perform(SyncServiceOperation<V> operation) throws Exception {
        V result;
        SyncService restore = currentService.get();
        currentService.set(this);
        try {
            result = operation.doCall();
        }
        finally {
            if (restore == null) {
                currentService.remove();
            } else {
                currentService.set(restore);
            }
        }
        return result;
    }

    @Override
    public void execute(Command command) {
        if (!command.canExecute()) {
            throw new IllegalArgumentException("unexecutable command");
        }
        if (command instanceof IdentityCommand) {
            return;
        }
        InternalTransactionalEditingDomain domain = (InternalTransactionalEditingDomain)TypeUtils.as((Object)this.editingDomain, InternalTransactionalEditingDomain.class);
        if (domain == null) {
            command.execute();
        } else {
            InternalTransaction active = domain.getActiveTransaction();
            if (active == null || active.isReadOnly()) {
                try {
                    InternalTransaction transaction = domain.startTransaction(false, Collections.singletonMap("unprotected", true));
                    try {
                        command.execute();
                    }
                    finally {
                        transaction.commit();
                    }
                }
                catch (InterruptedException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (RollbackException e) {
                    Activator.log.error("Unprotected synchronization update rolled back. See next log entry for the cause.", null);
                    Activator.log.log(e.getStatus());
                }
            } else if (Boolean.TRUE.equals(active.getOptions().get("unprotected"))) {
                command.execute();
            } else {
                domain.getCommandStack().execute(command);
            }
        }
    }

    @Override
    public ISyncPolicy getSyncPolicy() {
        return this.policy;
    }

    @Override
    public void setSyncPolicy(ISyncPolicy syncPolicy) {
        this.policy = syncPolicy == null ? new NullSyncPolicy() : syncPolicy;
    }

    public EMFListener register(SyncPolicyDelegate<?, ?> policyDelegate, Class<?> featureType) {
        this.policyDelegates.register(policyDelegate, featureType);
        return this.policyDelegates.getEMFListener();
    }

    public void deregister(SyncPolicyDelegate<?, ?> policyDelegate, Class<?> featureType) {
        this.policyDelegates.deregister(policyDelegate, featureType);
    }

    @Override
    public synchronized Executor getAsyncExecutor() {
        return this.executor;
    }

    @Override
    public synchronized void setAsyncExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("null executor");
        }
        if (executor != this.executor) {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).shutdown();
            }
            this.executor = executor;
        }
    }

    @Override
    public <V, X extends Exception> CheckedFuture<V, X> runAsync(SyncServiceRunnable<V, X> operation) {
        CheckedFuture<V, X> result = operation.asFuture(this);
        this.getAsyncExecutor().execute((Runnable)result);
        return result;
    }

    private class RootTrigger
    extends ResourceAdapter.Transactional {
        RootTrigger() {
        }

        protected void handleResourceLoaded(Resource resource) {
            IStatus status = Status.OK_STATUS;
            for (EObject root : resource.getContents()) {
                IStatus nextResult = this.processRoot(resource, root);
                if (nextResult == null || nextResult.isOK()) continue;
                if (status.isOK()) {
                    status = nextResult;
                    continue;
                }
                if (status.isMultiStatus()) {
                    ((MultiStatus)status).merge(nextResult);
                    continue;
                }
                status = new MultiStatus("org.eclipse.papyrus.infra.sync", 0, new IStatus[]{status, nextResult}, "Multiple sync trigger evaluation problems occurred.", null);
            }
            if (!status.isOK()) {
                Activator.log.log(status);
            }
        }

        protected void handleRootAdded(Resource resource, EObject root) {
            IStatus status = this.processRoot(resource, root);
            if (!status.isOK()) {
                Activator.log.log(status);
            }
        }

        protected IStatus processRoot(Resource resource, EObject root) {
            return SyncService.this.evaluateTriggers(root);
        }
    }
}

