/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFramework;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureFramework;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureDomainRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureMergerModule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.MergeState;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class InternalArchitectureDomainMerger {
    @Inject
    @Extension
    private ArchitectureExtensions _architectureExtensions;
    @Inject
    @Extension
    private ArchitectureDomainRule _architectureDomainRule;
    @Inject
    @Extension
    private MergeState _mergeState;
    private final HashMap<ArrayList<?>, MergedArchitectureDomain> _createCache_toMergedArchitectureDomain = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, MergedArchitectureContext> _createCache_toMergedArchitectureContext = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, MergedArchitectureContext> _createCache_toMergedArchitectureContext_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, MergedArchitectureViewpoint> _createCache_toMergedArchitectureViewpoint = CollectionLiterals.newHashMap();

    public List<MergedArchitectureDomain> mergeDomains(Iterable<? extends ArchitectureDomain> domains) {
        ArchitectureExtensions.logf("=== Merge starting ===", new Object[0]);
        ResourceSetImpl mergeableSet = new ResourceSetImpl();
        Collection<ArchitectureDomain> mergeableDomains = this.copy(domains, (ResourceSet)mergeableSet);
        this._mergeState.advancePhase();
        Consumer<ArchitectureDomain> _function = it -> this._architectureDomainRule.inherit((ArchitectureDomain)it);
        mergeableDomains.forEach(_function);
        Consumer<ArchitectureDomain> _function_1 = it -> this._architectureDomainRule.finalizeInheritance((ArchitectureDomain)it);
        mergeableDomains.forEach(_function_1);
        this._mergeState.advancePhase();
        Procedures.Procedure0 _function_2 = () -> {
            Consumer<ArchitectureDomain> _function_3 = it -> this._architectureDomainRule.inferExtensions((ArchitectureDomain)it);
            mergeableDomains.forEach(_function_3);
        };
        this._architectureExtensions.withScope(mergeableDomains, _function_2);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry(ResourceUtils.createWorkspaceAwarePackageRegistry());
        resourceSet.setURIConverter(ResourceUtils.createWorkspaceAwareURIConverter());
        Functions.Function1 _function_3 = it -> {
            Resource _eResource = it.eResource();
            return _eResource == null;
        };
        Functions.Function1 _function_4 = it -> it.eResource().getURI();
        Functions.Function1 _function_5 = it -> resourceSet.createResource(it.eResource().getURI());
        Map mergedResources = IterableExtensions.toMap((Iterable)IterableExtensions.reject(mergeableDomains, (Functions.Function1)_function_3), (Functions.Function1)_function_4, (Functions.Function1)_function_5);
        this._mergeState.advancePhase();
        Functions.Function1 _function_6 = it -> this._architectureDomainRule.isExtension((ArchitectureDomain)it);
        Functions.Function1 _function_7 = it -> this._architectureDomainRule.merged((ArchitectureDomain)it);
        List mergedDomains = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.reject(mergeableDomains, (Functions.Function1)_function_6), (Functions.Function1)_function_7));
        this._mergeState.advancePhase();
        EMFHelper.unload((ResourceSet)mergeableSet);
        Functions.Function1 _function_8 = it -> this._architectureDomainRule.hasContexts((ArchitectureDomain)it);
        Functions.Function1 _function_9 = it -> this.toMergedArchitectureDomain((ArchitectureDomain)it, mergedResources);
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)mergedDomains, (Functions.Function1)_function_8), (Functions.Function1)_function_9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergedArchitectureDomain toMergedArchitectureDomain(ArchitectureDomain domain, Map<URI, Resource> resources) {
        MergedArchitectureDomain _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{domain, resources});
        HashMap<ArrayList<?>, MergedArchitectureDomain> hashMap = this._createCache_toMergedArchitectureDomain;
        synchronized (hashMap) {
            MergedArchitectureDomain _mergedArchitectureDomain;
            if (this._createCache_toMergedArchitectureDomain.containsKey(_cacheKey)) {
                return this._createCache_toMergedArchitectureDomain.get(_cacheKey);
            }
            _result = _mergedArchitectureDomain = new MergedArchitectureDomain(domain);
            this._createCache_toMergedArchitectureDomain.put(_cacheKey, _result);
        }
        this._init_toMergedArchitectureDomain(_result, domain, resources);
        return _result;
    }

    private void _init_toMergedArchitectureDomain(MergedArchitectureDomain result, ArchitectureDomain domain, Map<URI, Resource> resources) {
        ArchitectureDomain _trace = this._architectureExtensions.trace(domain);
        Resource _eResource = null;
        if (_trace != null) {
            _eResource = _trace.eResource();
        }
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        Resource _get = resources.get(_uRI);
        EList _contents = null;
        if (_get != null) {
            _contents = _get.getContents();
        }
        if (_contents != null) {
            _contents.add((Object)domain);
        }
        ArchitectureExtensions.logf("Merge result: %s.", domain);
        Consumer<ArchitectureContext> _function = it -> this.toMergedArchitectureContext((ArchitectureContext)it, result);
        domain.getContexts().forEach(_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergedArchitectureContext _toMergedArchitectureContext(ArchitectureDescriptionLanguage context, MergedArchitectureDomain domain) {
        MergedArchitectureDescriptionLanguage _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Notifier[]{context, domain});
        HashMap<ArrayList<?>, MergedArchitectureContext> hashMap = this._createCache_toMergedArchitectureContext;
        synchronized (hashMap) {
            MergedArchitectureDescriptionLanguage _mergedArchitectureDescriptionLanguage;
            if (this._createCache_toMergedArchitectureContext.containsKey(_cacheKey)) {
                return this._createCache_toMergedArchitectureContext.get(_cacheKey);
            }
            _result = _mergedArchitectureDescriptionLanguage = new MergedArchitectureDescriptionLanguage(domain, context);
            this._createCache_toMergedArchitectureContext.put(_cacheKey, _result);
        }
        this._init_toMergedArchitectureContext(_result, context, domain);
        return _result;
    }

    private void _init_toMergedArchitectureContext(MergedArchitectureDescriptionLanguage result, ArchitectureDescriptionLanguage context, MergedArchitectureDomain domain) {
        ArchitectureExtensions.logf("Merge result: %.60s.", context);
        Consumer<ArchitectureViewpoint> _function = it -> this.toMergedArchitectureViewpoint((ArchitectureViewpoint)it, result);
        context.getViewpoints().forEach(_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergedArchitectureContext _toMergedArchitectureContext(ArchitectureFramework context, MergedArchitectureDomain domain) {
        MergedArchitectureFramework _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Notifier[]{context, domain});
        HashMap<ArrayList<?>, MergedArchitectureContext> hashMap = this._createCache_toMergedArchitectureContext_1;
        synchronized (hashMap) {
            MergedArchitectureFramework _mergedArchitectureFramework;
            if (this._createCache_toMergedArchitectureContext_1.containsKey(_cacheKey)) {
                return this._createCache_toMergedArchitectureContext_1.get(_cacheKey);
            }
            _result = _mergedArchitectureFramework = new MergedArchitectureFramework(domain, context);
            this._createCache_toMergedArchitectureContext_1.put(_cacheKey, _result);
        }
        this._init_toMergedArchitectureContext_1(_result, context, domain);
        return _result;
    }

    private void _init_toMergedArchitectureContext_1(MergedArchitectureFramework result, ArchitectureFramework context, MergedArchitectureDomain domain) {
        ArchitectureExtensions.logf("Merge result: %.60s.", context);
        Consumer<ArchitectureViewpoint> _function = it -> this.toMergedArchitectureViewpoint((ArchitectureViewpoint)it, result);
        context.getViewpoints().forEach(_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergedArchitectureViewpoint toMergedArchitectureViewpoint(ArchitectureViewpoint viewpoint, MergedArchitectureContext context) {
        MergedArchitectureViewpoint _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Notifier[]{viewpoint, context});
        HashMap<ArrayList<?>, MergedArchitectureViewpoint> hashMap = this._createCache_toMergedArchitectureViewpoint;
        synchronized (hashMap) {
            MergedArchitectureViewpoint _mergedArchitectureViewpoint;
            if (this._createCache_toMergedArchitectureViewpoint.containsKey(_cacheKey)) {
                return this._createCache_toMergedArchitectureViewpoint.get(_cacheKey);
            }
            _result = _mergedArchitectureViewpoint = new MergedArchitectureViewpoint(context, viewpoint);
            this._createCache_toMergedArchitectureViewpoint.put(_cacheKey, _result);
        }
        this._init_toMergedArchitectureViewpoint(_result, viewpoint, context);
        return _result;
    }

    private void _init_toMergedArchitectureViewpoint(MergedArchitectureViewpoint result, ArchitectureViewpoint viewpoint, MergedArchitectureContext context) {
        StringBuilder representations = new StringBuilder();
        Formatter formatter = new Formatter(representations);
        Consumer<RepresentationKind> _function = it -> {
            boolean _greaterThan;
            int _length = representations.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                formatter.format(", ", new Object[0]);
            }
            formatter.format("%.20s", this._architectureExtensions.formatted((ADElement)it));
        };
        viewpoint.getRepresentationKinds().forEach(_function);
        ArchitectureExtensions.logf("Merge result: %.60s -- %s.", viewpoint, representations);
    }

    private Collection<ArchitectureDomain> copy(Iterable<? extends ArchitectureDomain> domains, ResourceSet resourceSet) {
        Collection _xblockexpression = null;
        ArchitectureExtensions.logf("Copying source domains %s.", domains);
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){

            public EObject copy(EObject eObject) {
                EObject _copy = super.copy(eObject);
                Procedures.Procedure1 _function = it -> {
                    boolean _matched = false;
                    if (it instanceof ADElement) {
                        _matched = true;
                        InternalArchitectureDomainMerger.this._architectureExtensions.traceTo((ADElement)it, (ADElement)eObject);
                    }
                };
                return (EObject)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
            }
        };
        Collection result = copier.copyAll((Collection)IterableExtensions.toSet(domains));
        copier.copyReferences();
        Functions.Function1 _function = it -> {
            Resource _eResource = it.eResource();
            return _eResource == null;
        };
        Consumer<ArchitectureDomain> _function_1 = orig -> {
            EList _contents = resourceSet.createResource(orig.eResource().getURI()).getContents();
            EObject _get = (EObject)copier.get(orig);
            _contents.add((Object)_get);
        };
        IterableExtensions.reject(domains, (Functions.Function1)_function).forEach(_function_1);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static InternalArchitectureDomainMerger newInstance() {
        ArchitectureMergerModule _architectureMergerModule = new ArchitectureMergerModule();
        return InternalArchitectureDomainMerger.newInstance(_architectureMergerModule);
    }

    public static InternalArchitectureDomainMerger newInstance(AbstractModule module) {
        return (InternalArchitectureDomainMerger)Guice.createInjector((Module[])new Module[]{module}).getInstance(InternalArchitectureDomainMerger.class);
    }

    private MergedArchitectureContext toMergedArchitectureContext(ArchitectureContext context, MergedArchitectureDomain domain) {
        if (context instanceof ArchitectureDescriptionLanguage) {
            return this._toMergedArchitectureContext((ArchitectureDescriptionLanguage)context, domain);
        }
        if (context instanceof ArchitectureFramework) {
            return this._toMergedArchitectureContext((ArchitectureFramework)context, domain);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{context, domain}).toString());
    }
}

