/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.Messages;
import org.eclipse.mylyn.internal.tasks.bugs.SupportHandlerManager;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProviderManager;
import org.eclipse.mylyn.internal.tasks.bugs.SupportRequest;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ReportErrorWizard;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.bugs.IProduct;
import org.eclipse.mylyn.tasks.bugs.ITaskContribution;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.swt.widgets.Display;

public class TaskErrorReporter {
    private final SupportHandlerManager handlerManager = new SupportHandlerManager();
    private final SupportProviderManager providerManager = new SupportProviderManager();

    public SupportHandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    public SupportRequest preProcess(IStatus status, IProduct product) {
        Assert.isNotNull((Object)status);
        SupportRequest request = new SupportRequest(this.providerManager, status, product);
        this.handlerManager.preProcess(request);
        return request;
    }

    public boolean process(final ITaskContribution response, IRunnableContext context) {
        Assert.isNotNull((Object)response);
        ICoreRunnable runner = new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(Messages.TaskErrorReporter_Job_Progress_Process_support_request, -1);
                    TaskErrorReporter.this.process((AttributeTaskMapper)response, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            CommonUiUtil.run((IRunnableContext)context, (ICoreRunnable)runner);
        }
        catch (CoreException e) {
            TasksUiInternal.logAndDisplayStatus((String)Messages.TaskErrorReporter_Create_Task_Error_Title, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", Messages.TaskErrorReporter_Create_Task_Error_Message, (Throwable)e));
            return false;
        }
        catch (OperationCanceledException e) {
            return false;
        }
        return true;
    }

    public void process(AttributeTaskMapper mapper, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)mapper);
        this.handlerManager.process(mapper, monitor);
        if (!mapper.isHandled()) {
            final TaskData taskData = mapper.createTaskData(monitor);
            mapper.setTaskData(taskData);
            this.handlerManager.postProcess(mapper, monitor);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TasksUiInternal.createAndOpenNewTask((TaskData)taskData);
                    }
                    catch (CoreException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Unexpected error while creating task", (Throwable)e));
                    }
                }
            });
        }
    }

    public void handle(IStatus status) {
        ReportErrorWizard wizard = new ReportErrorWizard(this, status);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.setPageSize(500, 200);
        dialog.open();
    }

    public SupportProviderManager getProviderManager() {
        return this.providerManager;
    }
}

