/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import com.google.common.base.Strings;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mylyn.commons.ui.Messages;
import org.eclipse.mylyn.commons.ui.TableColumnDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class TableColumnDescriptorDialog
extends TitleAreaDialog {
    private final TableColumnDescriptor[] columnDescriptors;
    private TableColumnDescriptor selectedTableColumnDescriptor;
    private Text nameTxt;
    private Text widthTxt;
    private Combo alignmentCombo;
    private Combo sortDirectionCombo;
    private Button defaultSortColumnCheckbox;
    private Button autosizeCheckbox;

    public TableColumnDescriptorDialog(Shell parentShell, @NonNull TableColumnDescriptor[] columnDescriptor) {
        super(parentShell);
        this.columnDescriptors = columnDescriptor;
        Assert.isTrue((this.columnDescriptors.length > 0 ? 1 : 0) != 0);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.TableColumnDescriptorDialog_Change_Column_Settings);
        this.setTitle(Messages.TableColumnDescriptorDialog_Change_Column_Settings);
        Control control = super.createContents(parent);
        TableColumnDescriptorDialog.applyDialogFont((Control)control);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent2 = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent2, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)composite);
        this.createCenterArea(composite);
        composite.pack();
        return parent2;
    }

    private void createCenterArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        TableViewer attributeListViewer = new TableViewer(composite, 67588);
        Table table = (Table)attributeListViewer.getControl();
        GridDataFactory.fillDefaults().grab(false, false).align(16384, 4).hint(this.convertWidthInCharsToPixels(10), this.convertHeightInCharsToPixels(5)).applyTo((Control)table);
        table.setFont(parent.getFont());
        attributeListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        attributeListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TableColumnDescriptor) {
                    TableColumnDescriptor tableColumnDescriptors = (TableColumnDescriptor)element;
                    return tableColumnDescriptors.getName();
                }
                return super.getText(element);
            }
        });
        attributeListViewer.setInput((Object)this.columnDescriptors);
        attributeListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty()) {
                    TableColumnDescriptorDialog.this.selectedTableColumnDescriptor = (TableColumnDescriptor)((IStructuredSelection)selection).getFirstElement();
                    TableColumnDescriptorDialog.this.updateDetailAttributes();
                }
            }
        });
        Composite detailComposite = new Composite(composite, 2048);
        detailComposite.setLayout((Layout)new GridLayout(2, false));
        detailComposite.setLayoutData((Object)new GridData(768));
        new Label(detailComposite, 0).setText(Messages.TableColumnDescriptorDialog_Name);
        this.nameTxt = new Text(detailComposite, 2048);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.nameTxt);
        this.nameTxt.setEditable(false);
        this.nameTxt.setEnabled(false);
        new Label(detailComposite, 0).setText(Messages.TableColumnDescriptorDialog_Width);
        this.widthTxt = new Text(detailComposite, 2048);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.widthTxt);
        this.widthTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    String widthString = TableColumnDescriptorDialog.this.widthTxt.getText();
                    if (Strings.isNullOrEmpty((String)widthString)) {
                        TableColumnDescriptorDialog.this.setErrorMessage(Messages.TableColumnDescriptorDialog_please_enter_value_for_Width);
                    } else {
                        int newWidth = Integer.parseInt(TableColumnDescriptorDialog.this.widthTxt.getText());
                        if (newWidth >= 0) {
                            TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setWidth(newWidth);
                            TableColumnDescriptorDialog.this.setErrorMessage(null);
                        } else {
                            TableColumnDescriptorDialog.this.setErrorMessage(Messages.TableColumnDescriptorDialog_Width_must_be_greater_or_equal_0);
                        }
                    }
                }
                catch (NumberFormatException exception) {
                    TableColumnDescriptorDialog.this.setErrorMessage(Messages.TableColumnDescriptorDialog_Width_is_not_a_valid_number);
                }
            }
        });
        new Label(detailComposite, 0).setText(Messages.TableColumnDescriptorDialog_Alignment);
        this.alignmentCombo = new Combo(detailComposite, 8);
        this.alignmentCombo.add(Messages.TableColumnDescriptorDialog_Left);
        this.alignmentCombo.add(Messages.TableColumnDescriptorDialog_Center);
        this.alignmentCombo.add(Messages.TableColumnDescriptorDialog_Right);
        this.alignmentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (TableColumnDescriptorDialog.this.alignmentCombo.getSelectionIndex()) {
                    case 0: {
                        TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setAlignment(16384);
                        break;
                    }
                    case 1: {
                        TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setAlignment(0x1000000);
                        break;
                    }
                    case 2: {
                        TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setAlignment(131072);
                    }
                }
            }
        });
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.alignmentCombo);
        new Label(detailComposite, 0);
        this.autosizeCheckbox = new Button(detailComposite, 32);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.autosizeCheckbox);
        this.autosizeCheckbox.setText(Messages.TableColumnDescriptorDialog_autosize);
        this.autosizeCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setAutoSize(TableColumnDescriptorDialog.this.autosizeCheckbox.getSelection());
            }
        });
        new Label(detailComposite, 0);
        this.defaultSortColumnCheckbox = new Button(detailComposite, 32);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.defaultSortColumnCheckbox);
        this.defaultSortColumnCheckbox.setText(Messages.TableColumnDescriptorDialog_DefaultSortColumn);
        this.defaultSortColumnCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = TableColumnDescriptorDialog.this.defaultSortColumnCheckbox.getSelection();
                TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setDefaultSortColumn(selected);
                if (selected) {
                    TableColumnDescriptor[] tableColumnDescriptorArray = TableColumnDescriptorDialog.this.columnDescriptors;
                    int n = TableColumnDescriptorDialog.this.columnDescriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumnDescriptor tableColumnDescriptor = tableColumnDescriptorArray[n2];
                        if (tableColumnDescriptor != TableColumnDescriptorDialog.this.selectedTableColumnDescriptor) {
                            tableColumnDescriptor.setDefaultSortColumn(false);
                        }
                        ++n2;
                    }
                }
            }
        });
        new Label(detailComposite, 0).setText(Messages.TableColumnDescriptorDialog_Sort_Direction);
        this.sortDirectionCombo = new Combo(detailComposite, 8);
        this.sortDirectionCombo.add("");
        this.sortDirectionCombo.add(Messages.TableColumnDescriptorDialog_Up);
        this.sortDirectionCombo.add(Messages.TableColumnDescriptorDialog_Down);
        this.sortDirectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (TableColumnDescriptorDialog.this.sortDirectionCombo.getSelectionIndex()) {
                    case 0: {
                        TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setSortDirection(0);
                        break;
                    }
                    case 1: {
                        TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setSortDirection(128);
                        break;
                    }
                    case 2: {
                        TableColumnDescriptorDialog.this.selectedTableColumnDescriptor.setSortDirection(1024);
                    }
                }
            }
        });
        this.selectedTableColumnDescriptor = this.columnDescriptors[0];
        attributeListViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedTableColumnDescriptor));
    }

    public TableColumnDescriptor[] getColumnDescriptors() {
        return this.columnDescriptors;
    }

    protected void updateDetailAttributes() {
        this.nameTxt.setText(this.selectedTableColumnDescriptor.getName());
        this.widthTxt.setText(Integer.toString(this.selectedTableColumnDescriptor.getWidth()));
        this.defaultSortColumnCheckbox.setSelection(this.selectedTableColumnDescriptor.isDefaultSortColumn());
        this.autosizeCheckbox.setSelection(this.selectedTableColumnDescriptor.isAutoSize());
        if (this.selectedTableColumnDescriptor.getAlignment() == 16384) {
            this.alignmentCombo.select(0);
        } else if (this.selectedTableColumnDescriptor.getAlignment() == 0x1000000) {
            this.alignmentCombo.select(1);
        } else if (this.selectedTableColumnDescriptor.getAlignment() == 131072) {
            this.alignmentCombo.select(2);
        }
        if (this.selectedTableColumnDescriptor.getSortDirection() == 128) {
            this.sortDirectionCombo.select(1);
        } else if (this.selectedTableColumnDescriptor.getSortDirection() == 1024) {
            this.sortDirectionCombo.select(2);
        } else {
            this.sortDirectionCombo.select(0);
        }
    }
}

