/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.modisco.facet.custom.core.ICustomizationManager;
import org.eclipse.modisco.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.modisco.facet.custom.ui.ICustomizationManagerProvider2;
import org.eclipse.modisco.facet.custom.ui.ICustomizedContentProviderFactory;
import org.eclipse.modisco.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.modisco.facet.custom.ui.IResolvingCustomizedLabelProviderFactory;
import org.eclipse.modisco.facet.efacet.core.IFacetManager;
import org.eclipse.modisco.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.modisco.facet.efacet.core.IFacetManagerListener;
import org.eclipse.modisco.facet.efacet.ui.IFacetManagerProvider2;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IOkDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IOkDialogFactory;
import org.eclipse.modisco.infra.browser.editor.ui.ITreeEditor;
import org.eclipse.modisco.infra.browser.editor.ui.internal.Activator;
import org.eclipse.modisco.infra.browser.editor.ui.internal.editor.TreeEditorDragAndDropUtils;
import org.eclipse.modisco.infra.browser.editor.ui.internal.editor.TreeEditorSelectionProvider;
import org.eclipse.modisco.infra.browser.editor.ui.internal.editor.TreeEditorShortcutUtils;
import org.eclipse.modisco.infra.browser.editor.ui.internal.opener.ResourceEditorInput;
import org.eclipse.modisco.infra.browser.editor.ui.internal.opener.ResourceSetEditorInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TreeEditor
extends EditorPart
implements IEditingDomainProvider,
IFacetManagerProvider2,
ICustomizationManagerProvider2,
ITreeEditor {
    private static final String EDITOR_ID = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".TreeEditor";
    private Resource resource;
    private ResourceSet resourceSet;
    private EditingDomain editingDomain;
    private IFacetManager facetManager;
    private ICustomizationManager customManager;
    private TreeViewer tree;
    private IFacetManagerListener facetMgrListener;
    private List<IFacetManagerProvider2.IFacetSetShortcut> facetSetShortcuts;
    private List<ICustomizationManagerProvider2.ICustomShortcut> customShortcuts;
    private ISelectionProvider selectionProvider;

    public void doSave(IProgressMonitor monitor) {
        this.doSave();
    }

    public IOkDialog doSave() {
        IOkDialog result = null;
        try {
            this.resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            URI uri = this.resource.getURI();
            String message = String.format("Failed to save %s", uri);
            result = IOkDialogFactory.DEFAULT.openErrorDialog(this.getSite().getShell(), (Exception)e, message);
        }
        BasicCommandStack commandStack = (BasicCommandStack)this.editingDomain.getCommandStack();
        commandStack.saveIsDone();
        this.firePropertyChange(257);
        return result;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEI = (FileEditorInput)input;
            IFile file = fileEI.getFile();
            IPath path = file.getFullPath();
            String pathStr = path.toString();
            URI uri = URI.createPlatformResourceURI((String)pathStr, (boolean)true);
            this.resourceSet = new ResourceSetImpl();
            this.resource = this.resourceSet.getResource(uri, true);
        } else if (input instanceof ResourceEditorInput) {
            ResourceEditorInput resourceEI = (ResourceEditorInput)input;
            this.resource = resourceEI.getResource();
            this.resourceSet = this.resource.getResourceSet();
        } else if (input instanceof ResourceSetEditorInput) {
            ResourceSetEditorInput resourceSetEI = (ResourceSetEditorInput)input;
            this.resourceSet = resourceSetEI.getResourceSet();
        } else {
            String message = String.format("The EditorInput (%s) is not compatible with the TreeEditor", input.getClass().getName());
            throw new IllegalArgumentException(message);
        }
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        this.editingDomain = this.initEditingDomain();
        this.facetSetShortcuts = TreeEditorShortcutUtils.getFacetSetShortcuts(this.resourceSet);
        this.customShortcuts = TreeEditorShortcutUtils.getCustomShortcuts(this.resourceSet);
    }

    private final EditingDomain initEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                TreeEditor.this.onCommandStackChanged();
            }
        });
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, this.resourceSet);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.tree.getControl());
        this.tree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, this.selectionProvider);
    }

    protected final void onCommandStackChanged() {
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        BasicCommandStack basicCommandStack = (BasicCommandStack)this.editingDomain.getCommandStack();
        boolean saveNeeded = basicCommandStack.isSaveNeeded();
        return this.isReadWriteResource() && saveNeeded;
    }

    private boolean isReadWriteResource() {
        URI uri = this.resource.getURI();
        String uriStr = uri.toString();
        return uriStr.matches("(platform:/resource/.*)|(file:/)");
    }

    public boolean isSaveAsAllowed() {
        return this.isDirty();
    }

    public void createPartControl(Composite parent) {
        this.tree = new TreeViewer(parent);
        this.facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.resourceSet);
        this.customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.resourceSet);
        ICustomizedLabelProvider labelProvider = IResolvingCustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(this.customManager);
        IContentProvider contentProvider = ICustomizedContentProviderFactory.DEFAULT.createCustomizedTreeContentProvider(this.customManager, new ICustomizedContentProviderFactory.IContentListener(){

            public void onUpdate(Object object) {
                TreeEditor.this.syncRefresh(object);
            }
        });
        this.tree.setContentProvider(contentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)labelProvider);
        ArrayList contents = new ArrayList();
        if (this.resource == null) {
            for (Resource res : this.resourceSet.getResources()) {
                contents.addAll(res.getContents());
            }
        } else {
            contents.addAll(this.resource.getContents());
        }
        TreeEditorDragAndDropUtils.addDragAndDropSupport(this.tree, this.editingDomain);
        this.tree.setInput(contents);
        this.selectionProvider = new TreeEditorSelectionProvider((ISelectionProvider)this.tree);
        this.getSite().setSelectionProvider(this.selectionProvider);
        this.facetMgrListener = new IFacetManagerListener(){

            public void facetManagerChanged() {
                TreeEditor.this.refresh();
            }
        };
        this.createPopupMenu();
        this.facetManager.addListener(this.facetMgrListener);
    }

    protected void syncRefresh(final Object object) {
        Shell shell = this.getSite().getShell();
        Display display = shell.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeEditor.this.internalRefresh(object);
            }
        });
    }

    protected void internalRefresh(Object object) {
        this.tree.refresh(object);
    }

    protected void refresh() {
        Object[] expanededElts = this.tree.getExpandedElements();
        this.tree.refresh();
        this.tree.setExpandedElements(expanededElts);
    }

    public void setFocus() {
    }

    public static String getEditorId() {
        return EDITOR_ID;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        result = adapter.isInstance(this) ? this : (adapter == ISelectionProvider.class ? this.selectionProvider : super.getAdapter(adapter));
        return result;
    }

    public ICustomizationManager getCustomizationManager() {
        return this.customManager;
    }

    public List<ICustomizationManagerProvider2.ICustomShortcut> getCustomShortcuts() {
        return this.customShortcuts;
    }

    public IFacetManager getFacetManager() {
        return this.facetManager;
    }

    public List<IFacetManagerProvider2.IFacetSetShortcut> getFacetSetShortcuts() {
        return this.facetSetShortcuts;
    }

    public void dispose() {
        this.facetManager.removeListener(this.facetMgrListener);
        super.dispose();
    }

    public ILabelProvider getViewerLabelProvider() {
        return (ILabelProvider)this.tree.getLabelProvider();
    }
}

