/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ReplicateRepositoryRequest
extends CDOClientRequest<Boolean> {
    private CDOReplicationContext context;

    public ReplicateRepositoryRequest(CDOClientProtocol protocol, CDOReplicationContext context, OMMonitor monitor) {
        super(protocol, (short)42);
        this.context = context;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.context.getLastReplicatedBranchID());
        out.writeXLong(this.context.getLastReplicatedCommitTime());
        String[] lockAreaIDs = this.context.getLockAreaIDs();
        out.writeXInt(lockAreaIDs.length);
        int i = 0;
        while (i < lockAreaIDs.length) {
            out.writeString(lockAreaIDs[i]);
            ++i;
        }
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        byte opcode;
        block6: while (true) {
            opcode = in.readByte();
            switch (opcode) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.context.handleBranch(in.readCDOBranch());
                    continue block6;
                }
                case 2: {
                    this.context.handleCommitInfo(in.readCDOCommitInfo());
                    continue block6;
                }
                case 3: {
                    boolean missing;
                    boolean bl = missing = !in.readBoolean();
                    if (missing) {
                        String missingLockAreaID = in.readString();
                        IDurableLockingManager.LockArea area = CDOLockUtil.createLockArea((String)missingLockAreaID);
                        this.context.handleLockArea(area);
                        continue block6;
                    }
                    this.context.handleLockArea(in.readCDOLockArea());
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid replicate opcode: " + opcode);
    }
}

