/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.spi.common.lock.AbstractCDOLockState;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public abstract class CDOLockDeltaImpl
implements CDOLockDelta {
    protected final Object target;
    protected final CDOLockOwner oldOwner;
    protected final CDOLockOwner newOwner;

    private CDOLockDeltaImpl(Object target, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        CheckUtil.checkArg((Object)target, (String)"target");
        CheckUtil.checkArg((oldOwner != null || newOwner != null ? 1 : 0) != 0, (String)"oldOwner != null || newOwner != null");
        this.target = target;
        this.oldOwner = oldOwner;
        this.newOwner = newOwner;
    }

    @Override
    public final Object getTarget() {
        return this.target;
    }

    @Override
    public final CDOID getID() {
        return CDOLockUtil.getLockedObjectID(this.target);
    }

    @Override
    public final CDOBranch getBranch() {
        return CDOLockUtil.getLockedObjectBranch(this.target);
    }

    @Override
    public final CDOLockOwner getOldOwner() {
        return this.oldOwner;
    }

    @Override
    public final CDOLockOwner getNewOwner() {
        return this.newOwner;
    }

    @Override
    public final CDOLockDelta.Kind getKind() {
        if (this.oldOwner == null) {
            return CDOLockDelta.Kind.ADDED;
        }
        if (this.newOwner == null) {
            return CDOLockDelta.Kind.REMOVED;
        }
        return CDOLockDelta.Kind.REMAPPED;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getKind());
        builder.append('_');
        builder.append(this.getType());
        builder.append('[');
        builder.append(this.target);
        if (this.oldOwner != null) {
            builder.append(" - ");
            AbstractCDOLockState.appendLockOwner(builder, this.oldOwner);
        }
        if (this.newOwner != null) {
            builder.append(" + ");
            AbstractCDOLockState.appendLockOwner(builder, this.newOwner);
        }
        builder.append(']');
        return builder.toString();
    }

    public static CDOLockDelta create(Object target, IRWLockManager.LockType type, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        switch (type) {
            case READ: {
                return new Read(target, oldOwner, newOwner);
            }
            case WRITE: {
                return new Write(target, oldOwner, newOwner);
            }
            case OPTION: {
                return new Option(target, oldOwner, newOwner);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static CDOLockDelta createNull(Object target) {
        return new Null(target);
    }

    /* synthetic */ CDOLockDeltaImpl(Object object, CDOLockOwner cDOLockOwner, CDOLockOwner cDOLockOwner2, CDOLockDeltaImpl cDOLockDeltaImpl) {
        this(object, cDOLockOwner, cDOLockOwner2);
    }

    private static final class Null
    implements CDOLockDelta {
        private final Object target;

        public Null(Object target) {
            CheckUtil.checkArg((Object)target, (String)"target");
            this.target = target;
        }

        @Override
        public Object getTarget() {
            return this.target;
        }

        @Override
        public final CDOID getID() {
            return CDOLockUtil.getLockedObjectID(this.target);
        }

        @Override
        public final CDOBranch getBranch() {
            return CDOLockUtil.getLockedObjectBranch(this.target);
        }

        @Override
        public IRWLockManager.LockType getType() {
            return null;
        }

        @Override
        public CDOLockOwner getOldOwner() {
            return null;
        }

        @Override
        public CDOLockOwner getNewOwner() {
            return null;
        }

        @Override
        public CDOLockDelta.Kind getKind() {
            return null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NULL[");
            builder.append(this.target);
            builder.append(']');
            return builder.toString();
        }
    }

    private static final class Option
    extends CDOLockDeltaImpl {
        public Option(Object target, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
            super(target, oldOwner, newOwner, null);
        }

        @Override
        public IRWLockManager.LockType getType() {
            return IRWLockManager.LockType.OPTION;
        }
    }

    private static final class Read
    extends CDOLockDeltaImpl {
        public Read(Object target, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
            super(target, oldOwner, newOwner, null);
        }

        @Override
        public IRWLockManager.LockType getType() {
            return IRWLockManager.LockType.READ;
        }
    }

    private static final class Write
    extends CDOLockDeltaImpl {
        public Write(Object target, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
            super(target, oldOwner, newOwner, null);
        }

        @Override
        public IRWLockManager.LockType getType() {
            return IRWLockManager.LockType.WRITE;
        }
    }
}

