/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.CompositeBox;
import org.eclipse.draw2d.text.FlowContainerLayout;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.LineBox;
import org.eclipse.draw2d.text.NestedLine;

public class InlineFlowLayout
extends FlowContainerLayout {
    public InlineFlowLayout(FlowFigure flow) {
        super(flow);
    }

    @Override
    public void addLine(CompositeBox box) {
        this.endLine();
        this.getContext().addLine(box);
    }

    @Override
    protected void createNewLine() {
        this.currentLine = new NestedLine((InlineFlow)this.getFlowFigure());
        this.setupLine(this.currentLine);
    }

    @Override
    public void endLine() {
        this.flush();
        this.getContext().endLine();
    }

    @Override
    protected void flush() {
        if (this.currentLine != null && this.currentLine.isOccupied()) {
            boolean sameLine = this.getContext().getContinueOnSameLine();
            this.getContext().addToCurrentLine(this.currentLine);
            ((InlineFlow)this.getFlowFigure()).getFragments().add(this.currentLine);
            this.currentLine = null;
            this.getContext().setContinueOnSameLine(sameLine);
        }
    }

    @Override
    public boolean getContinueOnSameLine() {
        return this.getContext().getContinueOnSameLine();
    }

    @Override
    public void getWidthLookahead(FlowFigure child, int[] result) {
        List<? extends IFigure> children = this.getFlowFigure().getChildren();
        int index = -1;
        if (child != null) {
            index = children.indexOf(child);
        }
        int i = index + 1;
        while (i < children.size()) {
            if (((FlowFigure)children.get(i)).addLeadingWordRequirements(result)) {
                return;
            }
            ++i;
        }
        this.getContext().getWidthLookahead(this.getFlowFigure(), result);
    }

    @Override
    public boolean isCurrentLineOccupied() {
        return this.currentLine != null && !this.currentLine.getFragments().isEmpty() || this.getContext().isCurrentLineOccupied();
    }

    @Override
    public void preLayout() {
        ((InlineFlow)this.getFlowFigure()).getFragments().clear();
    }

    @Override
    public void setContinueOnSameLine(boolean value) {
        this.getContext().setContinueOnSameLine(value);
    }

    protected void setupLine(LineBox line) {
        line.setX(0);
        line.setRecommendedWidth(this.getContext().getRemainingLineWidth());
    }
}

