/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search;

import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.SearchPatternProcessor;

public class TclSearchPatternProcessor
extends SearchPatternProcessor {
    private static final String SEPARATOR = "::";

    public char[] extractDeclaringTypeQualification(String patternString) {
        int pos1 = patternString.lastIndexOf(SEPARATOR);
        if (pos1 != -1) {
            String p = patternString.substring(0, pos1);
            int pos2 = p.lastIndexOf(SEPARATOR);
            if (pos2 != -1) {
                return patternString.substring(0, pos2).toCharArray();
            }
            return null;
        }
        return null;
    }

    public char[] extractDeclaringTypeSimpleName(String patternString) {
        int pos1 = patternString.lastIndexOf(SEPARATOR);
        if (pos1 != -1) {
            String p = patternString.substring(0, pos1);
            return this.getLastTclNameElement(p).toCharArray();
        }
        return null;
    }

    public char[] extractSelector(String patternString) {
        return this.getLastTclNameElement(patternString).toCharArray();
    }

    private String getLastTclNameElement(String patternString) {
        int pos = patternString.lastIndexOf(SEPARATOR);
        if (pos != -1) {
            return patternString.substring(pos + 2);
        }
        return patternString;
    }

    public String getDelimiterReplacementString() {
        return SEPARATOR;
    }

    public ISearchPatternProcessor.ITypePattern parseType(String patternString) {
        int pos = patternString.lastIndexOf(SEPARATOR);
        if (pos != -1) {
            return new SearchPatternProcessor.TypePattern(patternString.substring(0, pos).replace(SEPARATOR, TYPE_SEPARATOR_STR), patternString.substring(pos + SEPARATOR.length()));
        }
        return new SearchPatternProcessor.TypePattern(null, patternString);
    }
}

