/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpRawPacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpNotifyPacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPackageProcessor;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPacketWaiter;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponcePacketWaiter;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpStreamPacket;
import org.eclipse.dltk.dbgp.internal.packets.IDbgpRawLogger;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.w3c.dom.Document;

public class DbgpSimplePacketReceiver {
    private final DbgpResponcePacketWaiter responseWaiter;
    private final DbgpPacketWaiter notifyWaiter = new DbgpPacketWaiter();
    private final DbgpPacketWaiter streamWaiter = new DbgpPacketWaiter();
    private final DbgpPackageProcessor processor;
    private IDbgpRawLogger logger;

    public DbgpSimplePacketReceiver() {
        this.responseWaiter = new DbgpResponcePacketWaiter();
        this.processor = new DbgpPackageProcessor();
    }

    public void close() {
        this.responseWaiter.terminate();
        this.notifyWaiter.terminate();
        this.streamWaiter.terminate();
    }

    protected void addDocument(Document doc) {
        this.processor.processPacket(doc, this.notifyWaiter, this.responseWaiter, this.streamWaiter);
    }

    public DbgpNotifyPacket getNotifyPacket() throws InterruptedException {
        return (DbgpNotifyPacket)this.notifyWaiter.waitPacket();
    }

    public DbgpStreamPacket getStreamPacket() throws InterruptedException {
        return (DbgpStreamPacket)this.streamWaiter.waitPacket();
    }

    public DbgpResponsePacket getResponsePacket(int transactionId, int timeout) throws InterruptedException {
        return this.responseWaiter.waitPacket(transactionId, timeout);
    }

    public void setLogger(IDbgpRawLogger logger) {
        this.logger = logger;
    }

    public void process(DbgpRawPacket packet) {
        if (this.logger != null) {
            this.logger.log(packet);
        }
        try {
            this.addDocument(packet.getParsedXml());
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.logError(e.getMessage(), e);
        }
    }
}

