/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.Vector;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.DriversProvider;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.DriverImages;
import org.eclipse.datatools.connectivity.internal.ui.OverlayImageIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DriverTreeLabelProvider
extends LabelProvider
implements ILabelDecorator {
    private Image mNullImage = DriverImages.NULLIMAGE.createImage();
    private Image mDriverImage = DriverImages.DRIVER.createImage();
    private Image mCategoryImage = DriverImages.CATEGORY.createImage();
    private static DriverImages driverImage_ = new DriverImages();

    public void dispose() {
        this.mNullImage.dispose();
        this.mDriverImage.dispose();
        this.mCategoryImage.dispose();
        this.mNullImage = null;
        this.mDriverImage = null;
        this.mCategoryImage = null;
    }

    public Image getImage(Object element) {
        Image returnImage = null;
        if (element instanceof DriversProvider) {
            returnImage = null;
        } else if (element instanceof CategoryDescriptor) {
            returnImage = this.mCategoryImage;
        } else if (element instanceof TemplateDescriptor) {
            returnImage = this.mDriverImage;
        } else if (element instanceof IPropertySet) {
            returnImage = this.mDriverImage;
        }
        return returnImage;
    }

    public String getText(Object element) {
        if (element instanceof DriversProvider) {
            return null;
        }
        if (element instanceof CategoryDescriptor) {
            return ((CategoryDescriptor)element).getName();
        }
        if (element instanceof TemplateDescriptor) {
            return ((TemplateDescriptor)element).getName();
        }
        if (element instanceof IPropertySet) {
            return ((IPropertySet)element).getName();
        }
        return "";
    }

    public Image decorateImage(Image image, Object element) {
        if (!(element instanceof IPropertySet)) {
            return null;
        }
        IPropertySet instance = (IPropertySet)element;
        String driverType = instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
        TemplateDescriptor template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType);
        DriverValidator validator = new DriverValidator(template, instance);
        if (validator.isValid()) {
            return null;
        }
        Vector<String> decoratorImageKeys = new Vector<String>();
        decoratorImageKeys.add(DriverImages.ERROR_KEY);
        if (decoratorImageKeys.size() != 0) {
            image = this.drawIconImage(image, decoratorImageKeys);
            return image;
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    private Image drawIconImage(Image baseImage, Vector decoratorImageKeys) {
        OverlayImageIcon overlayIcon = new OverlayImageIcon(baseImage, driverImage_, decoratorImageKeys);
        Image image = overlayIcon.getImage();
        return image;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

