/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.launching;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.xtext.xbase.ui.launching.JavaElementDelegate;

public class JavaElementDelegateJunitLaunch
extends JavaElementDelegate {
    private static final Logger log = Logger.getLogger(JavaElementDelegateJunitLaunch.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean containsElementsSearchedFor(IFile file) {
        IJavaElement element = JavaCore.create((IFile)file);
        if (element == null) return false;
        if (!element.exists()) return false;
        if (!(element instanceof ICompilationUnit)) {
            return false;
        }
        try {
            IType type;
            IType[] allTypes;
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] iTypeArray = allTypes = cu.getAllTypes();
            int n = allTypes.length;
            int n2 = 0;
            while (n2 < n) {
                type = iTypeArray[n2];
                if (this.containsJUnitTestMethod(type)) {
                    return true;
                }
                ++n2;
            }
            iTypeArray = allTypes;
            n = allTypes.length;
            n2 = 0;
            while (n2 < n) {
                type = iTypeArray[n2];
                IType[] iTypeArray2 = this.getAllSuperTypes(type);
                int n3 = iTypeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType superType = iTypeArray2[n4];
                    if (this.containsJUnitTestMethod(superType)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
            return super.containsElementsSearchedFor(file);
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.containsElementsSearchedFor(file);
    }

    protected boolean containsJUnitTestMethod(IType type) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            int flags = method.getFlags();
            if (Modifier.isPublic((int)flags) && !Modifier.isStatic((int)flags) && method.getNumberOfParameters() == 0 && "V".equals(method.getReturnType()) && method.getElementName().startsWith("test")) {
                return true;
            }
            IAnnotation annotation = method.getAnnotation("Test");
            if (annotation.exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IType[] getAllSuperTypes(IType type) throws JavaModelException {
        ITypeHierarchy th = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] superTypes = th.getAllSuperclasses(type);
        return superTypes;
    }
}

