/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.EvaluateMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsArrayImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsValueBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsVariableBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.SubpropertiesMirror;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.AsyncFuture;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

public abstract class JsObjectBase<D>
extends JsValueBase
implements JsObject {
    private final long ref;
    private final String className;
    private final ValueLoader valueLoader;
    private final AtomicReference<AsyncFuture<D>> propertyDataRef = new AtomicReference<Object>(null);

    JsObjectBase(ValueLoader valueLoader, ValueMirror mirror) {
        super(mirror);
        this.valueLoader = valueLoader;
        this.ref = mirror.getRef();
        this.className = mirror.getClassName();
    }

    public Collection<JsVariableBase.Property> getProperties() throws MethodIsBlockingException {
        return this.getBasicPropertyData(true).getPropertyList();
    }

    public Collection<JsVariableBase.Impl> getInternalProperties() throws MethodIsBlockingException {
        return this.getBasicPropertyData(true).getIntenalPropertyList();
    }

    @Override
    public String getRefId() {
        if (this.ref < 0L) {
            return null;
        }
        return String.valueOf(this.ref);
    }

    @Override
    public ValueLoader getRemoteValueMapping() {
        return this.valueLoader;
    }

    @Override
    public JsObjectBase<D> asObject() {
        return this;
    }

    @Override
    public JsVariable getProperty(String name) throws MethodIsBlockingException {
        return this.getBasicPropertyData(true).getPropertyMap().get(name);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public EvaluateMessage.Value getJsonParam(InternalContext hostInternalContext) {
        this.valueLoader.getInternalContext().checkContextIsCompatible(hostInternalContext);
        return EvaluateMessage.Value.createForId(this.ref);
    }

    @Override
    public String getValueString() {
        switch (this.getType()) {
            case TYPE_OBJECT: 
            case TYPE_ARRAY: {
                return "[" + this.getClassName() + "]";
            }
            case TYPE_FUNCTION: {
                return "[Function]";
            }
        }
        return "";
    }

    protected InternalContext getInternalContext() {
        return this.valueLoader.getInternalContext();
    }

    protected long getRef() {
        return this.ref;
    }

    protected D getPropertyData(boolean checkFreshness) throws MethodIsBlockingException {
        if (this.propertyDataRef.get() == null) {
            int currentCacheState = this.getRemoteValueMapping().getCurrentCacheState();
            this.startPropertyLoadOperation(false, currentCacheState);
        } else if (checkFreshness) {
            int currentCacheState = this.getRemoteValueMapping().getCurrentCacheState();
            D result = this.propertyDataRef.get().getSync();
            BasicPropertyData basicPropertyData = this.unwrapBasicData(result);
            if (basicPropertyData.getCacheState() == currentCacheState) {
                return result;
            }
            this.startPropertyLoadOperation(true, currentCacheState);
        }
        return this.propertyDataRef.get().getSync();
    }

    protected BasicPropertyData getBasicPropertyData(boolean checkFreshness) throws MethodIsBlockingException {
        D propertyData = this.getPropertyData(checkFreshness);
        return this.unwrapBasicData(propertyData);
    }

    private void startPropertyLoadOperation(boolean reload, final int currentCacheState) throws MethodIsBlockingException {
        AsyncFuture.SyncOperation blockingOperation = new AsyncFuture.SyncOperation<D>(){

            @Override
            protected D runSync() throws MethodIsBlockingException {
                SubpropertiesMirror subpropertiesMirror = JsObjectBase.this.getRemoteValueMapping().getOrLoadSubproperties(JsObjectBase.this.ref);
                List<JsVariableBase.Property> properties = this.wrapProperties(subpropertiesMirror.getProperties(), JsObjectBase.this.getRef(), PropertyMirrorParser.PROPERTY);
                List<JsVariableBase.Impl> internalProperties = this.wrapProperties(subpropertiesMirror.getInternalProperties(), null, PropertyMirrorParser.VARIABLE);
                BasicPropertyData data = new BasicPropertyData(currentCacheState, properties, internalProperties, subpropertiesMirror);
                return JsObjectBase.this.wrapBasicData(data);
            }

            private <V> List<V> wrapProperties(List<? extends PropertyReference> propertyRefs, Long hostRef, PropertyMirrorParser<V> parser) throws MethodIsBlockingException {
                List<ValueMirror> subMirrors = JsObjectBase.this.valueLoader.getOrLoadValueFromRefs(propertyRefs);
                List wrappedProperties = JsObjectBase.this.createPropertiesFromMirror(subMirrors, propertyRefs, hostRef, parser);
                return Collections.unmodifiableList(wrappedProperties);
            }
        };
        if (reload) {
            AsyncFuture.reinitializeReference(this.propertyDataRef, blockingOperation.asAsyncOperation());
        } else {
            AsyncFuture.initializeReference(this.propertyDataRef, blockingOperation.asAsyncOperation());
        }
        blockingOperation.execute();
    }

    protected abstract D wrapBasicData(BasicPropertyData var1);

    protected abstract BasicPropertyData unwrapBasicData(D var1);

    private <V> List<V> createPropertiesFromMirror(List<ValueMirror> mirrorProperties, List<? extends PropertyReference> propertyRefs, Long hostRef, PropertyMirrorParser<V> parser) {
        ArrayList<V> result = new ArrayList<V>(mirrorProperties.size());
        int i = 0;
        while (i < mirrorProperties.size()) {
            ValueMirror mirror = mirrorProperties.get(i);
            Object varName = propertyRefs.get(i).getName();
            result.add(parser.parse(this.valueLoader, mirror, varName));
            ++i;
        }
        return result;
    }

    protected static class BasicPropertyData {
        private final int cacheState;
        private final List<JsVariableBase.Property> propertyList;
        private final List<JsVariableBase.Impl> intenalPropertyList;
        private final SubpropertiesMirror subpropertiesMirror;
        private volatile Map<String, JsVariableBase> propertyMap = null;

        BasicPropertyData(int cacheState, List<JsVariableBase.Property> propertyList, List<JsVariableBase.Impl> intenalPropertyList, SubpropertiesMirror subpropertiesMirror) {
            this.cacheState = cacheState;
            this.propertyList = propertyList;
            this.intenalPropertyList = intenalPropertyList;
            this.subpropertiesMirror = subpropertiesMirror;
        }

        int getCacheState() {
            return this.cacheState;
        }

        List<JsVariableBase.Property> getPropertyList() {
            return this.propertyList;
        }

        List<JsVariableBase.Impl> getIntenalPropertyList() {
            return this.intenalPropertyList;
        }

        SubpropertiesMirror getSubpropertiesMirror() {
            return this.subpropertiesMirror;
        }

        Map<String, JsVariableBase> getPropertyMap() {
            if (this.propertyMap == null) {
                HashMap<String, JsVariableBase> map = new HashMap<String, JsVariableBase>(this.propertyList.size() * 2, 0.75f);
                for (JsVariableBase jsVariableBase : this.propertyList) {
                    map.put(jsVariableBase.getName(), jsVariableBase);
                }
                this.propertyMap = Collections.unmodifiableMap(Collections.synchronizedMap(map));
            }
            return this.propertyMap;
        }
    }

    public static class Impl
    extends JsObjectBase<BasicPropertyData> {
        Impl(ValueLoader valueLoader, ValueMirror valueState) {
            super(valueLoader, valueState);
        }

        @Override
        public JsArrayImpl asArray() {
            return null;
        }

        @Override
        public JsFunction asFunction() {
            return null;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("[JsObject: type=").append((Object)this.getType());
            try {
                for (JsVariable jsVariable : this.getProperties()) {
                    result.append(',').append(jsVariable);
                }
            }
            catch (MethodIsBlockingException methodIsBlockingException) {
                return "[JsObject: Exception in retrieving data]";
            }
            result.append(']');
            return result.toString();
        }

        @Override
        protected BasicPropertyData wrapBasicData(BasicPropertyData basicPropertyData) {
            return basicPropertyData;
        }

        @Override
        protected BasicPropertyData unwrapBasicData(BasicPropertyData additionalPropertyStore) {
            return additionalPropertyStore;
        }
    }

    private static abstract class PropertyMirrorParser<V> {
        static final PropertyMirrorParser<JsVariableBase.Impl> VARIABLE = new PropertyMirrorParser<JsVariableBase.Impl>(){

            @Override
            JsVariableBase.Impl parse(ValueLoader valueLoader, ValueMirror valueData, Object rawName) {
                return new JsVariableBase.Impl(valueLoader, valueData, rawName);
            }
        };
        static final PropertyMirrorParser<JsVariableBase.Property> PROPERTY = new PropertyMirrorParser<JsVariableBase.Property>(){

            @Override
            JsVariableBase.Property parse(ValueLoader valueLoader, ValueMirror valueData, Object rawName) {
                return new JsVariableBase.Property(valueLoader, valueData, rawName);
            }
        };

        private PropertyMirrorParser() {
        }

        abstract V parse(ValueLoader var1, ValueMirror var2, Object var3);
    }
}

