import { IToggleSkipFileStatusArgs } from '../debugAdapterInterfaces';
import { ChromeConnection } from './chromeConnection';
import { Protocol as Crdp } from 'devtools-protocol';
import { ScriptContainer } from './scripts';
import { Transformers } from './chromeDebugAdapter';
export declare class ScriptSkipper {
    private readonly _chromeConnection;
    private readonly _transformers;
    private _skipFileStatuses;
    private _blackboxedRegexes;
    private readonly chrome;
    constructor(_chromeConnection: ChromeConnection, _transformers: Transformers);
    init(skipFiles: any, skipFileRegExps: any): void;
    toggleSkipFileStatus(args: IToggleSkipFileStatusArgs, scripts: ScriptContainer, transformers: Transformers): Promise<void>;
    resolveSkipFiles(script: Crdp.Debugger.ScriptParsedEvent, mappedUrl: string, sources: string[], toggling?: boolean): Promise<void>;
    private makeRegexesNotSkip(noSkipPath);
    private makeRegexesSkip(skipPath);
    private refreshBlackboxPatterns();
    /**
     * If the source has a saved skip status, return that, whether true or false.
     * If not, check it against the patterns list.
     */
    shouldSkipSource(sourcePath: string): boolean | undefined;
    /**
     * Returns true if this path matches one of the static skip patterns
     */
    private matchesSkipFilesPatterns(sourcePath);
    /**
     * Returns the current skip status for this path, which is either an authored or generated script.
     */
    private getSkipStatus(sourcePath);
    private warnNoSkipFiles();
}
