/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;

public class ExtendToEStructuralFeatureTarget
implements ISearchOperation {
    private final int sourcePosition;
    private final int targetPosition;
    private final EStructuralFeature feature;

    public ExtendToEStructuralFeatureTarget(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.feature.getEContainingClass().getName() + "." + this.feature.getName() + "(+" + variableMapping.apply(this.sourcePosition) + ", -" + variableMapping.apply(this.targetPosition) + ")";
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.targetPosition);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        public Executor(int position) {
            super(position);
        }

        @Override
        public Iterator<?> getIterator(MatchingFrame frame, ISearchContext context) {
            try {
                EObject value = (EObject)frame.getValue(ExtendToEStructuralFeatureTarget.this.sourcePosition);
                if (!ExtendToEStructuralFeatureTarget.this.feature.getEContainingClass().isSuperTypeOf(value.eClass())) {
                    return Collections.emptyIterator();
                }
                Object featureValue = value.eGet(ExtendToEStructuralFeatureTarget.this.feature);
                if (ExtendToEStructuralFeatureTarget.this.feature.isMany()) {
                    if (featureValue != null) {
                        Collection objectCollection = (Collection)featureValue;
                        return objectCollection.iterator();
                    }
                    return Collections.emptyIterator();
                }
                if (featureValue != null) {
                    return Collections.singletonList(featureValue).iterator();
                }
                return Collections.emptyIterator();
            }
            catch (ClassCastException e) {
                throw new LocalSearchException("Invalid feature source in parameter" + Integer.toString(ExtendToEStructuralFeatureTarget.this.sourcePosition), e);
            }
        }

        @Override
        public ISearchOperation getOperation() {
            return ExtendToEStructuralFeatureTarget.this;
        }
    }
}

