/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.internal.etfw.ETFWToolStep;
import org.eclipse.ptp.internal.etfw.IToolLaunchConfigurationDelegate;
import org.eclipse.ptp.internal.etfw.jaxb.data.ExecToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolAppType;
import org.eclipse.ptp.internal.etfw.jaxb.util.ToolAppTypeUtil;
import org.eclipse.ptp.internal.etfw.messages.Messages;

public class ETFWLaunchTool
extends ETFWToolStep
implements IToolLaunchConfigurationConstants {
    private String progPath = null;
    private String application = null;
    private String saveApp = null;
    private String saveArgs = null;
    private String savePath = null;
    private boolean swappedArgs = false;
    private Map<String, String> saveEnv = null;
    private boolean swappedEnv = false;
    private String appnameattrib = null;
    private String apppathattrib = null;
    private String appargattrib = null;
    private ILaunch launch = null;
    private LaunchConfigurationDelegate paraDel = null;
    private ExecToolType tool = null;
    private IBuildLaunchUtils utilBlob = null;

    public ETFWLaunchTool(ILaunchConfiguration conf, ExecToolType etool, String progPath, LaunchConfigurationDelegate pd, ILaunch launcher, IBuildLaunchUtils utilBlob) throws CoreException {
        super(conf, Messages.LauncherTool_RunningApplication, utilBlob);
        this.utilBlob = utilBlob;
        this.launch = launcher;
        this.tool = etool;
        this.paraDel = pd;
        this.appnameattrib = conf.getAttribute("perf_executable_name_tag_for_name_value", null);
        this.apppathattrib = conf.getAttribute("perf_executable_path_tag_for_path_value", null);
        this.appargattrib = conf.getAttribute("perf_framework_attribute_for_arguments_value", null);
        this.progPath = progPath;
    }

    public void cleanup() throws CoreException {
        ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
        if (this.apppathattrib != null && this.savePath != null) {
            confWC.setAttribute(this.apppathattrib, this.savePath);
        }
        if (this.tool != null && this.swappedArgs) {
            confWC.setAttribute(this.appnameattrib, this.saveApp);
            confWC.setAttribute(this.appargattrib, this.saveArgs);
        }
        if (this.tool != null && this.swappedEnv) {
            confWC.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.saveEnv);
        }
        confWC.setAttribute(this.appnameattrib, this.application);
        this.configuration = confWC.doSave();
    }

    private String getDirectory(String path) {
        String projectDir = null;
        IFileStore pdStore = null;
        IFileInfo pdInfo = null;
        if (path != null && (pdInfo = (pdStore = this.utilBlob.getFile(path)).fetchInfo()).exists()) {
            if (!pdInfo.isDirectory()) {
                pdStore = pdStore.getParent();
            }
            projectDir = pdStore.toURI().getPath();
        }
        return projectDir;
    }

    public boolean performLaunch(LaunchConfigurationDelegate paraDel, ILaunch launch, IProgressMonitor monitor) throws Exception {
        try {
            String path = null;
            String prog = null;
            ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
            this.application = confWC.getAttribute(this.appnameattrib, null);
            IFileStore testStore = null;
            if (this.progPath != null) {
                testStore = this.utilBlob.getFile(this.progPath);
            }
            boolean progStoreGood = false;
            IFileStore progStore = null;
            if (this.projectLocation != null && (progStore = this.utilBlob.getFile(this.projectLocation)).fetchInfo().exists() && this.progPath != null && (progStore = progStore.getChild(this.progPath)).fetchInfo().exists()) {
                progStoreGood = true;
            }
            if (testStore != null && testStore.fetchInfo().exists() && !testStore.fetchInfo().isDirectory() || progStoreGood) {
                String jaxbAtt;
                this.savePath = this.apppathattrib != null ? confWC.getAttribute(this.apppathattrib, null) : null;
                if (progStoreGood && (jaxbAtt = confWC.getAttribute("perf_executable_path_tag_for_JAXB_path_value", "")).length() > 0) {
                    confWC.setAttribute(jaxbAtt, progStore.toURI().getPath());
                }
                if (testStore.fetchInfo().exists() && !testStore.fetchInfo().isDirectory()) {
                    confWC.setAttribute(this.apppathattrib, testStore.toURI().getPath());
                    confWC.setAttribute(this.appnameattrib, testStore.getName());
                } else {
                    confWC.setAttribute(this.appnameattrib, this.progPath);
                    if (this.apppathattrib != null) {
                        path = progStore.toURI().getPath();
                        confWC.setAttribute(this.apppathattrib, path);
                    }
                }
            }
            if (this.tool != null) {
                prog = confWC.getAttribute(this.appnameattrib, "");
                boolean usepathforapp = false;
                if ((prog == null || prog.equals("")) && (prog = confWC.getAttribute(this.apppathattrib, "")) != null && !prog.equals("")) {
                    this.savePath = confWC.getAttribute(this.apppathattrib, null);
                    usepathforapp = true;
                }
                String arg = confWC.getAttribute(this.appargattrib, "");
                this.saveApp = prog;
                this.saveArgs = arg;
                LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>();
                if (this.tool.getExecUtils() != null && this.tool.getExecUtils().size() > 0) {
                    String firstExecUtil = this.getToolExecutable((ToolAppType)this.tool.getExecUtils().get(0));
                    if (firstExecUtil == null) {
                        throw new Exception(String.valueOf(Messages.LauncherTool_Tool) + firstExecUtil + Messages.LauncherTool_NotFound);
                    }
                    if (!usepathforapp) {
                        confWC.setAttribute(this.appnameattrib, firstExecUtil);
                    } else {
                        confWC.setAttribute(this.apppathattrib, firstExecUtil);
                    }
                    String otherUtils = this.getToolArguments((ToolAppType)this.tool.getExecUtils().get(0), this.configuration);
                    int i = 1;
                    while (i < this.tool.getExecUtils().size()) {
                        otherUtils = String.valueOf(otherUtils) + " " + this.getToolCommand((ToolAppType)this.tool.getExecUtils().get(i), this.configuration);
                        ++i;
                    }
                    this.swappedArgs = true;
                    String toArgs = otherUtils;
                    if (!this.tool.isReplaceExecution()) {
                        toArgs = String.valueOf(toArgs) + " " + prog + " " + arg;
                    }
                    confWC.setAttribute(this.appargattrib, toArgs);
                    String jaxbAtt = confWC.getAttribute("perf_framework_attribute_for_JAXB_arguments_value", "");
                    if (jaxbAtt != null && jaxbAtt.length() > 0) {
                        confWC.setAttribute(jaxbAtt, toArgs);
                    }
                    if ((jaxbAtt = confWC.getAttribute("perf_executable_path_tag_for_JAXB_path_value", "")) != null && jaxbAtt.length() > 0) {
                        confWC.setAttribute(jaxbAtt, firstExecUtil);
                    }
                    for (ToolAppType toolApp : this.tool.getExecUtils()) {
                        envMap.putAll(ToolAppTypeUtil.getEnvVars((ILaunchConfiguration)this.configuration, (List)toolApp.getToolPanes(), (List)toolApp.getToolArguments()));
                    }
                }
                if (this.tool.getGlobal() != null) {
                    envMap.putAll(ToolAppTypeUtil.getEnvVars((ILaunchConfiguration)this.configuration, (List)this.tool.getGlobal().getToolPanes(), (List)this.tool.getGlobal().getToolArguments()));
                }
                if (envMap.size() > 0) {
                    String wd = this.configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null);
                    String projectDir = null;
                    projectDir = wd != null && wd.length() > 0 ? wd : this.getDirectory(path);
                    if (projectDir == null) {
                        projectDir = this.getDirectory(prog);
                    }
                    if (projectDir == null) {
                        projectDir = ".";
                    }
                    if (projectDir != null) {
                        this.outputLocation = projectDir;
                        Set mapKeys = envMap.keySet();
                        for (String key : mapKeys) {
                            String var = (String)envMap.get(key);
                            if (!var.equals("%%PROJECT_DIR%%")) continue;
                            envMap.put(key, projectDir);
                        }
                    }
                    this.saveEnv = confWC.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                    LinkedHashMap<String, String> newvars = null;
                    newvars = this.saveEnv != null ? new LinkedHashMap<String, String>(this.saveEnv) : new LinkedHashMap<String, String>();
                    newvars.putAll(envMap);
                    this.swappedEnv = true;
                    confWC.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, newvars);
                    confWC.setAttribute("%%PROJECT_DIR%%", projectDir);
                }
            }
            this.configuration = confWC.doSave();
            boolean reRun = launch.isTerminated();
            if (reRun) {
                IProcess[] ip;
                IProcess[] iProcessArray = ip = launch.getProcesses();
                int n = ip.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess p = iProcessArray[n2];
                    launch.removeProcess(p);
                    ++n2;
                }
            }
            if (paraDel instanceof IToolLaunchConfigurationDelegate) {
                ((IToolLaunchConfigurationDelegate)paraDel).setInitialized(true);
            }
            paraDel.launch(this.configuration, "run", launch, monitor);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    if (paraDel instanceof IToolLaunchConfigurationDelegate) {
                        ((IToolLaunchConfigurationDelegate)paraDel).setInitialized(false);
                    }
                    this.cleanup();
                    throw new OperationCanceledException();
                }
                Thread.sleep(1000L);
            }
            return true;
        }
        finally {
            if (paraDel instanceof IToolLaunchConfigurationDelegate) {
                ((IToolLaunchConfigurationDelegate)paraDel).setInitialized(false);
            }
            this.cleanup();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.performLaunch(this.paraDel, this.launch, monitor)) {
                return new Status(2, "com.ibm.jdg2e.concurrency", 2, Messages.LauncherTool_NothingToRun, null);
            }
        }
        catch (Exception e) {
            try {
                this.cleanup();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, Messages.LauncherTool_ExecutionError, (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, Messages.LauncherTool_ExecutionComplete, null);
    }

    public void setSuccessAttribute(String value) {
        if (this.tool != null && this.tool.getSetSuccessAttribute() != null) {
            try {
                ILaunchConfigurationWorkingCopy configuration = this.configuration.getWorkingCopy();
                configuration.setAttribute(this.tool.getSetSuccessAttribute(), value);
                configuration.doSave();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

