/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class StringFileSelector
extends StringEditor {
    private Button browse;
    private Button browseWorkspace;
    private List<String> filterNames;
    private List<String> filterExtensions;
    private boolean allowWorkspace = true;
    private boolean allowFileSystem = true;
    private boolean readOnly = false;

    public StringFileSelector(Composite parent, int style) {
        super(parent, style);
        ((GridLayout)this.getLayout()).numColumns = 5;
        this.browse = factory.createButton((Composite)this, Messages.StringFileSelector_Browse, 8);
        this.browse.setLayoutData((Object)new GridData());
        this.browseWorkspace = factory.createButton((Composite)this, Messages.StringFileSelector_BrowseWorkspace, 8);
        this.browseWorkspace.setLayoutData((Object)new GridData());
        this.filterNames = new LinkedList<String>();
        this.filterExtensions = new LinkedList<String>();
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File file = FileUtil.getFile(StringFileSelector.this.text.getText());
                FileDialog dialog = new FileDialog(StringFileSelector.this.getShell());
                if (StringFileSelector.this.labelText != null) {
                    dialog.setText(StringFileSelector.this.labelText);
                }
                dialog.setFileName(file.getAbsolutePath());
                dialog.setFilterExtensions(StringFileSelector.this.filterExtensions.toArray(new String[StringFileSelector.this.filterExtensions.size()]));
                dialog.setFilterNames(StringFileSelector.this.filterNames.toArray(new String[StringFileSelector.this.filterNames.size()]));
                String result = dialog.open();
                if (result == null) {
                    return;
                }
                StringFileSelector.this.setResult(result);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.browseWorkspace.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object file;
                Object[] result;
                int code;
                LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                try {
                    labelProviderService.startService();
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
                ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                IFile currentFile = FileUtil.getIFile(StringFileSelector.this.text.getText());
                TreeSelectorDialog dialog = new TreeSelectorDialog(StringFileSelector.this.getShell());
                if (StringFileSelector.this.labelText != null) {
                    dialog.setTitle(StringFileSelector.this.labelText);
                }
                WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
                if (!StringFileSelector.this.filterExtensions.isEmpty() && !StringFileSelector.this.filterNames.isEmpty()) {
                    contentProvider.setExtensionFilters(new LinkedHashMap<String, String>());
                    int i = 0;
                    while (i < Math.min(StringFileSelector.this.filterNames.size(), StringFileSelector.this.filterExtensions.size())) {
                        contentProvider.addExtensionFilter(StringFileSelector.this.filterExtensions.get(i), StringFileSelector.this.filterNames.get(i));
                        ++i;
                    }
                }
                dialog.setContentProvider(contentProvider);
                dialog.setLabelProvider(labelProvider);
                if (currentFile != null && currentFile.exists()) {
                    dialog.setInitialSelections(new IFile[]{currentFile});
                }
                if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0 && (file = result[0]) instanceof IFile) {
                    StringFileSelector.this.setResult((IFile)file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setResult(IFile file) {
        this.text.setText(file.getFullPath().toString());
        this.notifyChange();
    }

    protected void setResult(File file) {
        this.text.setText(file.getAbsolutePath());
        this.notifyChange();
    }

    protected void setResult(String path) {
        this.text.setText(path);
        this.notifyChange();
    }

    public void setFilters(String[] filterExtensions, String[] filterNames) {
        if (filterExtensions.length != filterNames.length) {
            Activator.log.warn(Messages.StringFileSelector_0);
        }
        this.setFilterNames(this.getFilterLabels(filterNames, filterExtensions));
        this.setFilterExtensions(filterExtensions);
    }

    protected String[] getFilterLabels(String[] filterNames, String[] filterExtensions) {
        int size = Math.min(filterNames.length, filterExtensions.length);
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = String.valueOf(filterNames[i]) + " (" + filterExtensions[i] + ")";
            ++i;
        }
        return filters;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = Arrays.asList(filterExtensions);
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = Arrays.asList(filterNames);
    }

    public void addFilteredExtension(String filteredExtension, String filterName) {
        if (filteredExtension != null) {
            if (filterName == null) {
                filterName = filteredExtension;
            }
            this.filterExtensions.add(filteredExtension);
            this.filterNames.add(filterName);
        }
    }

    @Override
    public Object getEditableType() {
        return String.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.readOnly = readOnly;
        this.updateButtons();
    }

    public void setAllowWorkspace(boolean allowWorkspace) {
        this.allowWorkspace = allowWorkspace;
        this.updateButtons();
    }

    public void setAllowFileSystem(boolean allowFileSystem) {
        this.allowFileSystem = allowFileSystem;
        this.updateButtons();
    }

    private void updateButtons() {
        boolean enableWorkspace = !this.readOnly && this.allowWorkspace;
        boolean enableFileSystem = !this.readOnly && this.allowFileSystem;
        this.browseWorkspace.setEnabled(enableWorkspace);
        this.browse.setEnabled(enableFileSystem);
    }
}

