/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.phrase;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class SimplePhraseModifier
extends PatternBasedElement {
    private final String delimiter;
    private final DocumentBuilder.SpanType spanType;
    private final Mode mode;

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType, Mode mode) {
        this.delimiter = delimiter;
        this.spanType = spanType;
        this.mode = mode;
    }

    protected String getPattern(int groupOffset) {
        String quotedDelimiter = Pattern.quote(this.delimiter);
        String pattern = quotedDelimiter + " *(.+?) *" + quotedDelimiter;
        return pattern;
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new CodePhraseModifierProcessor();
    }

    public static enum Mode {
        NORMAL,
        SPECIAL,
        NESTING;

    }

    private class CodePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private CodePhraseModifierProcessor() {
        }

        public void emit() {
            String content = this.group(1);
            this.getBuilder().beginSpan(SimplePhraseModifier.this.spanType, new Attributes());
            switch (SimplePhraseModifier.this.mode) {
                case NORMAL: {
                    this.getMarkupLanguage().emitMarkupText(this.parser, this.state, content);
                    break;
                }
                case NESTING: {
                    int contentStart = this.start(1);
                    this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, contentStart, content, 0);
                    break;
                }
                case SPECIAL: {
                    this.getBuilder().charactersUnescaped(content);
                }
            }
            this.getBuilder().endSpan();
        }
    }
}

