/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.views;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class NotesView
extends ViewPart
implements IPartListener,
ISaveablePart,
ISaveablePart2 {
    private static final String NOTES_ENCODING = "UTF8";
    private static final int UNDO_LEVEL = 25;
    private File resource;
    private Action undo;
    private Action redo;
    private Menu menu;
    private Font font;
    private Color hyperlinkColor;
    private MultiPaneEditor editor;
    private TextViewer textViewer;
    private TextViewerUndoManager undoManager;
    private Map<String, NotesViewAction> actions = new HashMap<String, NotesViewAction>();
    long hash;
    boolean modified;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.textViewer = new TextViewer(parent, 17154);
        this.textViewer.setDocument((IDocument)new Document());
        this.textViewer.getControl().setEnabled(false);
        this.textViewer.getTextWidget().setWordWrap(false);
        this.font = JFaceResources.getFont((String)"org.eclipse.mat.ui.notesfont");
        this.textViewer.getControl().setFont(this.font);
        this.hyperlinkColor = JFaceResources.getColorRegistry().get("HYPERLINK_COLOR");
        this.getSite().getPage().addPartListener((IPartListener)this);
        int undolevel = Platform.getPreferencesService().getInt("org.eclipse.ui.editors", "undoHistorySize", 25, null);
        this.undoManager = new TextViewerUndoManager(undolevel);
        this.undoManager.connect((ITextViewer)this.textViewer);
        this.textViewer.setUndoManager((IUndoManager)this.undoManager);
        this.textViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NotesView.this.updateActions();
            }
        });
        this.textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                NotesView.this.modified = true;
                NotesView.this.searchForHyperlinks(NotesView.this.textViewer.getDocument().get(), 0);
                NotesView.this.firePropertyChange(257);
            }
        });
        this.textViewer.setHyperlinkPresenter((IHyperlinkPresenter)new DefaultHyperlinkPresenter(this.hyperlinkColor));
        this.textViewer.setHyperlinkDetectors(new IHyperlinkDetector[]{new ObjectAddressHyperlinkDetector()}, SWT.MOD1);
        this.makeActions();
        this.hookContextMenu();
        this.showBootstrapPart();
        this.updateActions();
    }

    private void updateActions() {
        for (NotesViewAction a : this.actions.values()) {
            a.setEnabled(this.textViewer.canDoOperation(a.actionId));
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NotesView.this.textEditorContextMenuAboutToShow(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.textViewer.getControl());
        this.textViewer.getControl().setMenu(menu);
    }

    private void textEditorContextMenuAboutToShow(IMenuManager manager) {
        if (this.textViewer != null) {
            this.undo.setEnabled(this.undoManager.undoable());
            this.redo.setEnabled(this.undoManager.redoable());
            manager.add((IAction)this.undo);
            manager.add((IAction)this.redo);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.getAction(ActionFactory.CUT.getId()));
            manager.add((IAction)this.getAction(ActionFactory.COPY.getId()));
            manager.add((IAction)this.getAction(ActionFactory.PASTE.getId()));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.getAction(ActionFactory.DELETE.getId()));
            manager.add((IAction)this.getAction(ActionFactory.SELECT_ALL.getId()));
        }
    }

    private NotesViewAction getAction(String actionID) {
        return this.actions.get(actionID);
    }

    private Action addAction(ActionFactory actionFactory, int textOperation, String actionDefinitionId) {
        IWorkbenchWindow window = this.getViewSite().getWorkbenchWindow();
        ActionFactory.IWorkbenchAction globalAction = actionFactory.create(window);
        NotesViewAction action = new NotesViewAction(textOperation, actionDefinitionId);
        this.actions.put(actionFactory.getId(), action);
        action.setText(globalAction.getText());
        action.setToolTipText(globalAction.getToolTipText());
        action.setDescription(globalAction.getDescription());
        action.setImageDescriptor(globalAction.getImageDescriptor());
        action.setDisabledImageDescriptor(globalAction.getDisabledImageDescriptor());
        action.setAccelerator(globalAction.getAccelerator());
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(actionFactory.getId(), (IAction)action);
        return action;
    }

    public void setFocus() {
        this.textViewer.getControl().setFocus();
    }

    public void partActivated(IWorkbenchPart part) {
        if (!this.supportsNotes(part)) {
            return;
        }
        this.textViewer.getControl().setEnabled(true);
        this.editor = (MultiPaneEditor)part;
        File path = this.editor.getResourceFile();
        if (path != null && !path.equals(this.resource)) {
            if (this.isDirty()) {
                this.saveNotes();
            }
            this.resource = path;
            this.updateTextViewer();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }

    public void partClosed(IWorkbenchPart part) {
        if (!this.supportsNotes(part)) {
            return;
        }
        MultiPaneEditor editor = (MultiPaneEditor)part;
        File resource = editor.getResourceFile();
        if (resource.equals(this.resource)) {
            if (this.isDirty()) {
                this.saveNotes();
            }
            this.resource = null;
            this.editor = null;
            this.updateTextViewer();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private void showBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            this.partActivated((IWorkbenchPart)page.getActiveEditor());
        }
    }

    private void makeActions() {
        this.addAction(ActionFactory.CUT, 3, "org.eclipse.ui.edit.cut");
        this.addAction(ActionFactory.COPY, 4, "org.eclipse.ui.edit.copy");
        this.addAction(ActionFactory.PASTE, 5, "org.eclipse.ui.edit.paste");
        this.addAction(ActionFactory.DELETE, 6, "org.eclipse.ui.edit.delete");
        this.addAction(ActionFactory.SELECT_ALL, 7, "org.eclipse.ui.edit.selectAll");
        this.undo = this.addAction(ActionFactory.UNDO, 1, "org.eclipse.ui.edit.undo");
        this.redo = this.addAction(ActionFactory.REDO, 2, "org.eclipse.ui.edit.redo");
    }

    private long hash() {
        CRC32 crc = new CRC32();
        try {
            crc.update(this.textViewer.getDocument().get().getBytes(NOTES_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            return this.textViewer.getDocument().get().hashCode();
        }
        return crc.getValue();
    }

    private void updateTextViewer() {
        if (this.resource != null) {
            String buffer = NotesView.readNotes(this.resource);
            if (buffer != null) {
                Document document = new Document(buffer);
                this.textViewer.setDocument((IDocument)document);
                this.revealEndOfDocument();
            } else {
                this.textViewer.setDocument((IDocument)new Document(""));
            }
        } else {
            this.textViewer.setDocument((IDocument)new Document(""));
            this.textViewer.getControl().setEnabled(false);
        }
        this.hash = this.hash();
        this.modified = false;
        this.firePropertyChange(257);
    }

    private void searchForHyperlinks(String allText, int offset) {
        if (this.resource == null) {
            return;
        }
        Pattern addressPattern = Pattern.compile("0x\\p{XDigit}+");
        String[] fields = allText.split("\\W", 0);
        ArrayList<IdHyperlink> hyperlinks = new ArrayList<IdHyperlink>();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (addressPattern.matcher(field).matches()) {
                Region idRegion = new Region(offset, field.length());
                IdHyperlink hyperlink = new IdHyperlink(field, this.editor, (IRegion)idRegion);
                hyperlinks.add(hyperlink);
            }
            offset = offset + field.length() + 1;
            ++n2;
        }
        if (!hyperlinks.isEmpty()) {
            this.highlightHyperlinks(hyperlinks);
        }
    }

    private void highlightHyperlinks(List<IdHyperlink> hyperlinks) {
        TextPresentation style = new TextPresentation();
        for (IHyperlink iHyperlink : hyperlinks) {
            int startIndex = iHyperlink.getHyperlinkRegion().getOffset();
            int length = iHyperlink.getHyperlinkRegion().getLength();
            StyleRange styleRange = new StyleRange(startIndex, length, this.hyperlinkColor, null, 2);
            styleRange.underline = true;
            style.addStyleRange(styleRange);
        }
        this.textViewer.changeTextPresentation(style, true);
    }

    private void saveNotes() {
        if (this.resource != null) {
            String text = this.textViewer.getDocument().get();
            if (text != null) {
                NotesView.saveNotes(this.resource, text);
            }
            this.resetUndoManager();
            this.hash = this.hash();
            this.modified = false;
        }
    }

    public void dispose() {
        this.undoManager.disconnect();
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.menu != null) {
            this.menu.dispose();
        }
        super.dispose();
    }

    private boolean supportsNotes(IWorkbenchPart part) {
        return part instanceof MultiPaneEditor;
    }

    protected void revealEndOfDocument() {
        IDocument doc = this.textViewer.getDocument();
        int docLength = doc.getLength();
        if (docLength > 0) {
            this.textViewer.revealRange(docLength - 1, 1);
            StyledText widget = this.textViewer.getTextWidget();
            widget.setCaretOffset(docLength);
        }
    }

    public void resetUndoManager() {
        this.undoManager.reset();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readNotes(File resourcePath) {
        try {
            File notesFile;
            if (resourcePath != null && (notesFile = NotesView.getDefaultNotesFile(resourcePath)).exists()) {
                try (FileInputStream fileInput = new FileInputStream(NotesView.getDefaultNotesFile(resourcePath));){
                    String string;
                    BufferedReader myInput = new BufferedReader(new InputStreamReader((InputStream)fileInput, NOTES_ENCODING));
                    try {
                        String s;
                        StringBuffer b = new StringBuffer();
                        while ((s = myInput.readLine()) != null) {
                            b.append(s);
                            b.append("\n");
                        }
                        string = b.toString();
                    }
                    catch (Throwable throwable) {
                        try {
                            myInput.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        myInput.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return string;
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveNotes(File resource, String notes) {
        OutputStream fout = null;
        try {
            try {
                File notesFile = NotesView.getDefaultNotesFile(resource);
                fout = new FileOutputStream(notesFile);
                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fout), NOTES_ENCODING);){
                    out.write(notes);
                    out.flush();
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getDefaultNotesFile(File resource) {
        String filename = resource.getName();
        int p = filename.lastIndexOf(46);
        if (p >= 0) {
            filename = filename.substring(0, p);
        }
        return new File(resource.getParentFile(), String.valueOf(filename) + ".notes.txt");
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveNotes();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.undoManager.undoable() || this.modified && this.hash != this.hash();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    private final class IdHyperlink
    implements IHyperlink {
        String id;
        MultiPaneEditor editor;
        IRegion region;

        public IdHyperlink(String id, MultiPaneEditor editor, IRegion region) {
            this.id = id;
            this.editor = editor;
            this.region = region;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return null;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            try {
                int objectId = this.editor.getQueryContext().mapToObjectId(this.id);
                if (objectId < 0) {
                    return;
                }
                QueryContextMenu contextMenu = new QueryContextMenu(this.editor, new ContextProvider(null){

                    public IContextObject getContext(final Object row) {
                        return new IContextObject(){

                            public int getObjectId() {
                                return (Integer)row;
                            }
                        };
                    }
                });
                PopupMenu popupMenu = new PopupMenu();
                contextMenu.addContextActions(popupMenu, (IStructuredSelection)new StructuredSelection((Object)objectId), null);
                if (NotesView.this.menu != null && !NotesView.this.menu.isDisposed()) {
                    NotesView.this.menu.dispose();
                }
                NotesView.this.menu = popupMenu.createMenu(NotesView.this.getViewSite().getActionBars().getStatusLineManager(), (Control)PlatformUI.getWorkbench().getDisplay().getActiveShell());
                NotesView.this.menu.setVisible(true);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (SnapshotException snapshotException) {
                // empty catch block
            }
        }
    }

    private class NotesViewAction
    extends Action {
        private int actionId;

        NotesViewAction(int actionId, String actionDefinitionId) {
            this.actionId = actionId;
            this.setActionDefinitionId(actionDefinitionId);
        }

        public boolean isEnabled() {
            return NotesView.this.textViewer.canDoOperation(this.actionId);
        }

        public void run() {
            NotesView.this.textViewer.doOperation(this.actionId);
        }
    }

    private class ObjectAddressHyperlinkDetector
    extends AbstractHyperlinkDetector {
        private ObjectAddressHyperlinkDetector() {
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            char ch;
            String text;
            IRegion lineInfo;
            if (region == null || textViewer == null) {
                return null;
            }
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            if (document == null) {
                return null;
            }
            try {
                lineInfo = document.getLineInformationOfOffset(offset);
                text = document.get(lineInfo.getOffset(), lineInfo.getLength());
            }
            catch (BadLocationException ex) {
                return null;
            }
            int index = offset - lineInfo.getOffset();
            do {
                ch = ' ';
                if (--index <= -1) continue;
                ch = text.charAt(index);
            } while (Character.isLetterOrDigit(ch));
            int startIndex = index + 1;
            index = offset - lineInfo.getOffset() - 1;
            while (++index < text.length() && Character.isLetterOrDigit(ch = text.charAt(index))) {
            }
            Pattern addressPattern = Pattern.compile("0x\\p{XDigit}+");
            String address = text.substring(startIndex, index);
            if (address != null && addressPattern.matcher(address).matches()) {
                Region idRegion = new Region(startIndex, address.length());
                return new IHyperlink[]{new IdHyperlink(address, NotesView.this.editor, (IRegion)idRegion)};
            }
            return null;
        }
    }
}

