/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.composites;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.dialogs.EditDependencyDialog;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.m2e.core.ui.internal.util.ParentGatherer;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.MavenEditorPlugin;
import org.eclipse.m2e.editor.composites.DependenciesComparator;
import org.eclipse.m2e.editor.composites.DependencyLabelProvider;
import org.eclipse.m2e.editor.composites.ListEditorComposite;
import org.eclipse.m2e.editor.composites.ListEditorContentProvider;
import org.eclipse.m2e.editor.dialogs.ManageDependenciesDialog;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.m2e.editor.pom.MavenPomEditorPage;
import org.eclipse.m2e.editor.pom.SearchControl;
import org.eclipse.m2e.editor.pom.SearchMatcher;
import org.eclipse.m2e.editor.pom.ValueProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.WorkbenchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DependenciesComposite
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(DependenciesComposite.class);
    protected MavenPomEditorPage editorPage;
    MavenPomEditor pomEditor;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    PropertiesListComposite<Dependency> dependencyManagementEditor;
    DependenciesListComposite<Object> dependenciesEditor;
    private final List<String> temporaryRemovedDependencies = new ArrayList<String>();
    Button dependencySelectButton;
    Action dependencySelectAction;
    SearchControl searchControl;
    SearchMatcher searchMatcher;
    DependencyFilter searchFilter;
    Action openWebPageAction;
    final DependencyLabelProvider dependencyLabelProvider = new DependencyLabelProvider(true);
    final DependencyLabelProvider dependencyManagementLabelProvider = new DependencyLabelProvider();
    protected boolean showInheritedDependencies = false;
    final ListEditorContentProvider<Object> dependenciesContentProvider = new ListEditorContentProvider();
    DependenciesComparator<Object> dependenciesComparator;
    final ListEditorContentProvider<Dependency> dependencyManagementContentProvider = new ListEditorContentProvider();
    DependenciesComparator<Dependency> dependencyManagementComparator;
    private List<Dependency> dependencies;
    private List<Dependency> manageddependencies;
    private final Object MAN_DEP_LOCK = new Object();
    private final Object DEP_LOCK = new Object();

    public DependenciesComposite(Composite composite, MavenPomEditorPage editorPage, int flags, MavenPomEditor pomEditor) {
        super(composite, flags);
        this.editorPage = editorPage;
        this.pomEditor = pomEditor;
        this.createComposite();
        editorPage.initPopupMenu((Viewer)this.dependenciesEditor.getViewer(), ".dependencies");
        editorPage.initPopupMenu((Viewer)this.dependencyManagementEditor.getViewer(), ".dependencyManagement");
    }

    private void createComposite() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.toolkit.adapt((Composite)this);
        SashForm horizontalSash = new SashForm((Composite)this, 0);
        GridData horizontalCompositeGridData = new GridData(4, 4, true, true);
        horizontalCompositeGridData.heightHint = 200;
        horizontalSash.setLayoutData((Object)horizontalCompositeGridData);
        this.toolkit.adapt((Control)horizontalSash, true, true);
        this.createDependenciesSection(horizontalSash);
        this.createDependencyManagementSection(horizontalSash);
        horizontalSash.setWeights(new int[]{1, 1});
    }

    private void createDependenciesSection(SashForm verticalSash) {
        Section dependenciesSection = this.toolkit.createSection((Composite)verticalSash, 256);
        dependenciesSection.marginWidth = 3;
        dependenciesSection.setText(Messages.DependenciesComposite_sectionDependencies);
        this.dependenciesComparator = new DependenciesComparator();
        this.dependenciesContentProvider.setComparator(this.dependenciesComparator);
        this.dependenciesEditor = new DependenciesListComposite((Composite)dependenciesSection, 0, true);
        this.dependenciesEditor.setCellLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.dependencyLabelProvider));
        this.dependenciesEditor.setContentProvider(this.dependenciesContentProvider);
        this.dependenciesEditor.setRemoveButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            List dependencyList = this.dependenciesEditor.getSelection();
            try {
                this.editorPage.performEditOperation(document -> {
                    Element deps = PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencies");
                    if (deps == null) {
                        return;
                    }
                    dependencyList.stream().filter(Dependency.class::isInstance).map(Dependency.class::cast).map(dep -> PomEdits.findChild((Element)deps, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)dep.groupId), PomEdits.childEquals((String)"artifactId", (String)dep.artifactId)})).forEach(dep -> PomEdits.removeChild((Element)deps, (Element)dep));
                    PomEdits.removeIfNoChildElement((Element)deps);
                }, log, "error removing dependencies");
            }
            finally {
                this.setDependenciesInput();
            }
        }));
        this.dependenciesEditor.setPropertiesListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object selection = this.dependenciesEditor.getSelection().get(0);
            if (selection instanceof Dependency var3_4) {
                EditDependencyDialog d = new EditDependencyDialog(this.getShell(), false, this.editorPage.getProject(), this.editorPage.getPomEditor().getMavenProject());
                d.setDependency(this.toApacheDependency((Dependency)dependency));
                if (d.open() == 0) {
                    try {
                        this.editorPage.performEditOperation(d.getEditOperation(), log, "Error updating dependency");
                    }
                    finally {
                        this.setDependenciesInput();
                        this.dependenciesEditor.setSelection(Collections.singletonList(dependency));
                    }
                }
            } else {
                boolean cfr_ignored_0 = selection instanceof org.apache.maven.model.Dependency;
            }
        }));
        dependenciesSection.setClient(this.dependenciesEditor);
        this.toolkit.adapt(this.dependenciesEditor);
        this.toolkit.paintBordersFor(this.dependenciesEditor);
        this.dependenciesEditor.setManageButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                this.openManageDependenciesDialog();
            }
            catch (InterruptedException | InvocationTargetException e1) {
                MavenEditorPlugin.getDefault().getLog().log(Status.error((String)"Error: ", (Throwable)e1));
            }
        }));
        this.dependenciesEditor.setAddButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            MavenRepositorySearchDialog addDepDialog = MavenRepositorySearchDialog.createSearchDependencyDialog((Shell)this.getShell(), (String)Messages.DependenciesComposite_action_selectDependency, (MavenProject)this.editorPage.getPomEditor().getMavenProject(), (IProject)this.editorPage.getProject(), (boolean)false);
            if (addDepDialog.open() == 0) {
                IndexedArtifactFile dep = (IndexedArtifactFile)addDepDialog.getFirstResult();
                String selectedScope = addDepDialog.getSelectedScope();
                try {
                    this.editorPage.performEditOperation(document -> {
                        Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencies"});
                        PomHelper.addOrUpdateDependency((Element)depsEl, (String)indexedArtifactFile.group, (String)indexedArtifactFile.artifact, (String)(this.isManaged(indexedArtifactFile.group, indexedArtifactFile.artifact, indexedArtifactFile.version) ? null : indexedArtifactFile.version), (String)indexedArtifactFile.type, (String)selectedScope, (String)indexedArtifactFile.classifier);
                    }, log, "errror adding dependency");
                }
                finally {
                    this.setDependenciesInput();
                    List<Dependency> deps = this.getDependencies();
                    if (!deps.isEmpty()) {
                        this.dependenciesEditor.setSelection(Collections.singletonList(deps.get(deps.size() - 1)));
                    }
                }
            }
        }));
        ToolBarManager modulesToolBarManager = new ToolBarManager(0x800000);
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_sortAlphabetically, MavenEditorImages.SORT){
            {
                this.setChecked(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependenciesContentProvider.setShouldSort(this.isChecked());
                DependenciesComposite.this.dependenciesEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_showInheritedDependencies, MavenEditorImages.SHOW_INHERITED_DEPENDENCIES){
            {
                this.setChecked(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.showInheritedDependencies = this.isChecked();
                ISelection selection = DependenciesComposite.this.dependenciesEditor.getViewer().getSelection();
                DependenciesComposite.this.setDependenciesInput();
                DependenciesComposite.this.dependenciesEditor.getViewer().refresh();
                DependenciesComposite.this.dependenciesEditor.getViewer().setSelection(selection, true);
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_showgroupid, MavenEditorImages.SHOW_GROUP){
            {
                this.setChecked(false);
                DependenciesComposite.this.dependenciesComparator.setSortByGroups(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependencyLabelProvider.setShowGroupId(this.isChecked());
                DependenciesComposite.this.dependenciesComparator.setSortByGroups(this.isChecked());
                DependenciesComposite.this.dependenciesEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_filter, MavenEditorImages.FILTER){
            {
                this.setChecked(true);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                TableViewer viewer = DependenciesComposite.this.dependenciesEditor.getViewer();
                if (this.isChecked()) {
                    viewer.addFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                } else {
                    viewer.removeFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                }
                viewer.refresh();
                if (this.isChecked()) {
                    DependenciesComposite.this.searchControl.getSearchText().setFocus();
                }
            }
        });
        Composite toolbarComposite = this.toolkit.createComposite((Composite)dependenciesSection);
        GridLayout toolbarLayout = new GridLayout(1, true);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbarComposite.setLayout((Layout)toolbarLayout);
        toolbarComposite.setBackground(null);
        modulesToolBarManager.createControl(toolbarComposite);
        dependenciesSection.setTextClient((Control)toolbarComposite);
    }

    private void createDependencyManagementSection(SashForm verticalSash) {
        Section dependencyManagementSection = this.toolkit.createSection((Composite)verticalSash, 256);
        dependencyManagementSection.marginWidth = 3;
        dependencyManagementSection.setText(Messages.DependenciesComposite_sectionDependencyManagement);
        this.dependencyManagementComparator = new DependenciesComparator();
        this.dependencyManagementContentProvider.setComparator(this.dependencyManagementComparator);
        this.dependencyManagementEditor = new PropertiesListComposite((Composite)dependencyManagementSection, 0, true);
        this.dependencyManagementEditor.setContentProvider(this.dependencyManagementContentProvider);
        this.dependencyManagementEditor.setLabelProvider((ILabelProvider)this.dependencyManagementLabelProvider);
        dependencyManagementSection.setClient(this.dependencyManagementEditor);
        this.dependencyManagementEditor.setRemoveButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            List dependencyList = this.dependencyManagementEditor.getSelection();
            try {
                this.editorPage.performEditOperation(document -> {
                    Element deps = PomEdits.findChild((Element)PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencyManagement"), (String)"dependencies");
                    if (deps == null) {
                        return;
                    }
                    for (Dependency dependency : dependencyList) {
                        Element dep = PomEdits.findChild((Element)deps, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)dependency.groupId), PomEdits.childEquals((String)"artifactId", (String)dependency.artifactId)});
                        PomEdits.removeChild((Element)deps, (Element)dep);
                    }
                    PomEdits.removeIfNoChildElement((Element)deps);
                }, log, "error removing managed dependencies");
            }
            finally {
                this.setDependencyManagementInput();
                this.dependenciesEditor.refresh();
            }
        }));
        this.dependencyManagementEditor.setPropertiesListener(SelectionListener.widgetSelectedAdapter(e -> {
            Dependency dependency = (Dependency)this.dependencyManagementEditor.getSelection().get(0);
            EditDependencyDialog d = new EditDependencyDialog(this.getShell(), true, this.editorPage.getProject(), this.editorPage.getPomEditor().getMavenProject());
            d.setDependency(this.toApacheDependency(dependency));
            if (d.open() == 0) {
                try {
                    this.editorPage.performEditOperation(d.getEditOperation(), log, "Error updating dependency");
                }
                finally {
                    this.setDependencyManagementInput();
                    this.dependencyManagementEditor.setSelection(Collections.singletonList(dependency));
                    this.dependenciesEditor.refresh();
                }
            }
        }));
        this.dependencyManagementEditor.addSelectionListener(event -> {
            List selection = this.dependencyManagementEditor.getSelection();
            if (!selection.isEmpty()) {
                this.dependenciesEditor.setSelection(Collections.emptyList());
            }
        });
        this.toolkit.adapt(this.dependencyManagementEditor);
        this.toolkit.paintBordersFor(this.dependencyManagementEditor);
        this.dependencyManagementEditor.setAddButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            MavenRepositorySearchDialog addDepDialog = MavenRepositorySearchDialog.createSearchDependencyDialog((Shell)this.getShell(), (String)Messages.DependenciesComposite_action_selectDependency, (MavenProject)this.editorPage.getPomEditor().getMavenProject(), (IProject)this.editorPage.getProject(), (boolean)true);
            if (addDepDialog.open() == 0) {
                IndexedArtifactFile dep = (IndexedArtifactFile)addDepDialog.getFirstResult();
                String selectedScope = addDepDialog.getSelectedScope();
                try {
                    this.editorPage.performEditOperation(document -> {
                        Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencyManagement", "dependencies"});
                        PomHelper.addOrUpdateDependency((Element)depsEl, (String)indexedArtifactFile.group, (String)indexedArtifactFile.artifact, (String)indexedArtifactFile.version, (String)indexedArtifactFile.type, (String)selectedScope, (String)indexedArtifactFile.classifier);
                    }, log, "errror adding dependency");
                }
                finally {
                    this.setDependencyManagementInput();
                    List<Dependency> dlist = this.getManagedDependencies();
                    if (!dlist.isEmpty()) {
                        this.dependencyManagementEditor.setSelection(Collections.singletonList(dlist.get(dlist.size() - 1)));
                    }
                    this.dependenciesEditor.refresh();
                }
            }
        }));
        ToolBarManager modulesToolBarManager = new ToolBarManager(0x800000);
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_sortAlphabetically, MavenEditorImages.SORT){
            {
                this.setChecked(false);
                DependenciesComposite.this.dependencyManagementContentProvider.setShouldSort(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependencyManagementContentProvider.setShouldSort(this.isChecked());
                DependenciesComposite.this.dependencyManagementEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_showgroupid, MavenEditorImages.SHOW_GROUP){
            {
                this.setChecked(false);
                DependenciesComposite.this.dependencyManagementComparator.setSortByGroups(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependencyManagementLabelProvider.setShowGroupId(this.isChecked());
                DependenciesComposite.this.dependencyManagementComparator.setSortByGroups(this.isChecked());
                DependenciesComposite.this.dependencyManagementEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_filter, MavenEditorImages.FILTER){
            {
                this.setChecked(true);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                TableViewer viewer = DependenciesComposite.this.dependencyManagementEditor.getViewer();
                if (this.isChecked()) {
                    viewer.addFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                } else {
                    viewer.removeFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                }
                viewer.refresh();
                if (this.isChecked()) {
                    DependenciesComposite.this.searchControl.getSearchText().setFocus();
                }
            }
        });
        Composite toolbarComposite = this.toolkit.createComposite((Composite)dependencyManagementSection);
        GridLayout toolbarLayout = new GridLayout(1, true);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbarComposite.setLayout((Layout)toolbarLayout);
        toolbarComposite.setBackground(null);
        modulesToolBarManager.createControl(toolbarComposite);
        dependencyManagementSection.setTextClient((Control)toolbarComposite);
    }

    public void loadData() {
        this.resetDependencies();
        this.resetManagedDependencies();
        ValueProvider<List<org.apache.maven.model.Dependency>> dmValueProvider = new ValueProvider<List<org.apache.maven.model.Dependency>>(){

            @Override
            public List<org.apache.maven.model.Dependency> getValue() {
                ArrayList<org.apache.maven.model.Dependency> toRet = new ArrayList<org.apache.maven.model.Dependency>();
                for (Dependency d : DependenciesComposite.this.getManagedDependencies()) {
                    toRet.add(DependenciesComposite.this.toApacheDependency(d));
                }
                return toRet;
            }
        };
        this.dependencyLabelProvider.setPomEditor(this.editorPage.getPomEditor(), dmValueProvider);
        this.dependencyManagementLabelProvider.setPomEditor(this.editorPage.getPomEditor(), dmValueProvider);
        this.setDependenciesInput();
        this.setDependencyManagementInput();
        this.dependenciesEditor.setReadOnly(this.editorPage.isReadOnly());
        this.dependencyManagementEditor.setReadOnly(this.editorPage.isReadOnly());
        if (this.searchControl != null) {
            this.searchControl.getSearchText().setEditable(true);
        }
    }

    public void setSearchControl(SearchControl searchControl) {
        if (this.searchControl != null) {
            return;
        }
        this.searchMatcher = new SearchMatcher(searchControl);
        this.searchFilter = new DependencyFilter(this.searchMatcher);
        this.searchControl = searchControl;
        final TableViewer dependenciesViewer = this.dependenciesEditor.getViewer();
        dependenciesViewer.addFilter((ViewerFilter)this.searchFilter);
        final TableViewer dependencyManagementViewer = this.dependencyManagementEditor.getViewer();
        dependencyManagementViewer.addFilter((ViewerFilter)this.searchFilter);
        WorkbenchJob updateJob = new WorkbenchJob("Update Maven Dependency Viewers"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                dependenciesViewer.refresh();
                dependencyManagementViewer.refresh();
                return Status.OK_STATUS;
            }
        };
        this.searchControl.getSearchText().addModifyListener(arg_0 -> DependenciesComposite.lambda$16((Job)updateJob, arg_0));
    }

    void openManageDependenciesDialog() throws InvocationTargetException, InterruptedException {
        ArrayList<ParentHierarchyEntry> hierarchy = new ArrayList<ParentHierarchyEntry>();
        IRunnableWithProgress projectLoader = monitor -> {
            try {
                IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
                IMavenProjectFacade projectFacade = projectManager.create(this.pomEditor.getPomFile(), true, monitor);
                if (projectFacade != null) {
                    hierarchy.addAll(new ParentGatherer(projectFacade).getParentHierarchy(monitor));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(false, true, projectLoader);
        if (hierarchy.isEmpty()) {
            return;
        }
        ManageDependenciesDialog manageDepDialog = new ManageDependenciesDialog(this.getShell(), new ValueProvider<List<org.apache.maven.model.Dependency>>(){

            @Override
            public List<org.apache.maven.model.Dependency> getValue() {
                ArrayList<org.apache.maven.model.Dependency> toRet = new ArrayList<org.apache.maven.model.Dependency>();
                for (Dependency d : DependenciesComposite.this.getDependencies()) {
                    toRet.add(DependenciesComposite.this.toApacheDependency(d));
                }
                return toRet;
            }
        }, hierarchy, this.dependenciesEditor.getSelection());
        manageDepDialog.open();
    }

    protected void setDependencyManagementInput() {
        this.resetManagedDependencies();
        List<Dependency> managed = this.getManagedDependencies();
        this.dependencyManagementEditor.setInput(managed);
    }

    private Dependency toDependency(Element depEl) {
        Dependency dep = new Dependency();
        dep.groupId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"groupId"));
        dep.artifactId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"artifactId"));
        dep.version = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"version"));
        dep.type = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"type"));
        dep.scope = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"scope"));
        dep.classifier = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"classifier"));
        dep.systemPath = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"systemPath"));
        dep.optional = Boolean.parseBoolean(PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"optional")));
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getManagedDependencies() {
        Object object = this.MAN_DEP_LOCK;
        synchronized (object) {
            if (this.manageddependencies == null) {
                this.manageddependencies = new ArrayList<Dependency>();
                try {
                    PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.pomEditor.getDocument(), document -> {
                        Element dms = PomEdits.findChild((Element)PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencyManagement"), (String)"dependencies");
                        for (Element depEl : PomEdits.findChilds((Element)dms, (String)"dependency")) {
                            Dependency dep = this.toDependency(depEl);
                            if (dep == null) continue;
                            this.manageddependencies.add(dep);
                        }
                    }, true)});
                }
                catch (Exception ex) {
                    log.error("Error loading managed dependencies", (Throwable)ex);
                }
            }
            return this.manageddependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetManagedDependencies() {
        Object object = this.MAN_DEP_LOCK;
        synchronized (object) {
            this.manageddependencies = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getDependencies() {
        Object object = this.DEP_LOCK;
        synchronized (object) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Dependency>();
                try {
                    PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.pomEditor.getDocument(), document -> {
                        Element dms = PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencies");
                        for (Element depEl : PomEdits.findChilds((Element)dms, (String)"dependency")) {
                            Dependency dep = this.toDependency(depEl);
                            if (dep == null) continue;
                            this.dependencies.add(dep);
                        }
                    }, true)});
                }
                catch (Exception ex) {
                    log.error("Error loading dependencies", (Throwable)ex);
                }
            }
            return this.dependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDependencies() {
        Object object = this.DEP_LOCK;
        synchronized (object) {
            this.dependencies = null;
        }
    }

    protected void setDependenciesInput() {
        this.resetDependencies();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        deps.addAll(this.getDependencies());
        if (this.showInheritedDependencies) {
            LinkedList allDeps = new LinkedList();
            MavenProject mp = this.pomEditor.getMavenProject();
            if (mp != null) {
                allDeps.addAll(mp.getDependencies());
            }
            for (org.apache.maven.model.Dependency mavenDep : allDeps) {
                boolean found = false;
                Iterator<Dependency> iter = this.getDependencies().iterator();
                while (!found && iter.hasNext()) {
                    Dependency m2eDep = iter.next();
                    if (!mavenDep.getGroupId().equals(m2eDep.groupId) || !mavenDep.getArtifactId().equals(m2eDep.artifactId)) continue;
                    found = true;
                }
                if (found || this.temporaryRemovedDependencies.contains(String.valueOf(mavenDep.getGroupId()) + ":" + mavenDep.getArtifactId())) continue;
                deps.add((Dependency)mavenDep);
            }
        }
        this.dependenciesEditor.setInput(deps);
    }

    public void mavenProjectHasChanged() {
        this.temporaryRemovedDependencies.clear();
        if (this.showInheritedDependencies) {
            this.setDependenciesInput();
        }
        this.dependenciesEditor.refresh();
    }

    private org.apache.maven.model.Dependency toApacheDependency(Dependency dependency) {
        org.apache.maven.model.Dependency toRet = new org.apache.maven.model.Dependency();
        toRet.setArtifactId(dependency.artifactId);
        toRet.setGroupId(dependency.groupId);
        toRet.setClassifier(dependency.classifier);
        toRet.setScope(dependency.scope);
        toRet.setOptional(dependency.optional);
        toRet.setSystemPath(dependency.systemPath);
        toRet.setType(dependency.type);
        toRet.setVersion(dependency.version);
        return toRet;
    }

    private boolean isManaged(String groupId, String artifactId, String version) {
        List managedDep;
        if (version == null) {
            return true;
        }
        DependencyManagement depManagement = this.editorPage.getPomEditor().getMavenProject().getDependencyManagement();
        if (depManagement != null && groupId != null && artifactId != null && (managedDep = depManagement.getDependencies()) != null) {
            for (org.apache.maven.model.Dependency dependency : managedDep) {
                if (!version.equals(dependency.getVersion()) || !artifactId.equals(dependency.getArtifactId()) || !groupId.equals(dependency.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void lambda$16(Job job, ModifyEvent e) {
        job.cancel();
        job.schedule(200L);
    }

    protected class DependenciesListComposite<T>
    extends PropertiesListComposite<T> {
        private static final String MANAGE = "MANAGE";
        protected Button manage;

        public DependenciesListComposite(Composite parent, int style, boolean includeSearch) {
            super(parent, style, includeSearch);
        }

        @Override
        protected void createButtons(boolean includeSearch) {
            super.createButtons(includeSearch);
            this.manage = this.createButton(Messages.DependenciesComposite_manageButton);
            this.addButton(MANAGE, this.manage);
        }

        @Override
        protected void viewerSelectionChanged() {
            super.viewerSelectionChanged();
            this.updateManageButton();
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            super.setReadOnly(readOnly);
            this.updateManageButton();
        }

        @Override
        public void refresh() {
            super.refresh();
            this.updateManageButton();
        }

        protected void updateManageButton() {
            boolean hasNonManaged = false;
            for (Dependency d : DependenciesComposite.this.getDependencies()) {
                if (d.version == null) continue;
                hasNonManaged = true;
                break;
            }
            if (!this.manage.isDisposed()) {
                this.manage.setEnabled(!this.readOnly && hasNonManaged);
            }
        }

        public void setManageButtonListener(SelectionListener listener) {
            this.manage.addSelectionListener(listener);
        }
    }

    class Dependency
    implements IAdaptable {
        String artifactId;
        String groupId;
        String version;
        String type;
        String classifier;
        String scope;
        String systemPath;
        boolean optional;

        public <T> T getAdapter(Class<T> adapter) {
            if (ArtifactKey.class.equals(adapter)) {
                return adapter.cast(new ArtifactKey(this.groupId, this.artifactId, this.version, this.classifier));
            }
            return null;
        }
    }

    public static class DependencyFilter
    extends ViewerFilter {
        private final SearchMatcher searchMatcher;

        public DependencyFilter(SearchMatcher searchMatcher) {
            this.searchMatcher = searchMatcher;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Dependency var4_5) {
                return this.searchMatcher.isMatchingArtifact(d.groupId, d.artifactId);
            }
            if (element instanceof org.apache.maven.model.Dependency var7_7) {
                return this.searchMatcher.isMatchingArtifact(dependency.getGroupId(), dependency.getArtifactId());
            }
            return false;
        }
    }

    protected class PropertiesListComposite<T>
    extends ListEditorComposite<T> {
        private static final String PROPERTIES_BUTTON_KEY = "PROPERTIES";
        protected Button properties;

        public PropertiesListComposite(Composite parent, int style, boolean includeSearch) {
            super(parent, style, includeSearch);
        }

        @Override
        protected void createButtons(boolean includeSearch) {
            if (includeSearch) {
                this.createAddButton();
            }
            this.createRemoveButton();
            this.properties = this.createButton(Messages.ListEditorComposite_btnProperties);
            this.addButton(PROPERTIES_BUTTON_KEY, this.properties);
        }

        public void setPropertiesListener(SelectionListener listener) {
            this.properties.addSelectionListener(listener);
        }

        @Override
        protected void viewerSelectionChanged() {
            super.viewerSelectionChanged();
            this.updatePropertiesButton();
        }

        protected void updatePropertiesButton() {
            boolean enable = !this.viewer.getSelection().isEmpty() && !this.isBadSelection();
            this.properties.setEnabled(!this.readOnly && enable);
        }

        @Override
        protected void updateRemoveButton() {
            boolean enable = !this.viewer.getSelection().isEmpty() && !this.isBadSelection();
            this.getRemoveButton().setEnabled(!this.readOnly && enable);
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            super.setReadOnly(readOnly);
            this.updatePropertiesButton();
        }

        protected boolean isBadSelection() {
            List deps = (List)this.viewer.getInput();
            if (deps == null || deps.isEmpty()) {
                return true;
            }
            boolean bad = false;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            for (Object obj : selection) {
                if (!(obj instanceof org.apache.maven.model.Dependency)) continue;
                bad = true;
                break;
            }
            return bad;
        }
    }
}

