/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.net.Authenticator;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.DockerAuthenticator;
import org.eclipse.linuxtools.internal.docker.core.RegistryInfo;

public class RegistryAccountInfo
extends RegistryInfo
implements IRegistryAccount {
    private final String username;
    private final String email;
    private final char[] password;

    public RegistryAccountInfo(String serverAddress, String username, String email, char[] password, boolean dockerHubRegistry) {
        super(serverAddress, dockerHubRegistry);
        this.username = username;
        this.email = email;
        this.password = password;
    }

    @Override
    public String getRegistryId() {
        return "[username=" + this.username + ", email=" + this.email + ", getServerAddress()=" + this.getServerAddress() + "]";
    }

    @Override
    public boolean isAuthProvided() {
        return this.username != null && this.getPassword() != null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public char[] getPassword() {
        if (this.password != null) {
            return this.password;
        }
        char[] password = null;
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences dockerNode = preferences.node("org.eclipse.linuxtools.docker.ui.accounts");
        String key = String.valueOf(this.getServerAddress()) + "," + this.getUsername() + "," + this.getEmail();
        try {
            password = dockerNode.get(key, null) != null ? dockerNode.get(key, null).toCharArray() : null;
        }
        catch (StorageException storageException) {
            // empty catch block
        }
        return password;
    }

    @Override
    protected void enableDockerAuthenticator() {
        if (this.getUsername() != null && this.getPassword() != null) {
            Authenticator.setDefault(new DockerAuthenticator(this.getUsername(), this.getPassword()));
        }
    }

    @Override
    protected void restoreAuthenticator() {
        IExtension[] extensions = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.net", "authenticator").getExtensions();
        if (extensions.length == 0) {
            return;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return;
        }
        try {
            IConfigurationElement config = configs[0];
            Authenticator original = (Authenticator)config.createExecutableExtension("class");
            Authenticator.setDefault(original);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + Arrays.hashCode(this.password);
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistryAccountInfo other = (RegistryAccountInfo)obj;
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (!Arrays.equals(this.password, other.password)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    @Override
    public String toString() {
        return "RegistryAccountInfo [username=" + this.username + ", email=" + this.email + ", getServerAddress()=" + this.getServerAddress() + ", isDockerHubRegistry()=" + this.isDockerHubRegistry() + ", isVersion2()=" + this.isVersion2() + "]";
    }
}

