/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.finder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.jsf.common.internal.finder.AbstractMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorMatcher<INPUT, VISITTYPE, IDTYPE>
extends AbstractMatcher<INPUT, Collection<? extends VISITTYPE>, IDTYPE> {
    private final MatchingAcceptor _acceptor;

    public VisitorMatcher(IDTYPE id, String displayName, MatchingAcceptor<INPUT, VISITTYPE> acceptor, List<? extends AbstractMatcher.IMatcher> matchers) {
        super(id, displayName, Collections.EMPTY_LIST, matchers);
        this._acceptor = acceptor;
    }

    @Override
    public Collection<? extends VISITTYPE> perform(INPUT input) throws Exception {
        MatchingVisitor visitor = new MatchingVisitor(this.getMatchers());
        this._acceptor.accept(input, visitor);
        return visitor.getFoundMatches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MatchingAcceptor<INPUT, VISITTYPE> {
        private void accept(INPUT input, MatchingVisitor<VISITTYPE> visitor) {
            Collection<VISITTYPE> inputChildren = this.getInputChildren(input);
            this.accept(visitor, inputChildren);
        }

        private void accept(MatchingVisitor<VISITTYPE> visitor, Collection<? extends VISITTYPE> inputChildren) {
            for (VISITTYPE visitable : inputChildren) {
                visitor.visit(visitable);
                this.accept(visitor, this.getVisitableChildren(visitable));
            }
        }

        protected abstract Collection<? extends VISITTYPE> getInputChildren(INPUT var1);

        protected abstract Collection<? extends VISITTYPE> getVisitableChildren(VISITTYPE var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatchingVisitor<VISITTYPE> {
        private final List<AbstractMatcher.IMatcher> _matchers;
        private final List<VISITTYPE> _foundMatches = new ArrayList<VISITTYPE>();

        public MatchingVisitor(List<AbstractMatcher.IMatcher> matcher) {
            this._matchers = matcher;
        }

        public void visit(VISITTYPE visitable) {
            for (AbstractMatcher.IMatcher matcher : this._matchers) {
                if (!matcher.matches(visitable)) continue;
                this._foundMatches.add(visitable);
                break;
            }
        }

        protected final List<VISITTYPE> getFoundMatches() {
            return this._foundMatches;
        }
    }
}

