/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.mvc.fx.parts.FocusFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class DefaultFocusFeedbackPartFactory
implements IFeedbackPartFactory {
    public static final String FOCUS_FEEDBACK_COLOR_PROVIDER = "FOCUS_FEEDBACK_COLOR_PROVIDER";
    public static final Color DEFAULT_FOCUS_FEEDBACK_COLOR = Color.web((String)"#8ec0fc");
    public static final String FOCUS_FEEDBACK_GEOMETRY_PROVIDER = "FOCUS_FEEDBACK_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    @Override
    public List<IFeedbackPart<? extends Node>> createFeedbackParts(List<? extends IVisualPart<? extends Node>> targets, Map<Object, Object> contextMap) {
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        if (targets.size() > 1) {
            throw new IllegalArgumentException("Cannot create feedback for multiple targets.");
        }
        final IVisualPart<? extends Node> target = targets.iterator().next();
        ArrayList<IFeedbackPart<? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<? extends Node>>();
        final Provider focusFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)FOCUS_FEEDBACK_GEOMETRY_PROVIDER));
        if (focusFeedbackGeometryProvider != null) {
            Provider<IGeometry> geometryInSceneProvider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return NodeUtils.localToScene(target.getVisual(), (IGeometry)((IGeometry)focusFeedbackGeometryProvider.get()));
                }
            };
            FocusFeedbackPart part = (FocusFeedbackPart)this.injector.getInstance(FocusFeedbackPart.class);
            part.setGeometryProvider((Provider<? extends IGeometry>)geometryInSceneProvider);
            feedbackParts.add(part);
        }
        return feedbackParts;
    }
}

