/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectionUtils {
    public static final ISelection EMPTY_SELECTION = new EmptySelection();

    public static ISelection getWorkbenchSelection() {
        ISelection result = null;
        IWorkbenchPage page = SelectionUtils.getWorkbenchPage();
        if (page != null) {
            result = page.getSelection();
        }
        return result;
    }

    public static ISelection toSelection(Collection<?> objects) {
        return objects == null ? null : new StructuredSelection(SelectionUtils.toList(objects));
    }

    public static ISelection toSelection(List<?> objects) {
        return objects == null ? null : new StructuredSelection(objects);
    }

    public static <T> ISelection toSelection(T ... objects) {
        return objects == null ? null : new StructuredSelection((Object[])objects);
    }

    public static int getSelectionSize(ISelection selection) {
        int result = 0;
        if (selection != EMPTY_SELECTION) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                result = structuredSelection.size();
            } else if (selection instanceof ISelection) {
                result = selection.isEmpty() ? 0 : 1;
            } else if (selection instanceof Collection) {
                Collection collection = (Collection)selection;
                result = collection.size();
            } else if (selection != null) {
                result = 1;
            }
        }
        return result;
    }

    public static List<Object> getSelectedObjects(ISelection selection) {
        ArrayList<Object> result = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            result = new ArrayList<Object>(structuredSelection.toList());
        } else if (selection instanceof Collection) {
            Collection collection = (Collection)selection;
            result = new ArrayList(collection);
        } else {
            ArrayList<ISelection> list = new ArrayList<ISelection>();
            list.add(selection);
            result = list;
        }
        return result;
    }

    public static Object getSelectedObject(ISelection selection) {
        Object result = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            result = structuredSelection.getFirstElement();
        } else if (selection instanceof Collection) {
            Collection collection = (Collection)selection;
            Iterator i = collection.iterator();
            if (i.hasNext()) {
                result = i.next();
            }
        } else {
            result = selection;
        }
        return result;
    }

    public static ISelection toISelection(List<?> items) {
        return new StructuredSelection(items);
    }

    public static <T> ISelection toISelection(T ... items) {
        return new StructuredSelection((Object[])items);
    }

    public static Iterator<?> getSelectionIterator(ISelection iselection) {
        Iterator result = null;
        if (iselection instanceof IStructuredSelection) {
            result = ((IStructuredSelection)iselection).iterator();
        }
        return result;
    }

    public static String toString(ISelection selection) {
        String result = null;
        if (selection == null) {
            result = "No selection";
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List elements = structuredSelection.toList();
            int size = elements.size();
            if (size == 0) {
                result = "Empty selection";
            } else {
                result = "Selection: ";
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        result = String.valueOf(result) + "\n";
                    }
                    Object o = elements.get(i);
                    String type = o.getClass().getName();
                    String value = o.toString();
                    result = String.valueOf(result) + "[" + i + "]: type= + " + type + ", value='" + value + "'";
                    ++i;
                }
            }
        } else {
            String type = selection.getClass().getName();
            String value = selection.toString();
            result = "Selection: (type = " + type + ") " + value;
        }
        return result;
    }

    public static List<Object> toList(Collection<?> collection) {
        int size = collection == null ? 0 : collection.size();
        ArrayList<Object> result = new ArrayList<Object>(size);
        if (collection != null) {
            result.addAll(collection);
        }
        return result;
    }

    public static IWorkbench getWorkbench() {
        IWorkbench result = null;
        try {
            result = PlatformUI.getWorkbench();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return result;
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbenchWindow result = null;
        IWorkbench workbench = SelectionUtils.getWorkbench();
        if (workbench != null && (result = workbench.getActiveWorkbenchWindow()) == null && workbench.getWorkbenchWindowCount() > 0) {
            result = workbench.getWorkbenchWindows()[0];
        }
        return result;
    }

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window = SelectionUtils.getWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }

    public static class EmptySelection
    implements IStructuredSelection {
        public boolean isEmpty() {
            return true;
        }

        public Iterator<Object> iterator() {
            return new ArrayList().iterator();
        }

        public List<Object> toList() {
            return new ArrayList<Object>();
        }

        public int size() {
            return 0;
        }

        public Object getFirstElement() {
            return null;
        }

        public Object[] toArray() {
            return new Object[0];
        }
    }
}

