/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchElement;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.internal.ui.search.CSearchViewPage;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class CSearchListContentProvider
implements IStructuredContentProvider,
IPDOMSearchContentProvider {
    private TableViewer viewer;
    private CSearchResult result;
    private final CSearchViewPage fPage;

    CSearchListContentProvider(CSearchViewPage page) {
        this.fPage = page;
    }

    public Object[] getElements(Object inputElement) {
        HashSet<String> uncoveredProjects = new HashSet<String>();
        CSearchResult result = (CSearchResult)((Object)inputElement);
        Object[] results = result.getElements();
        ArrayList<CSearchElement> resultList = new ArrayList<CSearchElement>();
        int i = 0;
        while (i < results.length) {
            if (results[i] instanceof CSearchElement) {
                CSearchElement searchElement = (CSearchElement)results[i];
                String path = searchElement.getLocation().getFullPath();
                if (path != null) {
                    uncoveredProjects.add(new Path(path).segment(0));
                }
                if (this.fPage.getDisplayedMatchCount(searchElement) > 0) {
                    resultList.add(searchElement);
                }
            }
            ++i;
        }
        if (result.wasIndexerBusy()) {
            resultList.add((CSearchElement)IPDOMSearchContentProvider.INCOMPLETE_RESULTS_NODE);
        }
        ICProject[] projects = ((CSearchQuery)result.getQuery()).getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            ICProject project = projects[i2];
            boolean foundProject = uncoveredProjects.contains(project.getProject().getName());
            if (!foundProject) {
                if (project.isOpen()) {
                    if (!CCorePlugin.getIndexManager().isProjectIndexed(project)) {
                        resultList.add((CSearchElement)this.createUnindexedProjectWarningElement(project));
                    }
                } else {
                    resultList.add((CSearchElement)this.createClosedProjectWarningElement(project));
                }
            }
            ++i2;
        }
        return resultList.toArray();
    }

    private Status createUnindexedProjectWarningElement(ICProject project) {
        return new Status(2, "org.eclipse.cdt.ui", MessageFormat.format(CSearchMessages.PDOMSearchListContentProvider_IndexerNotEnabledMessageFormat, project.getProject().getName()));
    }

    private Status createClosedProjectWarningElement(ICProject project) {
        return new Status(2, "org.eclipse.cdt.ui", MessageFormat.format(CSearchMessages.PDOMSearchListContentProvider_ProjectClosedMessageFormat, project.getProject().getName()));
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
        this.result = (CSearchResult)((Object)newInput);
        viewer.refresh();
    }

    @Override
    public void elementsChanged(Object[] elements) {
        if (this.result == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (this.fPage.getDisplayedMatchCount(elements[i]) > 0) {
                if (this.viewer.testFindItem(elements[i]) != null) {
                    this.viewer.refresh(elements[i]);
                } else {
                    this.viewer.add(elements[i]);
                }
            } else {
                this.viewer.remove(elements[i]);
            }
            ++i;
        }
    }

    @Override
    public void clear() {
        this.viewer.refresh();
    }
}

