/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.Messages;
import org.eclipse.wst.xsl.launching.config.BaseLaunchHelper;
import org.eclipse.wst.xsl.launching.model.IXSLDebugTarget;
import org.eclipse.wst.xsl.launching.model.XSLDebugElement;
import org.eclipse.wst.xsl.launching.model.XSLStackFrame;
import org.eclipse.wst.xsl.launching.model.XSLThread;
import org.eclipse.wst.xsl.launching.model.XSLValue;
import org.eclipse.wst.xsl.launching.model.XSLVariable;

public class JAXPDebugTarget
extends XSLDebugElement
implements IXSLDebugTarget {
    private final byte[] STACK_FRAMES_LOCK = new byte[0];
    private final byte[] VALUE_MAP_LOCK = new byte[0];
    private final byte[] WRITE_LOCK = new byte[0];
    private static final int CONNECT_ATTEMPTS = 60;
    private static final int CONNECT_WAIT = 1000;
    private final IProcess process;
    private final ILaunch launch;
    private XSLThread thread;
    private IThread[] threads = new IThread[0];
    private IStackFrame[] stackFramesCache = new IStackFrame[0];
    private EventDispatchJob eventDispatch;
    private final Map<Integer, XSLVariable> variableMapCache = new HashMap<Integer, XSLVariable>();
    private final Map<XSLVariable, XSLValue> valueMapCache = new HashMap<XSLVariable, XSLValue>();
    private String name;
    private boolean suspended;
    private Socket requestSocket;
    private Socket eventSocket;
    private Socket generateSocket;
    private BufferedReader requestReader;
    private BufferedReader eventReader;
    private PrintWriter requestWriter;
    private Reader generateReader;
    private boolean stale;

    public JAXPDebugTarget(ILaunch launch, IProcess process, BaseLaunchHelper BaseLaunchHelper2) throws CoreException {
        super(null);
        this.launch = launch;
        this.process = process;
        this.requestSocket = this.attemptConnect(BaseLaunchHelper2.getRequestPort());
        this.eventSocket = this.attemptConnect(BaseLaunchHelper2.getEventPort());
        this.generateSocket = this.attemptConnect(BaseLaunchHelper2.getGeneratePort());
        if (!process.isTerminated()) {
            try {
                this.eventReader = new BufferedReader(new InputStreamReader(this.eventSocket.getInputStream()));
                this.requestWriter = new PrintWriter(this.requestSocket.getOutputStream());
                this.requestReader = new BufferedReader(new InputStreamReader(this.requestSocket.getInputStream()));
                this.generateReader = new InputStreamReader(this.generateSocket.getInputStream());
            }
            catch (IOException e) {
                this.abort(Messages.XSLDebugTarget_0, e);
            }
            this.thread = new XSLThread((IDebugTarget)this);
            this.threads = new IThread[]{this.thread};
            this.eventDispatch = new EventDispatchJob();
            this.eventDispatch.schedule();
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        }
    }

    public Reader getGenerateReader() {
        return this.generateReader;
    }

    private void abort(String message, Throwable e) throws DebugException {
        if (!this.getDebugTarget().isTerminated()) {
            this.getDebugTarget().getProcess().terminate();
        }
        throw new DebugException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 120, message, e));
    }

    private Socket attemptConnect(int port) throws CoreException {
        Socket socket = null;
        int i = 0;
        while (i < 60) {
            if (this.process.isTerminated()) break;
            try {
                socket = new Socket(Messages.XSLDebugTarget_1, port);
            }
            catch (ConnectException connectException) {
            }
            catch (IOException iOException) {}
            if (socket != null) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (socket == null && !this.process.isTerminated()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", String.valueOf(Messages.XSLDebugTarget_2) + port + Messages.XSLDebugTarget_3 + 60 + Messages.XSLDebugTarget_4));
        }
        return socket;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.threads != null && this.threads.length > 0;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            this.name = this.launch.getAttribute("launchName");
        }
        return this.name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals("org.eclipse.wst.xsl.launching.XSLDebugModel") && breakpoint instanceof ILineBreakpoint;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return this.getProcess().canTerminate();
    }

    public boolean isTerminated() {
        return this.getProcess().isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        byte[] byArray = this.WRITE_LOCK;
        synchronized (this.WRITE_LOCK) {
            this.getProcess().terminate();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.sendRequest("resume");
    }

    private void resumed(int detail) {
        this.suspended = false;
        this.thread.fireResumeEvent(detail);
    }

    private void suspended(int detail) {
        this.suspended = true;
        this.thread.fireSuspendEvent(detail);
    }

    public void suspend() throws DebugException {
        this.sendRequest("suspend");
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        block7: {
            if (this.supportsBreakpoint(breakpoint)) {
                try {
                    ILineBreakpoint lb = (ILineBreakpoint)breakpoint;
                    if (!breakpoint.isEnabled()) break block7;
                    try {
                        IMarker marker = lb.getMarker();
                        if (marker != null) {
                            URL file = marker.getResource().getLocation().toFile().toURI().toURL();
                            this.sendRequest("add " + file + " " + lb.getLineNumber());
                        }
                    }
                    catch (CoreException e) {
                        JAXPLaunchingPlugin.log(e);
                    }
                    catch (MalformedURLException e) {
                        JAXPLaunchingPlugin.log(e);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                ILineBreakpoint lb = (ILineBreakpoint)breakpoint;
                IMarker marker = lb.getMarker();
                if (marker != null) {
                    URL file = marker.getResource().getLocation().toFile().toURI().toURL();
                    this.sendRequest("remove " + file + " " + lb.getLineNumber());
                }
            }
            catch (CoreException e) {
                JAXPLaunchingPlugin.log(e);
            }
            catch (MalformedURLException e) {
                JAXPLaunchingPlugin.log(e);
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    private void ready() {
        this.fireCreationEvent();
        this.installDeferredBreakpoints();
        try {
            this.sendRequest("start");
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.wst.xsl.launching.XSLDebugModel");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint element = iBreakpointArray[n2];
            this.breakpointAdded(element);
            ++n2;
        }
    }

    private void terminated() {
        this.suspended = true;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.threads = new IThread[0];
        this.fireTerminateEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStackFrame[] getStackFrames() throws DebugException {
        byte[] byArray = this.STACK_FRAMES_LOCK;
        synchronized (this.STACK_FRAMES_LOCK) {
            if (this.stale) {
                this.stale = false;
                String framesData = this.sendRequest("stack");
                String[] frames = framesData.split("\\$\\$\\$");
                IStackFrame[] sf = new IStackFrame[frames.length];
                List<IStackFrame> currentFrames = Arrays.asList(this.stackFramesCache);
                int i = 0;
                while (i < frames.length) {
                    String data = frames[i];
                    XSLStackFrame frame = new XSLStackFrame(this.thread, data, i);
                    int index = currentFrames.indexOf(frame);
                    if (index != -1) {
                        XSLStackFrame curr = (XSLStackFrame)currentFrames.get(index);
                        curr.setLineNumber(frame.getLineNumber());
                        curr.setVariables(frame.getVariables());
                        frame = curr;
                    }
                    sf[frames.length - i - 1] = frame;
                    ++i;
                }
                this.stackFramesCache = sf;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.stackFramesCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ressetStackFramesCache() {
        this.stale = true;
        byte[] byArray = this.VALUE_MAP_LOCK;
        synchronized (this.VALUE_MAP_LOCK) {
            this.valueMapCache.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stepOver() throws DebugException {
        this.sendRequest("step over");
    }

    public void stepInto() throws DebugException {
        this.sendRequest("step into");
    }

    public void stepReturn() throws DebugException {
        this.sendRequest("step return");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSLVariable getVariable(int varId) throws DebugException {
        Map<Integer, XSLVariable> map = this.variableMapCache;
        synchronized (map) {
            XSLVariable var = this.variableMapCache.get(varId);
            if (var == null) {
                var = new XSLVariable((IDebugTarget)this, varId);
                String res = this.sendRequest("var " + varId);
                String[] data = res.split("&");
                var.setScope(data[0]);
                var.setName(data[1]);
                this.variableMapCache.put(varId, var);
            }
            return var;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getVariableValue(XSLVariable variable) throws DebugException {
        byte[] byArray = this.VALUE_MAP_LOCK;
        synchronized (this.VALUE_MAP_LOCK) {
            XSLValue value = this.valueMapCache.get(variable);
            if (value == null) {
                if (this.isSuspended()) {
                    String res = this.sendRequest("value " + variable.getId());
                    String[] data = res.split("&");
                    String type = data[0];
                    String theval = data.length > 1 ? data[1] : "";
                    value = new XSLValue((IDebugTarget)this, type, theval);
                    this.valueMapCache.put(variable, value);
                } else {
                    value = new XSLValue((IDebugTarget)this, "G", "");
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(String request) throws DebugException {
        String response = null;
        byte[] byArray = this.WRITE_LOCK;
        synchronized (this.WRITE_LOCK) {
            this.requestWriter.println(request);
            this.requestWriter.flush();
            try {
                response = this.requestReader.readLine();
            }
            catch (IOException e) {
                this.abort(String.valueOf(Messages.XSLDebugTarget_19) + request, e);
            }
            return response;
        }
    }

    private void breakpointHit(String event) {
        int lastSpace = event.lastIndexOf(32);
        if (lastSpace > 0) {
            IBreakpoint[] breakpoints;
            String line = event.substring(lastSpace + 1);
            int lineNumber = Integer.parseInt(line);
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.wst.xsl.launching.XSLDebugModel");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof ILineBreakpoint) {
                    ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
                    try {
                        if (lineBreakpoint.getLineNumber() == lineNumber) {
                            this.thread.setBreakpoints(new IBreakpoint[]{breakpoint});
                            break;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n2;
            }
        }
        this.suspended(16);
    }

    private class EventDispatchJob
    extends Job {
        public EventDispatchJob() {
            super(Messages.XSLDebugTarget_20);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            String event = "";
            while (!JAXPDebugTarget.this.isTerminated() && event != null) {
                try {
                    event = JAXPDebugTarget.this.eventReader.readLine();
                    if (event == null) continue;
                    JAXPDebugTarget.this.thread.setBreakpoints(null);
                    JAXPDebugTarget.this.thread.setStepping(false);
                    if (event.equals("ready")) {
                        JAXPDebugTarget.this.ready();
                        continue;
                    }
                    if (event.equals("stopped")) {
                        try {
                            JAXPDebugTarget.this.terminate();
                        }
                        catch (DebugException debugException) {}
                        continue;
                    }
                    if (event.equals("terminated")) {
                        JAXPDebugTarget.this.terminated();
                        continue;
                    }
                    if (event.startsWith("resumed")) {
                        if (event.endsWith("step")) {
                            JAXPDebugTarget.this.thread.setStepping(true);
                            JAXPDebugTarget.this.resumed(2);
                            continue;
                        }
                        if (event.endsWith("client")) {
                            JAXPDebugTarget.this.resumed(32);
                            continue;
                        }
                        this.debugEventMsg(event);
                        continue;
                    }
                    if (event.startsWith("suspended")) {
                        JAXPDebugTarget.this.ressetStackFramesCache();
                        if (event.endsWith("client")) {
                            JAXPDebugTarget.this.suspended(32);
                            continue;
                        }
                        if (event.endsWith("step")) {
                            JAXPDebugTarget.this.suspended(8);
                            continue;
                        }
                        if (event.indexOf("breakpoint") >= 0) {
                            JAXPDebugTarget.this.breakpointHit(event);
                            continue;
                        }
                        this.debugEventMsg(event);
                        continue;
                    }
                    this.debugEventMsg(event);
                }
                catch (IOException iOException) {
                    JAXPDebugTarget.this.terminated();
                }
            }
            return Status.OK_STATUS;
        }

        private void debugEventMsg(String event) {
        }
    }
}

