/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.debugger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.Breakpoint;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.ScriptSource;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.StackFrame;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;

public class ContextData {
    private static final int CONTEXT_RUNNING = 0;
    private static final int CONTEXT_SUSPENDED = 1;
    private static final int STEP_CONTINUE = 0;
    private static final int STEP_IN = 1;
    private static final int STEP_NEXT = 2;
    private static final int STEP_OUT = 4;
    private final Long threadId;
    private final Long contextId;
    private final RhinoDebuggerImpl debugger;
    private final LinkedList frames = new LinkedList();
    private int contextState = 0;
    private int stepState = 0;
    private StackFrame stepFrame;

    public ContextData(Long threadId, Long contextId, RhinoDebuggerImpl debugger) {
        this.threadId = threadId;
        this.contextId = contextId;
        this.debugger = debugger;
    }

    public Long getId() {
        return this.contextId;
    }

    public synchronized List getFrameIds() {
        ArrayList<Long> result = new ArrayList<Long>();
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            result.add(((StackFrame)iterator.next()).getId());
        }
        return result;
    }

    public synchronized StackFrame getFrame(Long frameId) {
        StackFrame frame2 = null;
        for (StackFrame frame2 : this.frames) {
            if (!frame2.getId().equals(frameId)) continue;
            return frame2;
        }
        return null;
    }

    public synchronized void pushFrame(StackFrame frame, ScriptSource script, Integer lineNumber, String functionName) {
        this.frames.addFirst(frame);
        Breakpoint breakpoint = script.getBreakpoint(lineNumber, functionName);
        boolean isStepBreak = this.stepBreak(1);
        if ((isStepBreak || breakpoint != null) && this.sendBreakEvent(script, frame.getLineNumber(), functionName, breakpoint, isStepBreak, false)) {
            this.suspendState();
        }
    }

    private boolean stepBreak(int step) {
        return (step & this.stepState) != 0 && (this.stepFrame == null || this.stepFrame == this.frames.getFirst());
    }

    private void suspendState() {
        this.contextState = 1;
        while (this.contextState == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void popFrame(boolean byThrow, Object resultOrException) {
        if (!this.frames.isEmpty()) {
            boolean isStepBreak;
            StackFrame frame = (StackFrame)this.frames.removeFirst();
            if (this.stepFrame == frame) {
                this.stepFrame = null;
                this.stepState = 4;
            }
            if ((isStepBreak = this.stepBreak(5)) && (frame = this.getTopFrame()) != null && this.sendBreakEvent(frame.getScript(), frame.getLineNumber(), null, null, isStepBreak, false)) {
                this.suspendState();
            }
        }
    }

    public synchronized void resume(String stepType) {
        block10: {
            try {
                if (stepType == null) {
                    this.stepState = 0;
                    this.stepFrame = null;
                    break block10;
                }
                if (stepType.equals("in")) {
                    this.stepState = 1;
                    this.stepFrame = null;
                    break block10;
                }
                if (stepType.equals("next")) {
                    this.stepState = 2;
                    this.stepFrame = this.getTopFrame();
                    break block10;
                }
                if (stepType.equals("out")) {
                    if (this.frames.size() > 1) {
                        this.stepState = 4;
                        this.stepFrame = (StackFrame)this.frames.get(1);
                    } else {
                        this.stepState = 0;
                        this.stepFrame = null;
                    }
                    break block10;
                }
                if (stepType.equals("any")) {
                    this.stepState = 7;
                    this.stepFrame = null;
                    break block10;
                }
                throw new IllegalStateException("bad stepType: " + stepType);
            }
            finally {
                this.contextState = 0;
                this.notifyAll();
            }
        }
    }

    private StackFrame getTopFrame() {
        if (this.frames != null && !this.frames.isEmpty()) {
            return (StackFrame)this.frames.getFirst();
        }
        return null;
    }

    public synchronized void suspend() {
        this.stepState = 7;
        this.stepFrame = null;
    }

    public synchronized void debuggerStatement(ScriptSource script, Integer lineNumber) {
        boolean isStepBreak;
        Breakpoint breakpoint = script.getBreakpoint(lineNumber, null);
        if (this.sendBreakEvent(script, lineNumber, null, breakpoint, isStepBreak = this.stepBreak(3), true)) {
            this.suspendState();
        }
    }

    public synchronized void lineChange(ScriptSource script, Integer lineNumber) {
        Breakpoint breakpoint = script.getBreakpoint(lineNumber, null);
        boolean isStepBreak = this.stepBreak(3);
        if ((isStepBreak || breakpoint != null) && this.sendBreakEvent(script, lineNumber, null, breakpoint, isStepBreak, false)) {
            this.suspendState();
        }
    }

    public synchronized void exceptionThrown(Throwable ex) {
        StackFrame frame = this.getTopFrame();
        if (this.sendExceptionEvent(frame.getScript(), frame.getLineNumber(), ex)) {
            this.suspendState();
        }
    }

    private boolean sendExceptionEvent(ScriptSource script, Integer lineNumber, Throwable ex) {
        EventPacket exceptionEvent = new EventPacket("exception");
        Map body = exceptionEvent.getBody();
        body.put("contextId", this.contextId);
        body.put("threadId", this.threadId);
        body.put("scriptId", script.getId());
        body.put("line", lineNumber);
        body.put("message", ex.getMessage());
        return this.debugger.sendEvent(exceptionEvent);
    }

    private boolean sendBreakEvent(ScriptSource script, Integer lineNumber, String functionName, Breakpoint breakpoint, boolean isStepBreak, boolean isDebuggerStatement) {
        EventPacket breakEvent = new EventPacket("break");
        Map body = breakEvent.getBody();
        body.put("threadId", this.threadId);
        body.put("contextId", this.contextId);
        body.put("scriptId", script.getId());
        if (functionName != null) {
            body.put("functionName", functionName);
        }
        body.put("line", lineNumber);
        if (breakpoint != null) {
            body.put("breakpoint", breakpoint.breakpointId);
        }
        if (isStepBreak) {
            String stepType = this.stepState == 1 ? "in" : (this.stepState == 2 ? "next" : (this.stepState == 4 ? "out" : "suspend"));
            body.put("step", stepType);
            this.stepState = 0;
        }
        body.put("debuggerStatement", isDebuggerStatement);
        return this.debugger.sendEvent(breakEvent);
    }

    public synchronized void scriptLoaded(ScriptSource script) {
        if (this.sendScriptEvent(script)) {
            this.suspendState();
        }
    }

    private boolean sendScriptEvent(ScriptSource script) {
        EventPacket scriptEvent = new EventPacket("script");
        Map body = scriptEvent.getBody();
        body.put("threadId", this.threadId);
        body.put("contextId", this.contextId);
        body.put("scriptId", script.getId());
        return this.debugger.sendEvent(scriptEvent);
    }

    public synchronized String getState() {
        return this.contextState == 0 ? "running" : "suspended";
    }

    public Long getThreadId() {
        return this.threadId;
    }
}

