/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

import org.apache.commons.lang.ObjectUtils;

public final class Pair<L, R> {
    private final L left;
    private final R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return ObjectUtils.equals(this.getLeft(), other.getLeft()) && ObjectUtils.equals(this.getRight(), other.getRight());
    }

    public int hashCode() {
        int hLeft = this.getLeft() == null ? 0 : this.getLeft().hashCode();
        int hRight = this.getRight() == null ? 0 : this.getRight().hashCode();
        return hLeft + 37 * hRight;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public static <L, R> Pair<L, R> create(L left, R right) {
        return new Pair<L, R>(left, right);
    }
}

