/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfigurable;
import org.eclipse.wb.internal.core.model.nonvisual.CollectorObjectInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;

public class FlowContainerGroupInfo
extends CollectorObjectInfo {
    private final JavaInfo m_component;
    ArrayList<FlowContainerConfigurable> m_containers = Lists.newArrayList();

    public FlowContainerGroupInfo(AstEditor editor, JavaInfo javaInfo, String caption) throws Exception {
        super(editor, caption);
        this.m_component = javaInfo;
        this.m_component.addChild(this);
    }

    @Override
    public List<ObjectInfo> getItems() {
        ArrayList list = Lists.newArrayList();
        List<JavaInfo> children = this.m_component.getChildrenJava();
        block0: for (JavaInfo child : children) {
            for (FlowContainerConfigurable container : this.m_containers) {
                if (!container.validateComponent((Object)child)) continue;
                list.add(child);
                continue block0;
            }
        }
        return list;
    }

    @Override
    public void addItem(ObjectInfo item) throws Exception {
        this.error("addItem(ObjectInfo)");
    }

    @Override
    protected void addItem(int index, ObjectInfo item) throws Exception {
        this.error("addItem(int,ObjectInfo)");
    }

    @Override
    protected void removeItem(ObjectInfo item) throws Exception {
        this.error("removeItem(ObjectInfo)");
    }

    private void error(String operation) throws Exception {
        throw new Exception("Operation '" + operation + "' not allowed.");
    }

    public List<FlowContainerConfigurable> getContainers() {
        return Collections.unmodifiableList(this.m_containers);
    }

    public void addContainer(FlowContainerConfigurable container) {
        this.m_containers.add(container);
    }

    public boolean removeContainer(FlowContainerConfigurable container) {
        return this.m_containers.remove(container);
    }
}

