/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.internal.engine;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.internal.engine.ListenerContainer;

public final class LifecycleProvider
extends ListenerContainer<ViatraQueryEngineLifecycleListener>
implements ViatraQueryEngineLifecycleListener {
    private final Logger logger;

    public LifecycleProvider(AdvancedViatraQueryEngine queryEngine, Logger logger) {
        this.logger = logger;
    }

    @Override
    protected void listenerAdded(ViatraQueryEngineLifecycleListener listener) {
        this.logger.debug((Object)("Lifecycle listener " + listener + " added to engine."));
    }

    @Override
    protected void listenerRemoved(ViatraQueryEngineLifecycleListener listener) {
        this.logger.debug((Object)("Lifecycle listener " + listener + " removed from engine."));
    }

    @Override
    public void matcherInstantiated(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
        if (!this.listeners.isEmpty()) {
            for (ViatraQueryEngineLifecycleListener listener : new ArrayList(this.listeners)) {
                try {
                    listener.matcherInstantiated(matcher);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("VIATRA Query encountered an error in delivering matcher initialization notification to listener " + listener + "."), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void engineBecameTainted(String description, Throwable t) {
        if (!this.listeners.isEmpty()) {
            for (ViatraQueryEngineLifecycleListener listener : new ArrayList(this.listeners)) {
                try {
                    listener.engineBecameTainted(description, t);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("VIATRA Query encountered an error in delivering engine tainted notification to listener " + listener + "."), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void engineWiped() {
        if (!this.listeners.isEmpty()) {
            for (ViatraQueryEngineLifecycleListener listener : new ArrayList(this.listeners)) {
                try {
                    listener.engineWiped();
                }
                catch (Exception ex) {
                    this.logger.error((Object)("VIATRA Query encountered an error in delivering engine wiped notification to listener " + listener + "."), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void engineDisposed() {
        if (!this.listeners.isEmpty()) {
            for (ViatraQueryEngineLifecycleListener listener : new ArrayList(this.listeners)) {
                try {
                    listener.engineDisposed();
                }
                catch (Exception ex) {
                    this.logger.error((Object)("VIATRA Query encountered an error in delivering engine disposed notification to listener " + listener + "."), (Throwable)ex);
                }
            }
        }
    }
}

