/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.telnet.connector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.provisional.api.AbstractSettingsPage;
import org.eclipse.tm.terminal.connector.telnet.connector.NetworkPortMap;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetMessages;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetSettings;

public class TelnetSettingsPage
extends AbstractSettingsPage {
    Text fHostText;
    Combo fNetworkPortCombo;
    Text fTimeout;
    Combo fEndOfLineCombo;
    private final TelnetSettings fTerminalSettings;

    public TelnetSettingsPage(TelnetSettings settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        this.fTerminalSettings.setHost(this.fHostText.getText());
        this.fTerminalSettings.setTimeout(this.fTimeout.getText());
        this.fTerminalSettings.setNetworkPort(this.getNetworkPort());
        this.fTerminalSettings.setEndOfLine(this.getEndOfLine());
    }

    public void loadSettings() {
        if (this.fTerminalSettings != null) {
            this.setHost(this.fTerminalSettings.getHost());
            this.setTimeout(this.fTerminalSettings.getTimeoutString());
            this.setNetworkPort(this.fTerminalSettings.getNetworkPortString());
            this.setEndOfLine(this.fTerminalSettings.getEndOfLine());
        }
    }

    private void setHost(String strHost) {
        if (strHost == null) {
            strHost = "";
        }
        this.fHostText.setText(strHost);
    }

    private void setTimeout(String timeout) {
        if (timeout == null || timeout.length() == 0) {
            timeout = "5";
        }
        this.fTimeout.setText(timeout);
    }

    private void setNetworkPort(String strNetworkPort) {
        if (strNetworkPort != null) {
            int nIndex;
            String strPortName = this.getNetworkPortMap().findPortName(strNetworkPort);
            if (strPortName == null) {
                strPortName = strNetworkPort;
            }
            if ((nIndex = this.fNetworkPortCombo.indexOf(strPortName)) == -1) {
                this.fNetworkPortCombo.setText(strNetworkPort);
            } else {
                this.fNetworkPortCombo.select(nIndex);
            }
        }
    }

    private String getNetworkPort() {
        String portText = this.fNetworkPortCombo.getText().trim();
        String mappedPort = this.getNetworkPortMap().findPort(portText);
        return mappedPort != null ? mappedPort : portText;
    }

    private NetworkPortMap getNetworkPortMap() {
        return this.fTerminalSettings.getProperties().getNetworkPortMap();
    }

    private void setEndOfLine(String eol) {
        int idx = this.fEndOfLineCombo.indexOf(eol);
        this.fEndOfLineCombo.select(idx >= 0 ? idx : 0);
    }

    private String getEndOfLine() {
        return this.fEndOfLineCombo.getText();
    }

    public boolean validateSettings() {
        String message = null;
        int messageType = 0;
        boolean valid = true;
        if (this.fHostText.getText().trim().length() == 0) {
            String m = "Please enter a host IP or name.";
            int mt = 1;
            this.updateControlDecoration((Control)this.fHostText, m, mt);
            if (mt > messageType) {
                message = m;
                messageType = mt;
            }
            valid = false;
        } else {
            this.updateControlDecoration((Control)this.fHostText, null, 0);
        }
        try {
            int mt;
            int p = Integer.parseInt(this.getNetworkPort());
            if (p <= 0 || p > 65535) {
                String m = "Invalid network port. Must be between 0 and 65535.";
                mt = 3;
                this.updateControlDecoration((Control)this.fNetworkPortCombo, m, mt);
                if (mt > messageType) {
                    message = m;
                    messageType = mt;
                }
                valid = false;
            } else {
                this.updateControlDecoration((Control)this.fNetworkPortCombo, null, 0);
            }
            p = Integer.parseInt(this.fTimeout.getText().trim());
            if (p < 0) {
                String m = "Invalid timeout. Must be greater than 0.";
                mt = 3;
                this.updateControlDecoration((Control)this.fTimeout, m, mt);
                if (mt > messageType) {
                    message = m;
                    messageType = mt;
                }
                valid = false;
            } else {
                this.updateControlDecoration((Control)this.fTimeout, null, 0);
            }
        }
        catch (Exception e) {
            valid = false;
        }
        this.setMessage(message, messageType);
        return valid;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(String.valueOf(TelnetMessages.HOST) + ":");
        gridData = new GridData(768);
        this.fHostText = new Text(composite, 2048);
        this.fHostText.setLayoutData((Object)gridData);
        this.fHostText.addModifyListener(e -> this.fireListeners((Control)this.fHostText));
        this.createControlDecoration((Control)this.fHostText);
        ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(String.valueOf(TelnetMessages.PORT) + ":");
        gridData = new GridData(768);
        this.fNetworkPortCombo = new Combo(composite, 4);
        this.fNetworkPortCombo.setLayoutData((Object)gridData);
        this.fNetworkPortCombo.addModifyListener(e -> this.fireListeners((Control)this.fNetworkPortCombo));
        this.fNetworkPortCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TelnetSettingsPage.this.fireListeners((Control)TelnetSettingsPage.this.fNetworkPortCombo);
            }
        });
        this.createControlDecoration((Control)this.fNetworkPortCombo);
        List<String> table = this.getNetworkPortMap().getNameTable();
        Collections.sort(table);
        this.loadCombo(this.fNetworkPortCombo, table);
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.TIMEOUT) + ":");
        this.fTimeout = new Text(composite, 2048);
        this.fTimeout.setLayoutData((Object)new GridData(768));
        this.fTimeout.addModifyListener(e -> this.fireListeners((Control)this.fTimeout));
        this.createControlDecoration((Control)this.fTimeout);
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.END_OF_LINE) + ":");
        gridData = new GridData(768);
        this.fEndOfLineCombo = new Combo(composite, 12);
        this.fEndOfLineCombo.setLayoutData((Object)gridData);
        this.fEndOfLineCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TelnetSettingsPage.this.fireListeners((Control)TelnetSettingsPage.this.fEndOfLineCombo);
            }
        });
        this.loadCombo(this.fEndOfLineCombo, Arrays.asList("CR+NUL", "CR+LF"));
        this.loadSettings();
    }

    private void loadCombo(Combo ctlCombo, List<String> table) {
        for (String label : table) {
            ctlCombo.add(label);
        }
    }
}

