/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.MergeTypedElement;

public class RemoteTypedElement
extends MergeTypedElement {
    public RemoteTypedElement(IFSTreeNode node) {
        super(node);
    }

    protected InputStream createStream() throws CoreException {
        try {
            return this.node.getLocationURL().openStream();
        }
        catch (IOException e) {
            Status error = new Status(4, UIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)error);
        }
    }

    public void cacheContents(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        BufferedOutputStream output = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        output = new BufferedOutputStream(baos);
        if (this.node.operationDownload((OutputStream)output).run(monitor).isOK()) {
            this.setContent(baos.toByteArray());
        }
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.node.getLocationURI().toString();
    }
}

